/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.Value;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.util.ChainedResourceResolver;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.ResourceResolver;
import com.tangosol.util.SimpleResourceResolver;

public class ResourceResolverHelper {
    public static ResourceResolver resourceResolverFrom(MapBuilder.Dependencies dependencies) {
        ConfigurableCacheFactory ccf;
        BackingMapManagerContext ctxBackingMapManager;
        SimpleResourceResolver resolver = new SimpleResourceResolver();
        if (dependencies == null) {
            return resolver;
        }
        String sCacheName = dependencies.getCacheName();
        if (sCacheName != null) {
            resolver.registerResource(String.class, "cache-name", sCacheName);
        }
        ClassLoader classLoader = dependencies.getClassLoader();
        if (dependencies.getClassLoader() != null) {
            resolver.registerResource(ClassLoader.class, classLoader);
            resolver.registerResource(ClassLoader.class, "class-loader", classLoader);
        }
        if ((ctxBackingMapManager = dependencies.getBackingMapManagerContext()) != null) {
            resolver.registerResource(BackingMapManagerContext.class, ctxBackingMapManager);
            resolver.registerResource(BackingMapManagerContext.class, "manager-context", ctxBackingMapManager);
        }
        if ((ccf = dependencies.getConfigurableCacheFactory()) == null) {
            return resolver;
        }
        ResourceRegistry registry = ccf.getResourceRegistry();
        resolver.registerResource(ConfigurableCacheFactory.class, ccf);
        resolver.registerResource(ResourceRegistry.class, registry);
        return new ChainedResourceResolver(resolver, registry);
    }

    public static ResourceResolver resourceResolverFrom(final ParameterResolver parameterResolver, final ParameterResolver resolverForExpressionEvaluation) {
        return new ResourceResolver(){

            @Override
            public <R> R getResource(Class<R> clsResource, String sResourceName) {
                Parameter parameter = parameterResolver.resolve(sResourceName);
                if (parameter == null) {
                    return null;
                }
                ParameterResolver resolver = resolverForExpressionEvaluation == null ? new NullParameterResolver() : resolverForExpressionEvaluation;
                Value value = parameter.evaluate(resolver);
                if (value == null || value.isNull() || !value.supports(clsResource)) {
                    return null;
                }
                return value.as(clsResource);
            }

            @Override
            public <R> R getResource(Class<R> clsResource) {
                return null;
            }
        };
    }

    public static ResourceResolver resourceResolverFrom(ResourceResolver ... resourceResolvers) {
        return new ChainedResourceResolver(resourceResolvers);
    }

    public static <T> ResourceResolver resourceResolverFrom(final Class<T> clsResolvableResource, final String sResolvableResourceName, final T resolveableResource) {
        return new ResourceResolver(){

            @Override
            public <R> R getResource(Class<R> clsResource, String sResourceName) {
                if (clsResource.equals(clsResolvableResource) && sResourceName.equals(sResolvableResourceName)) {
                    return (R)resolveableResource;
                }
                return null;
            }

            @Override
            public <R> R getResource(Class<R> clsResource) {
                return null;
            }
        };
    }

    public static <T> ResourceResolver resourceResolverFrom(final Class<T> clsResolvableResource, final T resolveableResource) {
        return new ResourceResolver(){

            @Override
            public <R> R getResource(Class<R> clsResource, String sResourceName) {
                return null;
            }

            @Override
            public <R> R getResource(Class<R> clsResource) {
                if (clsResource.equals(clsResolvableResource)) {
                    return (R)resolveableResource;
                }
                return null;
            }
        };
    }
}

