/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.collections.AbstractStableIterator;
import com.tangosol.internal.util.Primes;
import com.tangosol.util.Base;
import com.tangosol.util.NullImplementation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class SafeHashMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    private static final Entry[] NO_ENTRIES = new Entry[0];
    public static final int DEFAULT_INITIALSIZE = 17;
    protected static final int BIGGEST_MODULO = Integer.MAX_VALUE;
    public static final float DEFAULT_LOADFACTOR = 1.0f;
    public static final float DEFAULT_GROWTHRATE = 3.0f;
    protected Object RESIZING = new Object();
    protected volatile int m_cEntries;
    protected volatile Entry[] m_aeBucket;
    protected int m_cCapacity;
    protected float m_flLoadFactor;
    protected float m_flGrowthRate;
    protected transient EntrySet m_setEntries;
    protected transient KeySet m_setKeys;
    protected transient ValuesCollection m_colValues;
    protected transient Object m_oIterActive;

    public SafeHashMap() {
        this(17, 1.0f, 3.0f);
    }

    public SafeHashMap(int cInitialBuckets, float flLoadFactor, float flGrowthRate) {
        if (cInitialBuckets <= 0) {
            throw new IllegalArgumentException("SafeHashMap:  Initial number of buckets must be greater than zero.");
        }
        if (flLoadFactor <= 0.0f) {
            throw new IllegalArgumentException("SafeHashMap:  Load factor must be greater than zero.");
        }
        if (flGrowthRate <= 0.0f) {
            throw new IllegalArgumentException("SafeHashMap:  Growth rate must be greater than zero.");
        }
        this.m_aeBucket = new Entry[cInitialBuckets];
        this.m_cCapacity = (int)((float)cInitialBuckets * flLoadFactor);
        this.m_flLoadFactor = flLoadFactor;
        this.m_flGrowthRate = flGrowthRate;
    }

    @Override
    public int size() {
        return this.m_cEntries;
    }

    @Override
    public boolean isEmpty() {
        return this.m_cEntries == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntryInternal(key) != null;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> entry = this.getEntryInternal(key);
        return entry == null ? null : (V)entry.getValue();
    }

    public Entry<K, V> getEntry(Object key) {
        return this.getEntryInternal(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Entry<K, V> entry;
        block7: {
            entry = this.getEntryInternal(key);
            if (entry == null) {
                int nHash = key == null ? 0 : key.hashCode();
                entry = this.instantiateEntry(key, value, nHash);
                SafeHashMap safeHashMap = this;
                synchronized (safeHashMap) {
                    Entry[] aeBucket = this.m_aeBucket;
                    int cBuckets = aeBucket.length;
                    int nBucket = this.getBucketIndex(nHash, cBuckets);
                    Entry entryCur = aeBucket[nBucket];
                    while (entryCur != null) {
                        if (nHash == entryCur.m_nHash && (key == null ? entryCur.m_oKey == null : key.equals(entryCur.m_oKey))) {
                            entry = entryCur;
                            break block7;
                        }
                        entryCur = entryCur.m_eNext;
                    }
                    entry.m_eNext = aeBucket[nBucket];
                    aeBucket[nBucket] = entry;
                    if (++this.m_cEntries > this.m_cCapacity) {
                        this.grow();
                    }
                }
                entry.onAdd();
                return null;
            }
        }
        return entry.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void grow() {
        Entry[] aeNew;
        Entry[] aeOld = this.m_aeBucket;
        int cOld = aeOld.length;
        if (cOld >= Integer.MAX_VALUE) {
            return;
        }
        this.m_aeBucket = NO_ENTRIES;
        int cNew = (int)Math.min((long)((float)cOld * (1.0f + this.m_flGrowthRate)), Integer.MAX_VALUE);
        if (cNew <= cOld) {
            cNew = cOld + 1;
        }
        cNew = Primes.next(cNew);
        try {
            aeNew = new Entry[cNew];
        }
        catch (OutOfMemoryError e) {
            this.m_aeBucket = aeOld;
            throw e;
        }
        boolean fRetain = this.isActiveIterator();
        for (int i = 0; i < cOld; ++i) {
            Entry entry = aeOld[i];
            Entry entryRetain = null;
            while (entry != null) {
                Entry entryNext = entry.m_eNext;
                int nBucket = this.getBucketIndex(entry.m_nHash, cNew);
                entry.m_eNext = aeNew[nBucket];
                aeNew[nBucket] = entry;
                if (fRetain) {
                    Entry entryCopy = (Entry)entry.clone();
                    if (entryRetain == null) {
                        aeOld[i] = entryCopy;
                    } else {
                        entryRetain.m_eNext = entryCopy;
                    }
                    entryRetain = entryCopy;
                }
                entry = entryNext;
            }
        }
        this.m_cCapacity = (int)((float)cNew * this.m_flLoadFactor);
        this.m_aeBucket = aeNew;
        Object object = this.RESIZING;
        synchronized (object) {
            this.RESIZING.notifyAll();
        }
    }

    @Override
    public synchronized V remove(Object oKey) {
        Entry[] aeBucket = this.m_aeBucket;
        int cBuckets = aeBucket.length;
        int nHash = oKey == null ? 0 : oKey.hashCode();
        int nBucket = this.getBucketIndex(nHash, cBuckets);
        Entry entryCur = aeBucket[nBucket];
        Entry entryPrev = null;
        while (entryCur != null) {
            if (nHash == entryCur.m_nHash && (oKey == null ? entryCur.m_oKey == null : oKey.equals(entryCur.m_oKey))) {
                if (entryPrev == null) {
                    aeBucket[nBucket] = entryCur.m_eNext;
                } else {
                    entryPrev.m_eNext = entryCur.m_eNext;
                }
                --this.m_cEntries;
                return entryCur.getValue();
            }
            entryPrev = entryCur;
            entryCur = entryCur.m_eNext;
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.m_aeBucket = new Entry[17];
        this.m_cEntries = 0;
        this.m_cCapacity = (int)(17.0f * this.m_flLoadFactor);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet set = this.m_setEntries;
        if (set == null) {
            this.m_setEntries = set = this.instantiateEntrySet();
        }
        return set;
    }

    @Override
    public Set<K> keySet() {
        KeySet set = this.m_setKeys;
        if (set == null) {
            this.m_setKeys = set = this.instantiateKeySet();
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        ValuesCollection col = this.m_colValues;
        if (col == null) {
            this.m_colValues = col = this.instantiateValuesCollection();
        }
        return col;
    }

    @Override
    public synchronized Object clone() {
        try {
            SafeHashMap that = (SafeHashMap)super.clone();
            Entry[] aeBucket = (Entry[])this.m_aeBucket.clone();
            int cBuckets = aeBucket.length;
            for (int i = 0; i < cBuckets; ++i) {
                Entry entryThis = aeBucket[i];
                if (entryThis == null) continue;
                aeBucket[i] = that.cloneEntryList(entryThis);
            }
            that.m_aeBucket = aeBucket;
            that.m_setEntries = null;
            that.m_setKeys = null;
            that.m_colValues = null;
            that.m_oIterActive = null;
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected Entry cloneEntryList(Entry entryThat) {
        if (entryThat == null) {
            return null;
        }
        Entry<K, V> entryThis = this.instantiateEntry();
        entryThis.copyFrom(entryThat);
        Entry<K, V> entryPrevThis = entryThis;
        Entry entryNextThat = entryThat.m_eNext;
        while (entryNextThat != null) {
            Entry entryNextThis = this.instantiateEntry();
            entryNextThis.copyFrom(entryNextThat);
            entryPrevThis.m_eNext = entryNextThis;
            entryPrevThis = entryNextThis;
            entryNextThat = entryNextThat.m_eNext;
        }
        return entryThis;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Entry[] aeBucket = this.m_aeBucket;
        int cBuckets = aeBucket.length;
        out.writeInt(cBuckets);
        out.writeInt(this.m_cCapacity);
        out.writeFloat(this.m_flLoadFactor);
        out.writeFloat(this.m_flGrowthRate);
        int cEntries = this.m_cEntries;
        int cCheck = 0;
        out.writeInt(cEntries);
        for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
            Entry entry = aeBucket[iBucket];
            while (entry != null) {
                out.writeObject(entry.m_oKey);
                out.writeObject(entry.m_oValue);
                entry = entry.m_eNext;
                ++cCheck;
            }
        }
        if (cCheck != cEntries) {
            throw new IOException("expected to write " + cEntries + " objects but actually wrote " + cCheck);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int cEntries;
        this.RESIZING = new Object();
        int cBuckets = in.readInt();
        Entry[] aeBucket = new Entry[cBuckets];
        this.m_aeBucket = aeBucket;
        this.m_cCapacity = in.readInt();
        this.m_flLoadFactor = in.readFloat();
        this.m_flGrowthRate = in.readFloat();
        this.m_cEntries = cEntries = in.readInt();
        for (int i = 0; i < cEntries; ++i) {
            Object oKey = in.readObject();
            Object oValue = in.readObject();
            int nHash = oKey == null ? 0 : oKey.hashCode();
            int nBucket = this.getBucketIndex(nHash, cBuckets);
            Entry<Object, Object> entry = this.instantiateEntry(oKey, oValue, nHash);
            entry.m_eNext = aeBucket[nBucket];
            aeBucket[nBucket] = entry;
        }
    }

    protected Entry<K, V> getEntryInternal(Object oKey) {
        Entry entry;
        Entry[] aeBucket;
        int nHash = oKey == null ? 0 : oKey.hashCode();
        do {
            aeBucket = this.getStableBucketArray();
            int cBuckets = aeBucket.length;
            int nBucket = this.getBucketIndex(nHash, cBuckets);
            entry = aeBucket[nBucket];
            while (!(entry == null || nHash == entry.m_nHash && (oKey == null ? entry.m_oKey == null : oKey.equals(entry.m_oKey)))) {
                entry = entry.m_eNext;
            }
        } while (aeBucket != this.m_aeBucket);
        return entry;
    }

    protected synchronized void removeEntryInternal(Entry<K, V> entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry is null");
        }
        Entry[] aeBucket = this.m_aeBucket;
        int nHash = entry.m_nHash;
        int cBuckets = aeBucket.length;
        int nBucket = this.getBucketIndex(nHash, cBuckets);
        Entry entryHead = aeBucket[nBucket];
        if (entry == entryHead) {
            aeBucket[nBucket] = entry.m_eNext;
        } else {
            Entry entryPrev = entryHead;
            while (true) {
                if (entryPrev == null) {
                    return;
                }
                Entry entryCur = entryPrev.m_eNext;
                if (entry == entryCur) {
                    entryPrev.m_eNext = entryCur.m_eNext;
                    break;
                }
                entryPrev = entryCur;
            }
        }
        --this.m_cEntries;
    }

    protected int getBucketIndex(int nHash, int cBuckets) {
        return (int)(((long)nHash & 0xFFFFFFFFL) % (long)cBuckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry[] getStableBucketArray() {
        Entry[] aeBucket = this.m_aeBucket;
        while (aeBucket.length == 0) {
            Object object = this.RESIZING;
            synchronized (object) {
                if (this.m_aeBucket.length == 0) {
                    try {
                        Blocking.wait(this.RESIZING, 1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Base.ensureRuntimeException(e);
                    }
                }
            }
            aeBucket = this.m_aeBucket;
        }
        return aeBucket;
    }

    protected synchronized void iteratorActivated(Iterator iter) {
        Object oIterActive = this.m_oIterActive;
        if (oIterActive == null) {
            this.m_oIterActive = new WeakReference<Iterator>(iter);
        } else if (oIterActive instanceof WeakReference) {
            Object oPrev = ((WeakReference)oIterActive).get();
            if (oPrev == null) {
                this.m_oIterActive = new WeakReference<Iterator>(iter);
            } else {
                WeakHashMap<Object, Object> map;
                this.m_oIterActive = map = new WeakHashMap<Object, Object>();
                map.put(oPrev, null);
                map.put(iter, null);
            }
        } else {
            ((Map)oIterActive).put(iter, null);
        }
    }

    protected synchronized void iteratorDeactivated(Iterator iter) {
        Object oIterActive = this.m_oIterActive;
        if (oIterActive instanceof WeakReference) {
            assert (((WeakReference)oIterActive).get() == iter);
            this.m_oIterActive = null;
        } else {
            ((Map)oIterActive).remove(iter);
        }
    }

    protected synchronized boolean isActiveIterator() {
        Object oIterActive = this.m_oIterActive;
        if (oIterActive == null) {
            return false;
        }
        if (oIterActive instanceof WeakReference) {
            return ((WeakReference)oIterActive).get() != null;
        }
        return !((Map)oIterActive).isEmpty();
    }

    protected Entry<K, V> instantiateEntry(K oKey, V oValue, int iHash) {
        Entry<K, V> entry = this.instantiateEntry();
        entry.m_oKey = oKey;
        entry.m_oValue = oValue;
        entry.m_nHash = iHash;
        return entry;
    }

    protected Entry<K, V> instantiateEntry() {
        return new Entry();
    }

    protected EntrySet instantiateEntrySet() {
        return new EntrySet();
    }

    protected KeySet instantiateKeySet() {
        return new KeySet();
    }

    protected ValuesCollection instantiateValuesCollection() {
        return new ValuesCollection();
    }

    protected class ValuesCollection
    extends AbstractCollection<V>
    implements Serializable {
        protected ValuesCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator(){
                private Iterator<Map.Entry<K, V>> m_iter;
                {
                    this.m_iter = SafeHashMap.this.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public V next() {
                    return this.m_iter.next().getValue();
                }

                @Override
                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        @Override
        public int size() {
            return SafeHashMap.this.size();
        }

        @Override
        public void clear() {
            SafeHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            SafeHashMap map;
            SafeHashMap safeHashMap = map = SafeHashMap.this;
            synchronized (safeHashMap) {
                int c = map.size();
                if (a == null) {
                    a = new Object[c];
                } else if (a.length < c) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
                } else if (a.length > c) {
                    a[c] = null;
                }
                Entry[] aeBucket = map.m_aeBucket;
                int cBuckets = aeBucket.length;
                int i = 0;
                for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
                    Entry entry = aeBucket[iBucket];
                    while (entry != null) {
                        a[i++] = entry.m_oValue;
                        entry = entry.m_eNext;
                    }
                }
            }
            return a;
        }
    }

    protected class KeySet
    extends AbstractSet<K>
    implements Serializable {
        protected KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator(){
                private Iterator<Map.Entry<K, V>> m_iter;
                {
                    this.m_iter = SafeHashMap.this.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public K next() {
                    return this.m_iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        @Override
        public int size() {
            return SafeHashMap.this.size();
        }

        @Override
        public boolean contains(Object oKey) {
            return SafeHashMap.this.containsKey(oKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            SafeHashMap map;
            SafeHashMap safeHashMap = map = SafeHashMap.this;
            synchronized (safeHashMap) {
                if (map.containsKey(o)) {
                    map.remove(o);
                    return true;
                }
                return false;
            }
        }

        @Override
        public void clear() {
            SafeHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            SafeHashMap map;
            SafeHashMap safeHashMap = map = SafeHashMap.this;
            synchronized (safeHashMap) {
                int c = map.size();
                if (a == null) {
                    a = new Object[c];
                } else if (a.length < c) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
                } else if (a.length > c) {
                    a[c] = null;
                }
                Entry[] aeBucket = map.m_aeBucket;
                int cBuckets = aeBucket.length;
                int i = 0;
                for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
                    Entry entry = aeBucket[iBucket];
                    while (entry != null) {
                        a[i++] = entry.m_oKey;
                        entry = entry.m_eNext;
                    }
                }
            }
            return a;
        }
    }

    protected class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements Serializable {
        protected EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return SafeHashMap.this.isEmpty() ? NullImplementation.getIterator() : this.instantiateIterator();
        }

        @Override
        public int size() {
            return SafeHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry thatEntry = (Map.Entry)o;
                Entry thisEntry = SafeHashMap.this.getEntryInternal(thatEntry.getKey());
                return thisEntry != null && thisEntry.equals(thatEntry);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            SafeHashMap map;
            SafeHashMap safeHashMap = map = SafeHashMap.this;
            synchronized (safeHashMap) {
                if (this.contains(o)) {
                    map.remove(((Map.Entry)o).getKey());
                    return true;
                }
                return false;
            }
        }

        @Override
        public void clear() {
            SafeHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            SafeHashMap map;
            SafeHashMap safeHashMap = map = SafeHashMap.this;
            synchronized (safeHashMap) {
                int c = map.size();
                if (a == null) {
                    a = new Object[c];
                } else if (a.length < c) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
                } else if (a.length > c) {
                    a[c] = null;
                }
                Entry[] aeBucket = map.m_aeBucket;
                int cBuckets = aeBucket.length;
                int i = 0;
                for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
                    Entry entry = aeBucket[iBucket];
                    while (entry != null) {
                        a[i++] = entry;
                        entry = entry.m_eNext;
                    }
                }
            }
            return a;
        }

        protected Iterator instantiateIterator() {
            return new EntrySetIterator();
        }

        protected class EntrySetIterator
        extends AbstractStableIterator {
            private Entry[] m_aeBucket;
            private int m_iBucket = -1;
            private Entry m_entryPrev;
            private boolean m_fResized;
            private boolean m_fDeactivated;

            protected EntrySetIterator() {
            }

            @Override
            protected void advance() {
                Entry entryVisible;
                if (this.m_fDeactivated) {
                    return;
                }
                Entry[] aeBucket = this.m_aeBucket;
                if (aeBucket == null) {
                    SafeHashMap map = SafeHashMap.this;
                    map.iteratorActivated(this);
                    aeBucket = this.m_aeBucket = map.getStableBucketArray();
                }
                Entry entry = this.m_entryPrev;
                int iBucket = -1;
                boolean fResized = this.m_fResized;
                do {
                    if (entry != null) {
                        entry = entry.m_eNext;
                    }
                    if (entry == null) {
                        iBucket = this.m_iBucket;
                        int cBuckets = aeBucket.length;
                        do {
                            if (++iBucket < cBuckets) continue;
                            if (!fResized && aeBucket != SafeHashMap.this.m_aeBucket) break;
                            this.deactivate();
                            return;
                        } while ((entry = aeBucket[iBucket]) == null);
                    }
                    if (!fResized && aeBucket != SafeHashMap.this.m_aeBucket) {
                        this.m_fResized = true;
                        if (this.m_entryPrev != null) {
                            SafeHashMap.this.getStableBucketArray();
                            Object oKey = this.m_entryPrev.m_oKey;
                            entry = aeBucket[this.m_iBucket];
                            while (entry != null && entry.m_oKey != oKey) {
                                entry = entry.m_eNext;
                            }
                            if (entry == null) {
                                this.deactivate();
                                throw new ConcurrentModificationException();
                            }
                            this.m_entryPrev = entry;
                        }
                        this.advance();
                        return;
                    }
                    Entry entry2 = entryVisible = fResized ? SafeHashMap.this.getEntryInternal(entry.getKey()) : entry;
                    if (iBucket < 0) continue;
                    this.m_iBucket = iBucket;
                } while (entryVisible == null);
                this.m_entryPrev = entry;
                this.setNext(entryVisible);
            }

            protected void remove(Object oPrev) {
                SafeHashMap.this.remove(((Map.Entry)oPrev).getKey());
            }

            protected void deactivate() {
                if (!this.m_fDeactivated) {
                    SafeHashMap.this.iteratorDeactivated(this);
                    this.m_fDeactivated = true;
                    this.m_aeBucket = null;
                    this.m_entryPrev = null;
                }
            }
        }
    }

    protected static class Entry<K, V>
    extends Base
    implements Map.Entry<K, V>,
    Cloneable,
    Serializable {
        protected K m_oKey;
        protected volatile V m_oValue;
        protected int m_nHash;
        protected volatile Entry<K, V> m_eNext;

        protected Entry() {
        }

        @Override
        public K getKey() {
            return this.m_oKey;
        }

        @Override
        public V getValue() {
            return this.m_oValue;
        }

        @Override
        public V setValue(V value) {
            V oPrev = this.m_oValue;
            this.m_oValue = value;
            return oPrev;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)o;
                if (this == that) {
                    return true;
                }
                K oThisKey = this.m_oKey;
                Object oThatKey = that.getKey();
                V oThisValue = this.m_oValue;
                Object oThatValue = that.getValue();
                return (oThisKey == null ? oThatKey == null : oThisKey.equals(oThatKey)) && (oThisValue == null ? oThatValue == null : oThisValue.equals(oThatValue));
            }
            return false;
        }

        @Override
        public int hashCode() {
            K oKey = this.m_oKey;
            V oValue = this.m_oValue;
            return (oKey == null ? 0 : this.m_nHash) ^ (oValue == null ? 0 : oValue.hashCode());
        }

        public String toString() {
            return "key=\"" + this.getKey() + '\"' + ", value=\"" + this.getValue() + '\"';
        }

        public Object clone() {
            try {
                Entry that = (Entry)super.clone();
                that.m_eNext = null;
                return that;
            }
            catch (CloneNotSupportedException e) {
                throw Entry.ensureRuntimeException(e);
            }
        }

        protected void copyFrom(Entry<K, V> entry) {
            this.m_oKey = entry.m_oKey;
            this.m_oValue = entry.m_oValue;
            this.m_nHash = entry.m_nHash;
        }

        protected void onAdd() {
        }
    }
}

