/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.util.Base;
import com.tangosol.util.Daemon;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import java.util.LinkedList;
import java.util.List;

public class TaskDaemon
extends Daemon {
    private LongArray m_arrayTasks = new SparseArray();
    private volatile boolean m_fFinish;
    private long m_ldtLastTask;
    private long m_cMillisTimeout;

    public TaskDaemon() {
    }

    public TaskDaemon(String sName) {
        super(sName);
    }

    public TaskDaemon(String sName, int nPriority, boolean fStart) {
        super(sName, nPriority, false);
        if (fStart) {
            this.start();
        }
    }

    public TaskDaemon(String sName, int nPriority, boolean fStart, boolean fFinish, int cMillisTimeout) {
        this(sName, nPriority, false);
        this.setFinishing(fFinish);
        this.setIdleTimeout(cMillisTimeout);
        if (fStart) {
            this.start();
        }
    }

    @Override
    public void run() {
        try {
            this.updateMostRecentTaskTime();
            while (!this.isStopping() || this.isFinishing()) {
                Runnable task = this.takeNextRipeTask();
                if (task == null) {
                    if (!this.isStopping()) continue;
                    break;
                }
                this.run(task);
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable e) {
            TaskDaemon.err(e);
            TaskDaemon.err("(Daemon is exiting.)");
        }
    }

    public synchronized void stop(boolean fFinish) {
        this.setFinishing(fFinish);
        this.stop();
    }

    public boolean isFinishing() {
        return this.m_fFinish;
    }

    public synchronized void setFinishing(boolean fFinish) {
        this.m_fFinish = fFinish;
    }

    public long getIdleTimeout() {
        return this.m_cMillisTimeout;
    }

    public synchronized void setIdleTimeout(long cMillis) {
        this.m_cMillisTimeout = cMillis;
        if (this.isRunning()) {
            this.notifyAll();
        }
    }

    public synchronized void executeTask(Runnable task) {
        this.scheduleTask(task, TaskDaemon.getSafeTimeMillis());
    }

    public synchronized void scheduleTask(Runnable task, long ldt) {
        boolean fNew;
        boolean fIsDaemon;
        boolean bl = fIsDaemon = this.getThread() == Thread.currentThread();
        if (this.isStopping() && !fIsDaemon) {
            throw new IllegalStateException("Daemon " + this + " is stopping; new tasks cannot be scheduled.");
        }
        LongArray arrayTasks = this.getTasks();
        LinkedList<Runnable> listTasks = (LinkedList<Runnable>)arrayTasks.get(ldt);
        boolean bl2 = fNew = listTasks == null;
        if (fNew) {
            listTasks = new LinkedList<Runnable>();
            arrayTasks.set(ldt, listTasks);
        }
        listTasks.add(task);
        if (!this.isRunning()) {
            this.start();
        } else if (!fIsDaemon && fNew && ldt == arrayTasks.getFirstIndex()) {
            this.notifyAll();
        }
    }

    public synchronized void executePeriodicTask(Runnable task, long cMillisInterval) {
        this.schedulePeriodicTask(task, TaskDaemon.getSafeTimeMillis(), cMillisInterval);
    }

    public synchronized void schedulePeriodicTask(Runnable task, long ldtFirst, long cMillisInterval) {
        this.scheduleTask(this.instantiatePeriodicTask(task, cMillisInterval), ldtFirst);
    }

    protected LongArray getTasks() {
        return this.m_arrayTasks;
    }

    protected synchronized Runnable takeNextRipeTask() throws InterruptedException {
        Runnable task = null;
        LongArray arrayTasks = this.getTasks();
        while (task == null && (!this.isStopping() || this.isFinishing())) {
            long ldt = arrayTasks.getFirstIndex();
            if (ldt == -1L) {
                if (this.isStopping()) break;
                long cTimeoutMillis = this.getIdleTimeout();
                if (cTimeoutMillis > 0L) {
                    long ldtCur;
                    long ldtPrev = this.getMostRecentTaskTime();
                    long ldtStop = ldtPrev + cTimeoutMillis;
                    long cMillisWait = ldtStop - (ldtCur = TaskDaemon.getSafeTimeMillis());
                    if (cMillisWait > 0L) {
                        Blocking.wait(this, cMillisWait);
                        continue;
                    }
                    this.stop();
                    break;
                }
                Blocking.wait(this);
                continue;
            }
            long lWait = ldt - TaskDaemon.getSafeTimeMillis();
            if (lWait > 0L) {
                if (this.isStopping()) break;
                Blocking.wait(this, lWait);
                continue;
            }
            List listTasks = (List)arrayTasks.get(ldt);
            task = (Runnable)listTasks.remove(0);
            if (!listTasks.isEmpty()) continue;
            arrayTasks.remove(ldt);
        }
        return task;
    }

    protected void run(Runnable task) {
        if (task != null) {
            try {
                this.updateMostRecentTaskTime();
                task.run();
                this.updateMostRecentTaskTime();
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.onException(e, task);
            }
        }
    }

    protected long getMostRecentTaskTime() {
        return this.m_ldtLastTask;
    }

    protected void updateMostRecentTaskTime() {
        this.m_ldtLastTask = TaskDaemon.getSafeTimeMillis();
    }

    protected Runnable instantiatePeriodicTask(Runnable task, long cMillisInterval) {
        TaskDaemon.azzert(cMillisInterval > 0L, "interval must be greater than zero");
        return new PeriodicTask(task, cMillisInterval);
    }

    @Override
    public String toString() {
        return "TaskDaemon{" + this.getDescription() + '}';
    }

    @Override
    protected String getDescription() {
        return super.getDescription() + ", MostRecentTaskTime=" + TaskDaemon.formatDateTime(this.getMostRecentTaskTime()) + ", NextRipeTask=" + TaskDaemon.formatDateTime(Math.max(this.getTasks().getFirstIndex(), 0L)) + ", Timeout=" + this.getIdleTimeout() + "ms, Finishing=" + this.isFinishing();
    }

    protected void onException(Throwable e, Runnable task) {
        String sDaemon = String.valueOf(this.getThread());
        if (task == null) {
            TaskDaemon.err("An exception occurred on " + sDaemon + ":");
        } else {
            String sTask = "class " + task.getClass().getName();
            try {
                sTask = task.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TaskDaemon.err("An exception occurred on " + sDaemon + " while processing the task: " + sTask);
        }
        TaskDaemon.err(e);
        TaskDaemon.err("(The thread has logged the exception and is continuing.)");
    }

    public class PeriodicTask
    extends Base
    implements Runnable {
        private Runnable m_task;
        private long m_cMillisInterval;

        public PeriodicTask(Runnable task, long cMillisInterval) {
            this.m_task = task;
            this.m_cMillisInterval = cMillisInterval;
        }

        @Override
        public void run() {
            try {
                this.m_task.run();
            }
            finally {
                TaskDaemon daemon = TaskDaemon.this;
                if (!daemon.isStopping()) {
                    daemon.scheduleTask(this, PeriodicTask.getSafeTimeMillis() + this.m_cMillisInterval);
                }
            }
        }
    }
}

