/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.util.Sentry;
import com.tangosol.util.Base;
import com.tangosol.util.Gate;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ThreadGateLite<R>
implements Gate<R> {
    private final R f_resource;
    private final ReentrantReadWriteLock f_rwLock = new ReentrantReadWriteLock();
    private final AtomicReference<Bar> f_atomicBar = new AtomicReference();
    protected final Sentry<R> f_exitSentry = new Sentry<R>(){

        @Override
        public R getResource() {
            return ThreadGateLite.this.f_resource;
        }

        @Override
        public void close() {
            ThreadGateLite.this.exit();
        }
    };
    protected final Sentry<R> f_openSentry = new Sentry<R>(){

        @Override
        public R getResource() {
            return ThreadGateLite.this.f_resource;
        }

        @Override
        public void close() {
            ThreadGateLite.this.open();
        }
    };

    public ThreadGateLite() {
        this(null);
    }

    public ThreadGateLite(R resource) {
        this.f_resource = resource;
    }

    @Override
    public Sentry<R> close() {
        this.close(-1L);
        return this.f_openSentry;
    }

    @Override
    public boolean close(long cMillis) {
        do {
            Bar bar;
            if ((bar = this.f_atomicBar.get()) == null || bar.f_thread == Thread.currentThread()) {
                long ldtStart = Base.getSafeTimeMillis();
                if (this.acquireLock(this.f_rwLock.writeLock(), cMillis)) {
                    if (this.f_atomicBar.get() == bar) {
                        return true;
                    }
                    this.f_rwLock.writeLock().unlock();
                    cMillis = this.adjustWaitTime(cMillis, ldtStart);
                    continue;
                }
                return false;
            }
            cMillis = this.waitForOpen(bar, cMillis);
        } while (cMillis != 0L);
        return false;
    }

    @Override
    public Sentry<R> enter() {
        this.enter(-1L);
        return this.f_exitSentry;
    }

    @Override
    public boolean enter(long cMillis) {
        Bar bar;
        do {
            if ((bar = this.f_atomicBar.get()) != null && bar.f_thread != Thread.currentThread() && this.f_rwLock.getReadHoldCount() <= 0) continue;
            return this.acquireLock(this.f_rwLock.readLock(), cMillis);
        } while ((cMillis = this.waitForOpen(bar, cMillis)) != 0L);
        return false;
    }

    @Override
    public void exit() {
        this.f_rwLock.readLock().unlock();
    }

    @Override
    public boolean isClosedByCurrentThread() {
        return this.f_rwLock.isWriteLockedByCurrentThread();
    }

    @Override
    public boolean isClosed() {
        return this.f_rwLock.isWriteLocked();
    }

    @Override
    public boolean isEnteredByCurrentThread() {
        return this.f_rwLock.getReadHoldCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        Bar bar = this.f_atomicBar.get();
        if (bar == null) {
            this.f_rwLock.writeLock().unlock();
        } else {
            if (bar.f_thread != Thread.currentThread()) {
                throw new IllegalMonitorStateException("Gate was not closed by this thread");
            }
            if (--bar.m_cBarred == 0) {
                Bar bar2 = bar;
                synchronized (bar2) {
                    this.f_atomicBar.set(null);
                    bar.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean barEntry(long cMillis) {
        do {
            Bar bar;
            if ((bar = this.f_atomicBar.get()) == null) {
                long ldtStart = Base.getSafeTimeMillis();
                if (!this.enter(cMillis)) return false;
                try {
                    if (this.f_atomicBar.compareAndSet(null, new Bar(Thread.currentThread()))) {
                        boolean bl = true;
                        return bl;
                    }
                    cMillis = this.adjustWaitTime(cMillis, ldtStart);
                }
                finally {
                    this.exit();
                }
            } else {
                if (bar.f_thread == Thread.currentThread()) {
                    ++bar.m_cBarred;
                    return true;
                }
                cMillis = this.waitForOpen(bar, cMillis);
            }
        } while (cMillis != 0L);
        return false;
    }

    public String toString() {
        return "ThreadGateLite{lock=" + this.f_rwLock.toString() + ", bar=" + this.f_atomicBar.get() + "}";
    }

    private boolean acquireLock(Lock lock, long cMillis) {
        try {
            if (cMillis < 0L) {
                lock.lock();
                return true;
            }
            if (cMillis == 0L) {
                return lock.tryLock();
            }
            return Blocking.tryLock(lock, cMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long waitForOpen(Bar bar, long cMillis) {
        Bar bar2 = bar;
        synchronized (bar2) {
            if (bar == this.f_atomicBar.get()) {
                if (!bar.f_thread.isAlive()) {
                    this.f_atomicBar.set(null);
                    bar.notifyAll();
                } else if (cMillis != 0L) {
                    long ldtStart = Base.getSafeTimeMillis();
                    Base.wait(bar, cMillis < 0L ? 0L : cMillis);
                    cMillis = this.adjustWaitTime(cMillis, ldtStart);
                }
            }
        }
        return cMillis;
    }

    protected long adjustWaitTime(long cMillis, long ldtStart) {
        if (cMillis > 0L) {
            cMillis = Math.max(0L, cMillis - (Base.getSafeTimeMillis() - ldtStart));
        }
        return cMillis;
    }

    protected static class Bar {
        protected final Thread f_thread;
        protected int m_cBarred;

        protected Bar(Thread thread) {
            this.f_thread = thread;
            this.m_cBarred = 1;
        }

        public String toString() {
            return "Bar{m_thread=" + this.f_thread + "; m_cBarred=" + this.m_cBarred + "}";
        }
    }
}

