/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Streamer;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.json.bind.annotation.JsonbProperty;

public abstract class AbstractAggregator<K, V, T, E, R>
extends ExternalizableHelper
implements InvocableMap.StreamingAggregator<K, V, Object, R>,
ExternalizableLite,
PortableObject,
Cloneable {
    @JsonbProperty(value="parallel")
    protected boolean m_fParallel;
    @JsonbProperty(value="extractor")
    private ValueExtractor<? super T, ? extends E> m_extractor;
    private transient boolean m_fInit;

    public AbstractAggregator() {
    }

    public AbstractAggregator(ValueExtractor<? super T, ? extends E> extractor) {
        AbstractAggregator.azzert(extractor != null);
        this.m_extractor = Lambdas.ensureRemotable(extractor);
    }

    public AbstractAggregator(String sMethod) {
        this.m_extractor = sMethod.indexOf(46) < 0 ? new ReflectionExtractor(sMethod) : new ChainedExtractor(sMethod);
    }

    @Override
    public InvocableMap.StreamingAggregator<K, V, Object, R> supply() {
        try {
            AbstractAggregator aggregator = (AbstractAggregator)super.clone();
            aggregator.m_fInit = false;
            return aggregator;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(this.getClass().getName() + " is not Cloneable", e);
        }
    }

    @Override
    public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
        if (streamer.hasNext()) {
            return InvocableMap.StreamingAggregator.super.accumulate(streamer);
        }
        this.ensureInitialized(false);
        return true;
    }

    @Override
    public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
        this.ensureInitialized(false);
        this.processEntry(entry);
        return true;
    }

    @Override
    public boolean combine(Object partialResult) {
        this.ensureInitialized(true);
        this.process(partialResult, true);
        return true;
    }

    @Override
    public Object getPartialResult() {
        return this.finalizeResult(false);
    }

    @Override
    public R finalizeResult() {
        return (R)this.finalizeResult(true);
    }

    protected void ensureInitialized(boolean fFinal) {
        if (!this.m_fInit) {
            this.m_fParallel = !fFinal;
            this.init(fFinal);
            this.m_fInit = true;
        }
    }

    protected void processEntry(InvocableMap.Entry<? extends K, ? extends V> entry) {
        this.process(entry.extract(this.getValueExtractor()), false);
    }

    public ValueExtractor<? super T, ? extends E> getValueExtractor() {
        return this.m_extractor;
    }

    protected abstract void init(boolean var1);

    protected abstract void process(Object var1, boolean var2);

    protected abstract Object finalizeResult(boolean var1);

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + '(' + this.getValueExtractor().toString() + ')';
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getValueExtractor().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractAggregator) {
            AbstractAggregator that = (AbstractAggregator)o;
            return this == that || this.getClass() == that.getClass() && this.m_fParallel == that.m_fParallel && AbstractAggregator.equals(this.m_extractor, that.m_extractor);
        }
        return false;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_fParallel = in.readBoolean();
        this.m_extractor = (ValueExtractor)AbstractAggregator.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fParallel);
        AbstractAggregator.writeObject(out, this.m_extractor);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_fParallel = in.readBoolean(0);
        this.m_extractor = (ValueExtractor)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBoolean(0, this.m_fParallel);
        out.writeObject(1, this.m_extractor);
    }
}

