/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.json.bind.annotation.JsonbProperty;

public class KeyExtractor<T, E>
extends AbstractExtractor<T, E>
implements ExternalizableLite,
PortableObject {
    @JsonbProperty(value="extractor")
    protected ValueExtractor<? super T, ? extends E> m_extractor;

    public KeyExtractor() {
        this((ValueExtractor)null);
    }

    public KeyExtractor(ValueExtractor<? super T, ? extends E> extractor) {
        this.m_nTarget = 1;
        this.m_extractor = extractor == null ? IdentityExtractor.INSTANCE : Lambdas.ensureRemotable(extractor);
    }

    public KeyExtractor(String sMethod) {
        KeyExtractor.azzert(sMethod != null, "Method name is missing");
        this.m_nTarget = 1;
        this.m_extractor = sMethod.indexOf(46) < 0 ? new ReflectionExtractor(sMethod) : new ChainedExtractor(sMethod);
    }

    @Override
    public E extract(T oTarget) {
        return this.m_extractor.extract(oTarget);
    }

    @Override
    public String getCanonicalName() {
        if (this.m_sNameCanon == null) {
            this.m_sNameCanon = this.m_extractor.getCanonicalName();
        }
        return this.m_sNameCanon;
    }

    public ValueExtractor<? super T, ? extends E> getExtractor() {
        return this.m_extractor;
    }

    public static <T, E> ValueExtractor<T, E> of(ValueExtractor<T, E> extractor) {
        return extractor instanceof KeyExtractor ? extractor : new KeyExtractor<T, E>(extractor);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (this.isCanonicallyEquatable(o)) {
            return false;
        }
        if (o instanceof KeyExtractor && this.m_extractor instanceof AbstractExtractor) {
            KeyExtractor that = (KeyExtractor)o;
            return Base.equals(this.m_extractor, that.m_extractor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.m_extractor.hashCode();
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "(extractor=" + this.m_extractor + ')';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_extractor = (ValueExtractor)KeyExtractor.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        KeyExtractor.writeObject(out, this.m_extractor);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
    }
}

