/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryMap;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AbstractQueryRecorderFilter;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.GreaterEqualsFilter;
import com.tangosol.util.filter.GreaterFilter;
import com.tangosol.util.filter.LessEqualsFilter;
import com.tangosol.util.filter.LessFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class BetweenFilter<T, E extends Comparable<? super E>>
extends AndFilter {
    public static int EVAL_COST = 1000;

    public BetweenFilter() {
    }

    public BetweenFilter(ValueExtractor<? super T, ? extends E> extractor, E from, E to) {
        this(extractor, (E)from, (E)to, true, true);
    }

    public BetweenFilter(String sMethod, E from, E to) {
        this(sMethod, from, to, true, true);
    }

    public BetweenFilter(String sMethod, E lowerBound, E upperBound, boolean fIncludeLowerBound, boolean fIncludeUpperBound) {
        super(fIncludeLowerBound ? new GreaterEqualsFilter(sMethod, lowerBound) : new GreaterFilter(sMethod, lowerBound), fIncludeUpperBound ? new LessEqualsFilter(sMethod, upperBound) : new LessFilter(sMethod, upperBound));
    }

    public BetweenFilter(ValueExtractor<? super T, ? extends E> extractor, E lowerBound, E upperBound, boolean fIncludeLowerBound, boolean fIncludeUpperBound) {
        super(fIncludeLowerBound ? new GreaterEqualsFilter<T, E>(extractor, lowerBound) : new GreaterFilter<T, E>(extractor, lowerBound), fIncludeUpperBound ? new LessEqualsFilter<T, E>(extractor, upperBound) : new LessFilter<T, E>(extractor, upperBound));
    }

    public ValueExtractor getValueExtractor() {
        return ((ComparisonFilter)this.getFilters()[0]).getValueExtractor();
    }

    public E getLowerBound() {
        return (E)((Comparable)((ComparisonFilter)this.getFilters()[0]).getValue());
    }

    public E getUpperBound() {
        return (E)((Comparable)((ComparisonFilter)this.getFilters()[1]).getValue());
    }

    public boolean isLowerBoundInclusive() {
        return this.getFilters()[0] instanceof GreaterEqualsFilter;
    }

    public boolean isUpperBoundInclusive() {
        return this.getFilters()[1] instanceof LessEqualsFilter;
    }

    @Override
    public boolean evaluate(Object oTarget) {
        return this.evaluateExtracted(this.getValueExtractor().extract(oTarget));
    }

    @Override
    public boolean evaluateEntry(Map.Entry entry) {
        ValueExtractor extractor = this.getValueExtractor();
        return this.evaluateExtracted(entry instanceof QueryMap.Entry ? ((QueryMap.Entry)entry).extract(extractor) : InvocableMapHelper.extractFromEntry(extractor, entry));
    }

    @Override
    protected boolean evaluateEntry(Map.Entry entry, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        return this.evaluateFilter(this, entry, ctx, step == null ? null : step.ensureStep(this));
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        if (this.getLowerBound() == null || this.getUpperBound() == null) {
            setKeys.clear();
            return null;
        }
        MapIndex mapIndex = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (mapIndex == null) {
            return this;
        }
        Map mapInverse = mapIndex.getIndexContents();
        if (mapInverse instanceof SortedMap) {
            this.applySortedIndex(setKeys, (SortedMap)mapInverse);
            return null;
        }
        HashSet setToRetain = new HashSet();
        for (Map.Entry entry : mapInverse.entrySet()) {
            if (!this.evaluateExtracted(entry.getKey())) continue;
            setToRetain.addAll(ExtractorFilter.ensureSafeSet(entry.getValue()));
        }
        setKeys.retainAll(setToRetain);
        return null;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex mapIndex = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (mapIndex == null) {
            return setKeys.size() * EVAL_COST;
        }
        Map mapInverse = mapIndex.getIndexContents();
        if (mapInverse instanceof SortedMap) {
            SortedMap mapSorted = (SortedMap)mapInverse;
            return mapSorted.subMap(this.getLowerBound(), this.getUpperBound()).size();
        }
        return mapInverse.size();
    }

    @Override
    public void explain(QueryContext ctx, QueryRecord.PartialResult.ExplainStep step, Set setKeys) {
        AbstractQueryRecorderFilter.explain(this, ctx.getBackingMapContext().getIndexMap(), setKeys, step, this.getValueExtractor());
    }

    @Override
    public Filter trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Set setKeys) {
        return AbstractQueryRecorderFilter.trace(this, ctx.getBackingMapContext().getIndexMap(), setKeys, step, this.getValueExtractor());
    }

    @Override
    public boolean trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Map.Entry entry) {
        return AbstractQueryRecorderFilter.trace(this, entry, step);
    }

    @Override
    public String toString() {
        ValueExtractor extractor = this.getValueExtractor();
        return this.getClass().getSimpleName() + "(" + extractor + (this.isLowerBoundInclusive() ? " >= " : " > ") + this.getLowerBound() + " and " + extractor + (this.isUpperBoundInclusive() ? " <= " : " < ") + this.getUpperBound() + ")";
    }

    protected boolean evaluateExtracted(Object oExtracted) {
        E oLowerBound = this.getLowerBound();
        E oUpperBound = this.getUpperBound();
        boolean fIncludeLowerBound = this.isLowerBoundInclusive();
        boolean fIncludeUpperBound = this.isUpperBoundInclusive();
        if (oExtracted == null || oLowerBound == null || oUpperBound == null) {
            return false;
        }
        int cl = oLowerBound.compareTo((Object)oExtracted);
        if (fIncludeLowerBound && cl > 0 || !fIncludeLowerBound && cl >= 0) {
            return false;
        }
        int cu = ((Comparable)oExtracted).compareTo(oUpperBound);
        return (!fIncludeUpperBound || cu <= 0) && (fIncludeUpperBound || cu < 0);
    }

    protected void applySortedIndex(Set setKeys, SortedMap<Object, Set> mapInverted) {
        Collection colUpper;
        E oLowerBound = this.getLowerBound();
        E oUpperBound = this.getUpperBound();
        boolean fIncludeLowerBound = this.isLowerBoundInclusive();
        boolean fIncludeUpperBound = this.isUpperBoundInclusive();
        SortedMap<Object, Set> mapRange = mapInverted.subMap(oLowerBound, oUpperBound);
        HashSet colKeysToRetain = new HashSet();
        boolean fInsideRange = fIncludeLowerBound;
        for (Map.Entry<Object, Set> entry : mapRange.entrySet()) {
            if (!fInsideRange && !this.evaluateExtracted(entry.getKey())) continue;
            fInsideRange = true;
            colKeysToRetain.addAll(ExtractorFilter.ensureSafeSet(entry.getValue()));
        }
        if (fIncludeUpperBound && (colUpper = (Collection)mapInverted.get(oUpperBound)) != null) {
            colKeysToRetain.addAll(colUpper);
        }
        if (colKeysToRetain.isEmpty()) {
            setKeys.clear();
        } else {
            setKeys.retainAll(colKeysToRetain);
        }
    }
}

