/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.SafeSortedMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class GreaterEqualsFilter<T, E extends Comparable<? super E>>
extends ComparisonFilter<T, E, E>
implements IndexAwareFilter<Object, T> {
    public GreaterEqualsFilter() {
    }

    public GreaterEqualsFilter(ValueExtractor<? super T, ? extends E> extractor, E value) {
        super(extractor, value);
    }

    public GreaterEqualsFilter(String sMethod, E value) {
        super(sMethod, value);
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        Comparable value = (Comparable)this.getValue();
        return extracted != null && value != null && extracted.compareTo((Comparable)value) >= 0;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        return this.calculateRangeEffectiveness(mapIndexes, setKeys);
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Object oValue = this.getValue();
        if (oValue == null) {
            setKeys.clear();
            return null;
        }
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        if (index.isOrdered()) {
            boolean fHeadHeavy;
            SortedMap mapGE;
            SortedMap mapLT;
            SortedMap mapContents = (SortedMap)index.getIndexContents();
            if (mapContents instanceof SafeSortedMap) {
                SafeSortedMap.Split split = ((SafeSortedMap)mapContents).split(oValue);
                mapLT = split.getHead();
                mapGE = split.getTail();
                fHeadHeavy = split.isHeadHeavy();
            } else {
                mapLT = mapContents.headMap(oValue);
                mapGE = mapContents.tailMap(oValue);
                boolean bl = fHeadHeavy = mapLT.size() > mapContents.size() / 2;
            }
            if (fHeadHeavy || index.isPartial()) {
                HashSet setGE = new HashSet();
                Iterator iterGE = mapGE.values().iterator();
                while (iterGE.hasNext()) {
                    setGE.addAll(GreaterEqualsFilter.ensureSafeSet((Set)iterGE.next()));
                }
                setKeys.retainAll(setGE);
            } else {
                Iterator iterLT = mapLT.values().iterator();
                while (iterLT.hasNext()) {
                    setKeys.removeAll(GreaterEqualsFilter.ensureSafeSet((Set)iterLT.next()));
                }
            }
        } else {
            Map mapContents = index.getIndexContents();
            if (index.isPartial()) {
                HashSet setGE = new HashSet();
                for (Map.Entry entry : mapContents.entrySet()) {
                    Comparable oTest = (Comparable)entry.getKey();
                    if (oTest == null || oTest.compareTo(oValue) < 0) continue;
                    setGE.addAll(GreaterEqualsFilter.ensureSafeSet(entry.getValue()));
                }
                setKeys.retainAll(setGE);
            } else {
                for (Map.Entry entry : mapContents.entrySet()) {
                    Comparable oTest = (Comparable)entry.getKey();
                    if (oTest != null && oTest.compareTo(oValue) >= 0) continue;
                    setKeys.removeAll(entry.getValue());
                }
            }
        }
        return null;
    }
}

