/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.fsm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ReflectionHelper {
    public static Constructor<?> getCompatibleConstructor(Class<?> clazz, Class<?>[] parameterTypes) {
        Constructor<?>[] constructors = clazz.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != (parameterTypes != null ? parameterTypes.length : 0)) continue;
            Class<?>[] constructorTypes = constructors[i].getParameterTypes();
            boolean isCompatible = true;
            for (int j = 0; j < (parameterTypes != null ? parameterTypes.length : 0); ++j) {
                if (constructorTypes[j].isAssignableFrom(parameterTypes[j]) || !constructorTypes[j].isPrimitive() || ReflectionHelper.isAssignablePrimitive(constructorTypes[j], parameterTypes[j])) continue;
                isCompatible = false;
                break;
            }
            if (!isCompatible) continue;
            return constructors[i];
        }
        return null;
    }

    public static boolean isAssignablePrimitive(Class<?> clzPrimitive, Class<?> clzWrapper) {
        return clzPrimitive.equals(Boolean.TYPE) && clzWrapper.equals(Boolean.class) || clzPrimitive.equals(Byte.TYPE) && clzWrapper.equals(Byte.class) || clzPrimitive.equals(Character.TYPE) && clzWrapper.equals(Character.class) || clzPrimitive.equals(Double.TYPE) && clzWrapper.equals(Double.class) || clzPrimitive.equals(Float.TYPE) && clzWrapper.equals(Float.class) || clzPrimitive.equals(Integer.TYPE) && clzWrapper.equals(Integer.class) || clzPrimitive.equals(Long.TYPE) && clzWrapper.equals(Long.class) || clzPrimitive.equals(Short.TYPE) && clzWrapper.equals(Short.class);
    }

    public static Method getCompatibleMethod(Class<?> clazz, String methodName, Object ... arguments) {
        Class[] argumentTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            argumentTypes[i] = arguments[i] == null ? null : arguments[i].getClass();
        }
        try {
            return clazz.getDeclaredMethod(methodName, argumentTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return clazz.getSuperclass() == null ? null : ReflectionHelper.getCompatibleMethod(clazz.getSuperclass(), methodName, arguments);
        }
    }

    public static Object createObject(String sClassName, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(sClassName, true, classLoader);
        Constructor<?> con = clazz.getDeclaredConstructor(null);
        return con.newInstance(null);
    }

    public static Object createObject(String sClassName, Object[] constructorParameterList, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(sClassName, true, classLoader);
        Class<?>[] parameterTypes = ReflectionHelper.getClassArrayFromObjectArray(constructorParameterList);
        Constructor<?> con = ReflectionHelper.getCompatibleConstructor(clazz, parameterTypes);
        return con.newInstance(constructorParameterList);
    }

    protected static Class<?>[] getClassArrayFromObjectArray(Object[] objectArray) {
        Class[] parameterTypes = null;
        if (objectArray != null) {
            parameterTypes = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                parameterTypes[i] = objectArray[i].getClass();
            }
        }
        return parameterTypes;
    }

    public static Class<?> getConcreteType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return ReflectionHelper.getConcreteType(parameterizedType.getRawType());
        }
        return null;
    }

    public static boolean isAssignableFrom(Type x, Type y) {
        if (x instanceof Class && y instanceof Class) {
            Class clzX = (Class)x;
            Class clzY = (Class)y;
            return clzX.isAssignableFrom(clzY);
        }
        if (x instanceof ParameterizedType && y instanceof Class) {
            return ReflectionHelper.isAssignableFrom(ReflectionHelper.getConcreteType(x), ReflectionHelper.getConcreteType(y));
        }
        return false;
    }

    public static boolean isCompatibleMethod(Method method, int modifiers, Type returnType, Type ... parameterTypes) {
        Type[] methodParameterTypes = method.getGenericParameterTypes();
        if (methodParameterTypes.length == parameterTypes.length) {
            for (int i = 0; i < methodParameterTypes.length; ++i) {
                if (ReflectionHelper.isAssignableFrom(methodParameterTypes[i], parameterTypes[i])) continue;
                return false;
            }
            return ReflectionHelper.isAssignableFrom(method.getGenericReturnType(), returnType) && method.getModifiers() == modifiers;
        }
        return false;
    }
}

