/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.json.bind.annotation.JsonbProperty;

public class ConditionalPut<K, V>
extends AbstractProcessor<K, V, V>
implements ExternalizableLite,
PortableObject {
    @JsonbProperty(value="filter")
    protected Filter m_filter;
    @JsonbProperty(value="value")
    protected V m_value;
    @JsonbProperty(value="return")
    protected boolean m_fReturn;

    public ConditionalPut() {
    }

    public ConditionalPut(Filter filter, V value) {
        this(filter, value, false);
    }

    public ConditionalPut(Filter filter, V value, boolean fReturn) {
        ConditionalPut.azzert(filter != null, "Filter is null");
        this.m_filter = filter;
        this.m_value = value;
        this.m_fReturn = fReturn;
    }

    @Override
    public V process(InvocableMap.Entry<K, V> entry) {
        if (InvocableMapHelper.evaluateEntry(this.m_filter, entry)) {
            entry.setValue(this.m_value, false);
            return null;
        }
        return this.m_fReturn ? (V)entry.getValue() : null;
    }

    @Override
    public Map<K, V> processAll(Set<? extends InvocableMap.Entry<K, V>> setEntries) {
        LiteMap<K, V> mapResult = new LiteMap<K, V>();
        Filter filter = this.m_filter;
        V oValue = this.m_value;
        boolean fReturn = this.m_fReturn;
        for (InvocableMap.Entry<K, V> entry : setEntries) {
            if (InvocableMapHelper.evaluateEntry(filter, entry)) {
                entry.setValue(oValue, false);
                continue;
            }
            if (!fReturn) continue;
            mapResult.put(entry.getKey(), entry.getValue());
        }
        return mapResult;
    }

    public boolean equals(Object o) {
        if (o instanceof ConditionalPut) {
            ConditionalPut that = (ConditionalPut)o;
            return ConditionalPut.equals(this.m_filter, that.m_filter) && ConditionalPut.equals(this.m_value, that.m_value) && this.m_fReturn == that.m_fReturn;
        }
        return false;
    }

    public int hashCode() {
        V oValue = this.m_value;
        int nHash = oValue == null ? 0 : oValue.hashCode();
        return nHash + this.m_filter.hashCode() + (this.m_fReturn ? -1 : 1);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{Filter = " + this.m_filter + ", Value=" + this.m_value + ", ReturnRequired= " + this.m_fReturn + '}';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)ExternalizableHelper.readObject(in);
        this.m_value = ExternalizableHelper.readObject(in);
        this.m_fReturn = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_filter);
        ExternalizableHelper.writeObject(out, this.m_value);
        out.writeBoolean(this.m_fReturn);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_value = in.readObject(1);
        this.m_fReturn = in.readBoolean(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeObject(1, this.m_value);
        out.writeBoolean(2, this.m_fReturn);
    }
}

