/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.function.Remote;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.json.bind.annotation.JsonbProperty;

public class MethodInvocationProcessor<K, V, R>
implements InvocableMap.EntryProcessor<K, V, R>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="methodName")
    protected String m_sMethodName;
    @JsonbProperty(value="mutator")
    protected boolean m_fMutator;
    @JsonbProperty(value="supplier")
    protected Remote.Supplier<V> m_supplier;
    @JsonbProperty(value="args")
    protected Object[] m_aoArgs;

    public MethodInvocationProcessor() {
    }

    public MethodInvocationProcessor(String sMethodName, boolean fMutator, Object ... aoArgs) {
        this(null, sMethodName, fMutator, aoArgs);
    }

    public MethodInvocationProcessor(Remote.Supplier<V> supplier, String sMethodName, boolean fMutator, Object ... aoArgs) {
        this.m_supplier = supplier;
        this.m_sMethodName = sMethodName;
        this.m_fMutator = fMutator;
        this.m_aoArgs = aoArgs;
    }

    @Override
    public R process(InvocableMap.Entry<K, V> entry) {
        if (!entry.isPresent()) {
            if (this.m_supplier != null) {
                entry.setValue(this.m_supplier.get());
            } else {
                return null;
            }
        }
        ReflectionExtractor extractor = new ReflectionExtractor(this.m_sMethodName, this.m_aoArgs);
        if (this.m_fMutator) {
            V value = entry.getValue();
            Object result = extractor.extract(value);
            entry.setValue(value);
            return (R)result;
        }
        return (R)entry.extract(extractor);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_supplier = (Remote.Supplier)ExternalizableHelper.readObject(in);
        this.m_sMethodName = in.readUTF();
        this.m_fMutator = in.readBoolean();
        this.m_aoArgs = new Object[in.readInt()];
        for (int i = 0; i < this.m_aoArgs.length; ++i) {
            this.m_aoArgs[i] = ExternalizableHelper.readObject(in);
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_supplier);
        out.writeUTF(this.m_sMethodName);
        out.writeBoolean(this.m_fMutator);
        out.writeInt(this.m_aoArgs.length);
        for (int i = 0; i < this.m_aoArgs.length; ++i) {
            ExternalizableHelper.writeObject(out, this.m_aoArgs[i]);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_supplier = (Remote.Supplier)in.readObject(0);
        this.m_sMethodName = in.readString(1);
        this.m_fMutator = in.readBoolean(2);
        this.m_aoArgs = in.readArray(3, Object[]::new);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_supplier);
        out.writeString(1, this.m_sMethodName);
        out.writeBoolean(2, this.m_fMutator);
        out.writeObjectArray(3, this.m_aoArgs);
    }

    public String getMethodName() {
        return this.m_sMethodName;
    }

    public boolean isMutator() {
        return this.m_fMutator;
    }

    public Remote.Supplier<V> getSupplier() {
        return this.m_supplier;
    }

    public Object[] getArgs() {
        return this.m_aoArgs;
    }
}

