/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import util.UTF8FusionObjectOutputStream;

public class Serializerable
implements Callable<byte[]> {
    private final Object object;

    public Serializerable(Object object) {
        this.object = object;
    }

    @Override
    public byte[] call() throws Exception {
        return Serializerable.serialize(this.object);
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Serializerable.serialize(obj, out);
        return out.toByteArray();
    }

    public static void serialize(Object obj, OutputStream out) throws IOException {
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        objOut.writeObject(obj);
    }

    public static byte[] serializeFusion(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Serializerable.serializeFusion(obj, out);
        return out.toByteArray();
    }

    public static void serializeFusion(Object obj, OutputStream out) throws IOException {
        UTF8FusionObjectOutputStream objOut = new UTF8FusionObjectOutputStream(out);
        objOut.writeObject(obj);
    }
}

