/*
 * Decompiled with CFR 0.152.
 */
package payloads;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import payloads.ReleaseableObjectPayload;

public interface ObjectPayload<T> {
    public T getObject(String var1) throws Exception;

    public static class Utils {
        public static Set<Class<? extends ObjectPayload>> getPayloadClasses() {
            Reflections reflections = new Reflections(ObjectPayload.class.getPackage().getName(), new Scanner[0]);
            Set payloadTypes = reflections.getSubTypesOf(ObjectPayload.class);
            Iterator iterator = payloadTypes.iterator();
            while (iterator.hasNext()) {
                Class pc = (Class)iterator.next();
                System.out.println(pc.getCanonicalName());
                if (!pc.isInterface() && !Modifier.isAbstract(pc.getModifiers())) continue;
                iterator.remove();
            }
            return payloadTypes;
        }

        public static Class<? extends ObjectPayload> getPayloadClass(String className) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName("payloads." + className);
                    return clazz;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (clazz != null && !ObjectPayload.class.isAssignableFrom(clazz)) {
                clazz = null;
            }
            return clazz;
        }

        public static Object makePayloadObject(String payloadType, String payloadArg) {
            Object payloadObject;
            Class<? extends ObjectPayload> payloadClass = Utils.getPayloadClass(payloadType);
            if (payloadClass == null || !ObjectPayload.class.isAssignableFrom(payloadClass)) {
                throw new IllegalArgumentException("Invalid payload type '" + payloadType + "'");
            }
            try {
                ObjectPayload payload = payloadClass.newInstance();
                payloadObject = payload.getObject(payloadArg);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to construct payload", e);
            }
            return payloadObject;
        }

        public static void releasePayload(ObjectPayload payload, Object object) throws Exception {
            if (payload instanceof ReleaseableObjectPayload) {
                ((ReleaseableObjectPayload)payload).release(object);
            }
        }

        public static void releasePayload(String payloadType, Object payloadObject) {
            Class<? extends ObjectPayload> payloadClass = Utils.getPayloadClass(payloadType);
            if (payloadClass == null || !ObjectPayload.class.isAssignableFrom(payloadClass)) {
                throw new IllegalArgumentException("Invalid payload type '" + payloadType + "'");
            }
            try {
                ObjectPayload payload = payloadClass.newInstance();
                Utils.releasePayload(payload, payloadObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

