/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import org.apache.commons.lang.ArrayUtils;

public class UTF8FusionObjectOutputStream
extends ObjectOutputStream {
    public UTF8FusionObjectOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    public static byte[] convertChar(char s, int n) {
        if (n == 3) {
            int i = s & 0xFFF;
            byte b1 = (byte)(i >> 12 & 0xF | 0xE0);
            byte b2 = (byte)(i >> 6 & 0x3F | 0x80);
            byte b3 = (byte)(i & 0x3F | 0x80);
            return new byte[]{b1, b2, b3};
        }
        if (n == 2) {
            int i = s & 0xFF;
            byte b1 = (byte)(i >> 6 & 0x1F | 0xC0);
            byte b2 = (byte)(i & 0x3F | 0x80);
            return new byte[]{b1, b2};
        }
        return new byte[]{(byte)s};
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        String name = desc.getName();
        byte[] fusion_bytes = new byte[]{};
        for (int i = 0; i < name.length(); ++i) {
            char s = name.charAt(i);
            Random rand = new Random();
            int randomNum = rand.nextInt(3) + 1;
            byte[] both = ArrayUtils.addAll((byte[])fusion_bytes, (byte[])UTF8FusionObjectOutputStream.convertChar(s, randomNum));
            fusion_bytes = both;
        }
        this.writeShort(fusion_bytes.length);
        this.write(fusion_bytes);
        this.writeLong(desc.getSerialVersionUID());
        try {
            int flags = 0;
            if (((Boolean)UTF8FusionObjectOutputStream.getFieldValue(desc, "externalizable")).booleanValue()) {
                flags = (byte)(flags | 4);
                Field protocolField = ObjectOutputStream.class.getDeclaredField("protocol");
                protocolField.setAccessible(true);
                int protocol = (Integer)protocolField.get(this);
                if (protocol != 1) {
                    flags = (byte)(flags | 8);
                }
            } else if (((Boolean)UTF8FusionObjectOutputStream.getFieldValue(desc, "serializable")).booleanValue()) {
                flags = (byte)(flags | 2);
            }
            if (((Boolean)UTF8FusionObjectOutputStream.getFieldValue(desc, "hasWriteObjectData")).booleanValue()) {
                flags = (byte)(flags | 1);
            }
            if (((Boolean)UTF8FusionObjectOutputStream.getFieldValue(desc, "isEnum")).booleanValue()) {
                flags = (byte)(flags | 0x10);
            }
            this.writeByte(flags);
            ObjectStreamField[] fields = (ObjectStreamField[])UTF8FusionObjectOutputStream.getFieldValue(desc, "fields");
            this.writeShort(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                ObjectStreamField f = fields[i];
                this.writeByte(f.getTypeCode());
                byte[] f_fusion_bytes = new byte[]{};
                for (int ii = 0; ii < f.getName().length(); ++ii) {
                    char ss = f.getName().charAt(ii);
                    Random rand = new Random();
                    int f_randomNum = rand.nextInt(3) + 1;
                    byte[] f_both = ArrayUtils.addAll((byte[])f_fusion_bytes, (byte[])UTF8FusionObjectOutputStream.convertChar(ss, f_randomNum));
                    f_fusion_bytes = f_both;
                }
                this.writeShort(f_fusion_bytes.length);
                this.write(f_fusion_bytes);
                if (f.isPrimitive()) continue;
                Method writeTypeString = ObjectOutputStream.class.getDeclaredMethod("writeTypeString", String.class);
                writeTypeString.setAccessible(true);
                writeTypeString.invoke((Object)this, f.getTypeString());
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        Object value = field.get(object);
        return value;
    }
}

