/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.net.InetAddress;
import java.net.SocketException;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.CommandLine;
import weblogic.management.provider.ManagementService;
import weblogic.security.SSL.SSLClientInfo;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.SSLContextDelegate;
import weblogic.security.utils.SSLContextWrapper;
import weblogic.security.utils.SSLSetupLogging;

public final class SSLSetup
extends SSLSetupLogging {
    public static final int STANDARD_IO = 0;
    public static final int MUXING_IO = 1;
    public static final int LICENSE_NOT_CHECKED = -1;
    public static final int LICENSE_NONE = 0;
    public static final int LICENSE_DOMESTIC = 1;
    public static final int LICENSE_EXPORT = 2;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final String FAILURE_DETAILS = "weblogic.security.ssl.failureDetails";
    private static boolean ioModelAccessed = false;
    private static int ioModel = 0;
    private static int licenseLevel = -1;
    private static int debugLevel = 0;
    private static boolean protocolVersionChecked = false;
    private static int protocolVersion = 3;
    private static boolean enforceConstraintsChecked = false;
    private static int enforceConstraints = 1;
    private static final String CERTICOM_DELEGATE = "com.bea.sslplus.CerticomSSLContext";
    private static final String RSA_DELEGATE = "com.rsa.ssl.WeblogicContextWrapper";
    private static Class sslDelegateClass = null;

    public static synchronized int getLicenseLevel() {
        if (licenseLevel > -1) {
            return licenseLevel;
        }
        licenseLevel = 1;
        String var0 = CERTICOM_DELEGATE;
        SSLSetup.info((String)"Use Certicom SSL with Domestic strength");
        SSLSetup.setSSLDelegate(var0);
        return licenseLevel;
    }

    public static synchronized void initForServer() {
        SSLSetup.setIOModel(1);
        SSLSetup.info((String)"Enabled muxing IO for SSL in server");
    }

    private static void setSSLDelegate(String var0) {
        try {
            sslDelegateClass = Class.forName(var0);
            if (!SSLContextDelegate.class.isAssignableFrom(sslDelegateClass)) {
                String var1 = "Cannot initialize SSL implementation. " + var0 + " does not implement " + SSLContextDelegate.class.getName();
                throw new IllegalArgumentException(var1);
            }
        }
        catch (ClassNotFoundException var3) {
            String var2 = SecurityLogger.getClassNotFound((String)var0);
            throw new IllegalArgumentException(var2, var3);
        }
    }

    static SSLContextDelegate getSSLDelegateInstance() {
        if (licenseLevel == -1) {
            SSLSetup.getLicenseLevel();
        }
        try {
            return (SSLContextDelegate)sslDelegateClass.newInstance();
        }
        catch (IllegalAccessException var2) {
            String var1 = SecurityLogger.getIllegalAccessOnContextWrapper((String)sslDelegateClass.getName());
            throw new RuntimeException(var1, var2);
        }
        catch (InstantiationException var3) {
            String var1 = SecurityLogger.getInstantiationExcOnContextWrapper((String)sslDelegateClass.getName());
            throw new RuntimeException(var1, var3);
        }
    }

    public static int getIOModel() {
        ioModelAccessed = true;
        return ioModel;
    }

    public static boolean logSSLRejections() {
        if (Kernel.isApplet()) {
            return false;
        }
        if (!Kernel.isServer()) {
            return true;
        }
        try {
            return ManagementService.getRuntimeAccess((AuthenticatedSubject)kernelId).getServer().getSSL().isSSLRejectionLoggingEnabled();
        }
        catch (Exception var1) {
            SSLSetup.info((Throwable)var1, (String)"Caught exception in SSLSetup.logSSLRejections");
            return false;
        }
    }

    public static void setIOModel(int var0) {
        if (var0 != 0 && var0 != 1) {
            SSLSetup.debug((int)2, (String)"Attempt to change SSL IO model to invalid setting");
        } else if (ioModelAccessed) {
            SSLSetup.debug((int)2, (String)"Attempt to change SSL IO model after access");
        } else {
            ioModel = var0;
        }
    }

    public static int getProtocolVersion() {
        if (!protocolVersionChecked) {
            try {
                String var0 = CommandLine.getCommandLine().getSSLVersion();
                if (var0 != null) {
                    if (var0.equalsIgnoreCase("SSL3")) {
                        protocolVersion = 1;
                    } else if (var0.equalsIgnoreCase("TLS1")) {
                        protocolVersion = 0;
                    } else if (var0.equalsIgnoreCase("ALL")) {
                        protocolVersion = 3;
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            protocolVersionChecked = true;
        }
        return protocolVersion;
    }

    public static int getEnforceConstraints() {
        if (!enforceConstraintsChecked) {
            try {
                String var0 = CommandLine.getCommandLine().getSSLEnforcementConstraint();
                if (var0 != null) {
                    if (!var0.equalsIgnoreCase("off") && !var0.equalsIgnoreCase("false")) {
                        if (!var0.equalsIgnoreCase("strong") && !var0.equalsIgnoreCase("true")) {
                            if (var0.equalsIgnoreCase("strict")) {
                                enforceConstraints = 2;
                            }
                        } else {
                            enforceConstraints = 1;
                        }
                    } else {
                        enforceConstraints = 0;
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            enforceConstraintsChecked = true;
        }
        return enforceConstraints;
    }

    public static SSLContextWrapper getSSLContext() throws SocketException {
        return SSLSetup.getSSLContext(null);
    }

    public static SSLContextWrapper getSSLContext(SSLClientInfo var0) throws SocketException {
        X509Certificate[] var2;
        SSLContextWrapper var1 = SSLContextWrapper.getInstance();
        if (!Kernel.isApplet() && (var2 = SSLSetup.getTrustedCAs(var1)) != null) {
            try {
                var1.addTrustedCA(var2);
            }
            catch (Exception var4) {
                SSLSetup.debug((int)2, (Throwable)var4, (String)"Failure loading trusted CA list");
            }
        }
        return var1;
    }

    private static void applyInfo(SSLContextWrapper var0, SSLClientInfo var1) throws SocketException {
    }

    private static X509Certificate[] getTrustedCAs(SSLContextWrapper var0) {
        return null;
    }

    public static void setFailureDetails(SSLSession var0, String var1) {
        var0.putValue(FAILURE_DETAILS, var1);
    }

    public static String getFailureDetails(SSLSession var0) {
        return (String)var0.getValue(FAILURE_DETAILS);
    }

    public static void logPlaintextProtocolClientError(SSLSocket var0, String var1) {
        String var2 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("Connection to SSL port was made from " + var2 + " using plaintext protocol: " + var1));
        if (SSLSetup.logSSLRejections()) {
            Loggable var3 = SecurityLogger.logPlaintextProtocolClientErrorLoggable((String)var1, (String)var2);
            var3.log();
            SSLSetup.setFailureDetails(var0.getSession(), var3.getMessage());
        }
    }

    public static void logProtocolVersionError(SSLSocket var0) {
        String var1 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("Connection to SSL port from " + var1 + " appears to be either unknown SSL version or maybe is plaintext"));
        if (SSLSetup.logSSLRejections()) {
            Loggable var2 = SecurityLogger.logProtocolVersionErrorLoggable((String)var1);
            var2.log();
            SSLSetup.setFailureDetails(var0.getSession(), var2.getMessage());
        }
    }

    public static void logCertificateChainConstraintsStrictNonCriticalFailure(SSLSocket var0) {
        String var1 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("The certificate chain received from " + var1 + " contained a V3 CA certificate which had basic constraints which were not marked critical, this is being rejected due to the strict enforcement of basic constraints."));
        if (SSLSetup.logSSLRejections()) {
            Loggable var2 = SecurityLogger.logCertificateChainConstraintsStrictNonCriticalFailureLoggable((String)var1);
            var2.log();
            SSLSetup.setFailureDetails(var0.getSession(), var2.getMessage());
        }
    }

    public static void logCertificateChainMissingConstraintsFailure(SSLSocket var0) {
        String var1 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("The certificate chain received from " + var1 + " contained a V3 CA certificate which was missing the basic constraints extension"));
        if (SSLSetup.logSSLRejections()) {
            Loggable var2 = SecurityLogger.logCertificateChainMissingConstraintsFailureLoggable((String)var1);
            var2.log();
            SSLSetup.setFailureDetails(var0.getSession(), var2.getMessage());
        }
    }

    public static void logCertificateChainNotACaConstraintsFailure(SSLSocket var0) {
        String var1 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("The certificate chain received from " + var1 + " contained a V3 CA certificate which didn't indicate it really is a CA"));
        if (SSLSetup.logSSLRejections()) {
            Loggable var2 = SecurityLogger.logCertificateChainNotACaConstraintsFailureLoggable((String)var1);
            var2.log();
            SSLSetup.setFailureDetails(var0.getSession(), var2.getMessage());
        }
    }

    public static void logCertificateChainPathLenExceededConstraintsFailure(SSLSocket var0) {
        String var1 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("The certificate chain received from " + var1 + " contained a V3 CA certificate which indicated a certificate chain path length in the basic constraints that was exceeded"));
        if (SSLSetup.logSSLRejections()) {
            Loggable var2 = SecurityLogger.logCertificateChainPathLenExceededConstraintsFailureLoggable((String)var1);
            var2.log();
            SSLSetup.setFailureDetails(var0.getSession(), var2.getMessage());
        }
    }

    public static void logCertificateChainConstraintsConversionFailure(SSLSocket var0) {
        String var1 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("The certificate chain received from " + var1 + " contained a V3 CA certificate which couldn't be converted to be checked for basic constraints."));
        if (SSLSetup.logSSLRejections()) {
            Loggable var2 = SecurityLogger.logCertificateChainConstraintsConversionFailureLoggable((String)var1);
            var2.log();
            SSLSetup.setFailureDetails(var0.getSession(), var2.getMessage());
        }
    }

    public static void logCertificateChainUnrecognizedExtensionFailure(SSLSocket var0, String var1) {
        String var2 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("The certificate chain received from " + var2 + " contained a V3 certificate with unrecognized critical extension: " + var1));
        if (SSLSetup.logSSLRejections()) {
            Loggable var3 = SecurityLogger.logCertificateChainUnrecognizedExtensionFailureLoggable((String)var2, (String)var1);
            var3.log();
            SSLSetup.setFailureDetails(var0.getSession(), var3.getMessage());
        }
    }

    public static void logCertificateChainAlgKeyUsageFailure(SSLSocket var0) {
        String var1 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("The certificate chain received from " + var1 + " contained a V3 certificate which key usage constraints indicate its key cannot be used in quality required by the key agreement algorithm"));
        if (SSLSetup.logSSLRejections()) {
            Loggable var2 = SecurityLogger.logCertificateChainAlgKeyUsageFailureLoggable((String)var1);
            var2.log();
            SSLSetup.setFailureDetails(var0.getSession(), var2.getMessage());
        }
    }

    public static void logCertificateChainCheckKeyUsageFailure(SSLSocket var0) {
        String var1 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("Cannot check key usage constraints of certificate recieved from " + var1 + " because of the failure to determine the key agreement algorithm"));
        if (SSLSetup.logSSLRejections()) {
            Loggable var2 = SecurityLogger.logCertificateChainCheckKeyUsageFailureLoggable((String)var1);
            var2.log();
            SSLSetup.setFailureDetails(var0.getSession(), var2.getMessage());
        }
    }

    public static void logCertificateChainCertSignKeyUsageFailure(SSLSocket var0) {
        String var1 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("The certificate chain received from " + var1 + " contained a V3 CA certificate which key usage constraints indicate its key cannot be used to sign certificates"));
        if (SSLSetup.logSSLRejections()) {
            Loggable var2 = SecurityLogger.logCertificateChainCertSignKeyUsageFailureLoggable((String)var1);
            var2.log();
            SSLSetup.setFailureDetails(var0.getSession(), var2.getMessage());
        }
    }

    public static void logCertificatePolicyIdDoesntExistIntheList(SSLSocket var0, String var1) {
        String var2 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("Certificate Policies Extension Processing Failed,PolicyId: " + var1 + " doesn't Exist in the allowed list"));
        if (SSLSetup.logSSLRejections()) {
            Loggable var3 = SecurityLogger.logCertificatePolicyIdDoesntExistIntheListLoggable((String)var1);
            var3.log();
            SSLSetup.setFailureDetails(var0.getSession(), var3.getMessage());
        }
    }

    public static void logPolicyQualifierIdNotCPS(SSLSocket var0, String var1) {
        String var2 = SSLSetup.getPeerName(var0);
        SSLSetup.debug((int)2, (String)("PolicyQualifier Id Found in the Certificate" + var1 + " doesn't match with CPS Qualifier Id"));
        if (SSLSetup.logSSLRejections()) {
            Loggable var3 = SecurityLogger.logPolicyQualifierIdNotCPSLoggable((String)var1);
            var3.log();
            SSLSetup.setFailureDetails(var0.getSession(), var3.getMessage());
        }
    }

    public static String getPeerName(SSLSocket var0) {
        InetAddress var2;
        String var1 = "unknown";
        if (var0 != null && (var2 = var0.getInetAddress()) != null) {
            try {
                var1 = var2.getHostName() + " - " + var2.getHostAddress();
            }
            catch (SecurityException var4) {
                var1 = var2.getHostAddress();
            }
            if (var1 == null) {
                var1 = var2.toString();
            }
        }
        return var1;
    }

    public static void logAlertReceivedFromPeer(SSLSocket var0, int var1) {
        if (SSLSetup.logSSLRejections() && var1 != 0 && var1 != 90) {
            String var2 = SSLSetup.getPeerName(var0);
            Loggable var3 = null;
            switch (var1) {
                case 10: {
                    var3 = SecurityLogger.logUnexpectedMessageAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                default: {
                    var3 = SecurityLogger.logAlertReceivedFromPeerLoggable((String)var2, (String)Integer.toString(var1));
                    break;
                }
                case 20: {
                    var3 = SecurityLogger.logBadRecordMacAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 21: {
                    var3 = SecurityLogger.logDecryptionFailedAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 22: {
                    var3 = SecurityLogger.logRecordOverFlowAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 30: {
                    var3 = SecurityLogger.logDecompressionFailureAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 40: {
                    var3 = SecurityLogger.logHandshakeFailureAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 41: {
                    var3 = SecurityLogger.logNoCertificateAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 42: {
                    var3 = SecurityLogger.logBadCertificateAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 43: {
                    var3 = SecurityLogger.logUnsupportedCertificateAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 44: {
                    var3 = SecurityLogger.logCertificateRevokedAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 45: {
                    var3 = SecurityLogger.logCertificateExpiredAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 46: {
                    var3 = SecurityLogger.logCertificateUnknownAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 47: {
                    var3 = SecurityLogger.logIllegalParameterAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 48: {
                    var3 = SecurityLogger.logUnknownCAAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 49: {
                    var3 = SecurityLogger.logAccessDeniedAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 50: {
                    var3 = SecurityLogger.logDecodeErrorAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 51: {
                    var3 = SecurityLogger.logDecryptErrorAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 60: {
                    var3 = SecurityLogger.logExportRestrictionAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 70: {
                    var3 = SecurityLogger.logProtocolVersionAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 71: {
                    var3 = SecurityLogger.logInsufficientSecurityAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 80: {
                    var3 = SecurityLogger.logInternalErrorAlertReceivedFromPeerLoggable((String)var2);
                    break;
                }
                case 100: {
                    var3 = SecurityLogger.logNoRenegotiationAlertReceivedFromPeerLoggable((String)var2);
                }
            }
            var3.log();
            SSLSetup.setFailureDetails(var0.getSession(), var3.getMessage());
        }
    }

    public static Properties getSSLTrustProperties(ServerMBean var0) {
        Properties var1 = new Properties();
        String var2 = var0.getKeyStores();
        if ("DemoIdentityAndDemoTrust".equals(var2)) {
            SSLSetup.add(var1, "TrustKeyStore", "DemoTrust");
            SSLSetup.add(var1, "JavaStandardTrustKeyStorePassPhrase", var0.getJavaStandardTrustKeyStorePassPhrase());
        } else if ("CustomIdentityAndJavaStandardTrust".equals(var2)) {
            SSLSetup.add(var1, "TrustKeyStore", "JavaStandardTrust");
            SSLSetup.add(var1, "JavaStandardTrustKeyStorePassPhrase", var0.getJavaStandardTrustKeyStorePassPhrase());
        } else if ("CustomIdentityAndCustomTrust".equals(var2)) {
            SSLSetup.add(var1, "TrustKeyStore", "CustomTrust");
            SSLSetup.add(var1, "CustomTrustKeyStoreFileName", var0.getCustomTrustKeyStoreFileName());
            SSLSetup.add(var1, "CustomTrustKeyStoreType", var0.getCustomTrustKeyStoreType());
            SSLSetup.add(var1, "CustomTrustKeyStorePassPhrase", var0.getCustomTrustKeyStorePassPhrase());
        } else if (!"CustomIdentityAndCommandLineTrust".equals(var2)) {
            throw new RuntimeException(SecurityLogger.getAssertionIllegalKeystoresValue((String)var2));
        }
        return var1;
    }

    static boolean isFatClient() {
        return !Kernel.isServer();
    }

    public static void logSSLUsingNullCipher() {
        SecurityLogger.logSSLUsingNullCipher();
    }

    private static void add(Properties var0, String var1, String var2) {
        if (var2 != null) {
            var0.setProperty(var1, var2);
        }
    }
}

