/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.net.InetAddress;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.security.SSL.CertPathTrustManager;
import weblogic.security.SSL.TrustManager;
import weblogic.security.SecurityLogger;
import weblogic.security.utils.SSLSetup;
import weblogic.security.utils.SSLTruster;

public class SSLTrustValidator
implements SSLTruster {
    private boolean peerCertsRequired = false;
    private boolean overrideAllowed = true;
    private TrustManager trustManager = null;
    private byte[][] rootCAFingerPrints = null;
    private String proxyHostName = null;
    private String urlHostName = null;

    public SSLTrustValidator() {
        if (Kernel.isServer()) {
            this.setTrustManager((TrustManager)new CertPathTrustManager());
        }
    }

    public void setTrustManager(TrustManager var1) {
        this.trustManager = var1;
    }

    public void setRootCAFingerPrints(byte[][] var1) {
        this.rootCAFingerPrints = var1;
    }

    public boolean isPeerCertsRequired() {
        return this.peerCertsRequired;
    }

    public void setPeerCertsRequired(boolean var1) {
        this.peerCertsRequired = var1;
    }

    public void setAllowOverride(boolean var1) {
        this.overrideAllowed = var1;
    }

    public void setProxyMapping(String var1, String var2) {
        this.urlHostName = var2;
        this.proxyHostName = var1;
    }

    public int validationCallback(X509Certificate[] var1, int var2, SSLSocket var3, X509Certificate[] var4) {
        return 0;
    }

    private String getTrustManagerClassName() {
        return this.trustManager != null ? this.trustManager.getClass().getName() : null;
    }

    private String getPeerName(SSLSocket var1) {
        InetAddress var3;
        String var2 = SSLSetup.getPeerName(var1);
        if (this.proxyHostName != null && this.urlHostName != null && (var3 = var1.getInetAddress()) != null && (this.proxyHostName.equals(var3.getHostName()) || this.proxyHostName.equals(var3.getHostAddress()))) {
            var2 = var2 + " --> " + this.urlHostName;
        }
        return var2;
    }

    private void logValidationError(int var1, SSLSocket var2) {
        if (SSLSetup.logSSLRejections()) {
            String var3 = this.getPeerName(var2);
            Loggable[] var4 = new Loggable[5];
            int var5 = 0;
            if ((var1 & 1) != 0) {
                var4[var5++] = SecurityLogger.logHandshakeCertInvalidErrorLoggable((String)var3);
            }
            if ((var1 & 2) != 0) {
                var4[var5++] = SecurityLogger.logHandshakeCertExpiredErrorLoggable((String)var3);
            }
            if ((var1 & 4) != 0) {
                Loggable loggable = var4[var5++] = SSLSetup.isFatClient() ? SecurityLogger.logFatClientHandshakeCertIncompleteErrorLoggable((String)var3) : SecurityLogger.logHandshakeCertIncompleteErrorLoggable((String)var3);
            }
            if ((var1 & 0x10) != 0) {
                Loggable loggable = var4[var5++] = SSLSetup.isFatClient() ? SecurityLogger.logFatClientHandshakeCertUntrustedErrorLoggable((String)var3) : SecurityLogger.logHandshakeCertUntrustedErrorLoggable((String)var3);
            }
            if ((var1 & 0x20) != 0) {
                Loggable loggable = var4[var5++] = SSLSetup.isFatClient() ? SecurityLogger.logFatClientHandshakeCertValidationErrorLoggable((String)var3, (String)this.getTrustManagerClassName()) : SecurityLogger.logHandshakeCertValidationErrorLoggable((String)var3, (String)this.getTrustManagerClassName());
            }
            if (var5 > 0) {
                StringBuffer var6 = null;
                if (var2 != null) {
                    var6 = new StringBuffer();
                }
                for (int var7 = 0; var7 < var5; ++var7) {
                    var4[var7].log();
                    if (var2 == null) continue;
                    if (var7 > 0) {
                        var6.append(", ");
                    }
                    var6.append(var4[var7].getMessage());
                }
                if (var2 != null) {
                    SSLSetup.setFailureDetails(var2.getSession(), var6.toString());
                }
            }
        }
        if (SSLSetup.isDebugEnabled()) {
            SSLSetup.info((String)("Validation error = " + var1));
            if ((var1 & 1) != 0) {
                SSLSetup.info((String)"Certificate chain is invalid");
            }
            if ((var1 & 2) != 0) {
                SSLSetup.info((String)"Expired certificate");
            }
            if ((var1 & 4) != 0) {
                SSLSetup.info((String)"Certificate chain is incomplete");
            }
            if ((var1 & 0x10) != 0) {
                SSLSetup.info((String)"Certificate chain is untrusted");
            }
            if ((var1 & 0x20) != 0) {
                SSLSetup.info((String)"Certificate chain was not validated by the custom trust manager even though built-in SSL validated it.");
            }
        }
    }
}

