/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.util;

import com.tangosol.coherence.mvel2.ScriptRuntimeException;
import com.tangosol.coherence.mvel2.math.MathProcessor;
import com.tangosol.coherence.mvel2.util.StackElement;

public class ExecutionStack {
    private StackElement element;
    private int size = 0;

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(Object o) {
        ++this.size;
        StackElement el = this.element;
        if (el != null) {
            while (el.next != null) {
                el = el.next;
            }
            el.next = new StackElement(null, o);
        } else {
            this.element = new StackElement(null, o);
        }
    }

    public void push(Object o) {
        ++this.size;
        this.element = new StackElement(this.element, o);
        assert (this.size == this.deepCount());
    }

    public void push(Object obj1, Object obj2) {
        this.size += 2;
        this.element = new StackElement(new StackElement(this.element, obj1), obj2);
        assert (this.size == this.deepCount());
    }

    public void push(Object obj1, Object obj2, Object obj3) {
        this.size += 3;
        this.element = new StackElement(new StackElement(new StackElement(this.element, obj1), obj2), obj3);
        assert (this.size == this.deepCount());
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.element.value;
    }

    public void dup() {
        ++this.size;
        this.element = new StackElement(this.element, this.element.value);
        assert (this.size == this.deepCount());
    }

    public Boolean peekBoolean() {
        if (this.size == 0) {
            return null;
        }
        if (this.element.value instanceof Boolean) {
            return (Boolean)this.element.value;
        }
        throw new ScriptRuntimeException("expected Boolean; but found: " + (this.element.value == null ? "null" : this.element.value.getClass().getName()));
    }

    public void copy2(ExecutionStack es) {
        this.element = new StackElement(new StackElement(this.element, es.element.value), es.element.next.value);
        es.element = es.element.next.next;
        this.size += 2;
        es.size -= 2;
    }

    public void copyx2(ExecutionStack es) {
        this.element = new StackElement(new StackElement(this.element, es.element.next.value), es.element.value);
        es.element = es.element.next.next;
        this.size += 2;
        es.size -= 2;
    }

    public Object peek2() {
        return this.element.next.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pop() {
        if (this.size == 0) {
            return null;
        }
        try {
            --this.size;
            Object object = this.element.value;
            return object;
        }
        finally {
            this.element = this.element.next;
            assert (this.size == this.deepCount());
        }
    }

    public Boolean popBoolean() {
        if (this.size-- == 0) {
            return null;
        }
        try {
            if (this.element.value instanceof Boolean) {
                Boolean bl = (Boolean)this.element.value;
                return bl;
            }
            throw new ScriptRuntimeException("expected Boolean; but found: " + (this.element.value == null ? "null" : this.element.value.getClass().getName()));
        }
        finally {
            this.element = this.element.next;
            assert (this.size == this.deepCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pop2() {
        try {
            this.size -= 2;
            Object object = this.element.value;
            return object;
        }
        finally {
            this.element = this.element.next.next;
            assert (this.size == this.deepCount());
        }
    }

    public void discard() {
        if (this.size != 0) {
            --this.size;
            this.element = this.element.next;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isReduceable() {
        return this.size > 1;
    }

    public void clear() {
        this.size = 0;
        this.element = null;
    }

    public void xswap_op() {
        this.element = new StackElement(this.element.next.next.next, MathProcessor.doOperations(this.element.next.next.value, (Integer)this.element.next.value, this.element.value));
        this.size -= 2;
        assert (this.size == this.deepCount());
    }

    public void op() {
        this.element = new StackElement(this.element.next.next.next, MathProcessor.doOperations(this.element.next.next.value, (Integer)this.element.value, this.element.next.value));
        this.size -= 2;
        assert (this.size == this.deepCount());
    }

    public void op(int operator) {
        this.element = new StackElement(this.element.next.next, MathProcessor.doOperations(this.element.next.value, operator, this.element.value));
        --this.size;
        assert (this.size == this.deepCount());
    }

    public void xswap() {
        StackElement e = this.element.next;
        StackElement relink = e.next;
        e.next = this.element;
        this.element = e;
        e.next.next = relink;
    }

    public void xswap2() {
        StackElement node2 = this.element.next;
        StackElement node3 = node2.next;
        node2.next = this.element;
        this.element.next = node3.next;
        this.element = node3;
        this.element.next = node2;
    }

    public int deepCount() {
        int count = 0;
        if (this.element == null) {
            return 0;
        }
        ++count;
        StackElement element = this.element;
        while ((element = element.next) != null) {
            ++count;
        }
        return count;
    }

    public String toString() {
        StackElement el = this.element;
        if (this.element == null) {
            return "<EMPTY>";
        }
        StringBuilder appender = new StringBuilder().append("[");
        do {
            appender.append(String.valueOf(el.value));
            if (el.next == null) continue;
            appender.append(", ");
        } while ((el = el.next) != null);
        appender.append("]");
        return appender.toString();
    }
}

