/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.events;

import com.oracle.common.collections.WrapperCollections;
import com.tangosol.coherence.rest.events.SimpleMapEvent;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.filter.MapEventFilter;
import java.io.IOException;
import java.util.HashSet;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;

public class MapEventOutput<K, V>
extends EventOutput
implements MapListener<K, V> {
    private static final WrapperCollections.ConcurrentWrapperSet<MapEventOutput> REGISTRY = new WrapperCollections.ConcurrentWrapperSet(new HashSet());
    private NamedCache<K, V> m_cache;
    private MapEventFilter m_filter;
    private K m_key;
    private boolean m_fLite;
    private Type m_type = Type.CACHE;

    public MapEventOutput(NamedCache<K, V> cache, boolean fLite) {
        this.m_cache = cache;
        this.m_fLite = fLite;
    }

    public MapEventOutput setFilter(Filter filter) {
        if (this.m_type == Type.KEY) {
            throw new IllegalStateException("Only key or filter can be set, but not both");
        }
        this.m_filter = filter instanceof MapEventFilter ? (MapEventFilter)filter : new MapEventFilter(7, filter);
        this.m_type = Type.FILTER;
        return this;
    }

    public MapEventOutput setKey(K key) {
        if (this.m_type == Type.FILTER) {
            throw new IllegalStateException("Only key or filter can be set, but not both");
        }
        this.m_key = key;
        this.m_type = Type.KEY;
        return this;
    }

    public void close() throws IOException {
        this.unregister();
        super.close();
    }

    @Override
    public void entryInserted(MapEvent<K, V> evt) {
        this.writeEvent("insert", evt);
    }

    @Override
    public void entryUpdated(MapEvent<K, V> evt) {
        String sName = "update";
        if (this.m_type == Type.FILTER) {
            Filter filter = this.m_filter.getFilter();
            boolean fOld = InvocableMapHelper.evaluateEntry(filter, evt.getOldEntry());
            boolean fNew = InvocableMapHelper.evaluateEntry(filter, evt.getNewEntry());
            if (!fOld && fNew) {
                sName = "insert";
            } else if (fOld && !fNew) {
                sName = "delete";
            }
        }
        this.writeEvent(sName, evt);
    }

    @Override
    public void entryDeleted(MapEvent<K, V> evt) {
        this.writeEvent("delete", evt);
    }

    public void register() {
        switch (this.m_type) {
            case CACHE: {
                this.m_cache.addMapListener(this);
                break;
            }
            case FILTER: {
                this.m_cache.addMapListener((MapListener<K, V>)this, this.m_filter, this.m_fLite);
                break;
            }
            case KEY: {
                this.m_cache.addMapListener(this, this.m_key, this.m_fLite);
            }
        }
        REGISTRY.add((Object)this);
        if (CacheFactory.isLogEnabled(9)) {
            CacheFactory.log("Registered listener: " + this, 9);
        }
    }

    protected void unregister() {
        switch (this.m_type) {
            case CACHE: {
                this.m_cache.removeMapListener(this);
                break;
            }
            case FILTER: {
                this.m_cache.removeMapListener((MapListener<K, V>)this, this.m_filter);
                break;
            }
            case KEY: {
                this.m_cache.removeMapListener(this, this.m_key);
            }
        }
        REGISTRY.remove((Object)this);
        if (CacheFactory.isLogEnabled(9)) {
            CacheFactory.log("Unregistered listener: " + this, 9);
        }
    }

    protected void writeEvent(String sName, MapEvent<? extends K, ? extends V> evt) {
        try {
            this.write(this.createEvent(sName, evt));
        }
        catch (IOException e) {
            if (this.isClosed()) {
                this.unregister();
            }
            throw new RuntimeException(e);
        }
    }

    protected OutboundEvent createEvent(String sName, MapEvent<? extends K, ? extends V> evt) {
        return new OutboundEvent.Builder().name(sName).data(SimpleMapEvent.class, new SimpleMapEvent<K, V>(evt)).mediaType(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public String toString() {
        return "MapEventOutput{cache=" + this.m_cache.getCacheName() + ", filter=" + this.m_filter + ", key=" + this.m_key + ", fLite=" + this.m_fLite + ", type=" + (Object)((Object)this.m_type) + '}';
    }

    private static enum Type {
        CACHE,
        FILTER,
        KEY;

    }
}

