/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.providers;

import java.io.IOException;
import java.security.Principal;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.internal.util.Base64;
import org.glassfish.jersey.server.ContainerRequest;

@Provider
@PreMatching
public class SecurityFilter
implements ContainerRequestFilter {
    @Inject
    javax.inject.Provider<UriInfo> uriInfo;

    public void filter(ContainerRequestContext filterContext) throws IOException {
        SecurityContext securityContext = this.authenticate((ContainerRequest)filterContext.getRequest(), filterContext.getSecurityContext());
        if (securityContext != null) {
            filterContext.setSecurityContext(securityContext);
        }
    }

    private SecurityContext authenticate(ContainerRequest request, Object securityContext) {
        String authentication = request.getHeaderString("Authorization");
        Principal principal = null;
        if (authentication == null) {
            if (securityContext instanceof SecurityContext) {
                try {
                    principal = ((SecurityContext)securityContext).getUserPrincipal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (principal == null) {
                return null;
            }
            return new Authorizer(principal.getName(), principal, "CLIENT_CERT");
        }
        if (!authentication.startsWith("Basic ")) {
            return null;
        }
        String[] values = Base64.decodeAsString((String)(authentication = authentication.substring("Basic ".length()))).split(":");
        if (values.length < 2) {
            throw new WebApplicationException(400);
        }
        String sUsername = values[0];
        String sPassword = values[1];
        if (sUsername == null || sPassword == null) {
            throw new WebApplicationException(400);
        }
        return new Authorizer(sUsername);
    }

    public class Authorizer
    implements SecurityContext {
        private String m_username;
        private Principal m_principal;
        private String m_role;
        private String m_authScheme = "BASIC";

        public Authorizer(String username) {
            this.m_username = username;
            this.m_principal = new Principal(){

                @Override
                public String getName() {
                    return Authorizer.this.m_username;
                }
            };
        }

        public Authorizer(String username, Principal principal, String scheme) {
            this.m_username = username;
            this.m_principal = principal;
            this.m_authScheme = scheme;
        }

        public Principal getUserPrincipal() {
            return this.m_principal;
        }

        public boolean isUserInRole(String role) {
            return role.equals(this.m_role);
        }

        public boolean isSecure() {
            return "https".equals(((UriInfo)SecurityFilter.this.uriInfo.get()).getRequestUri().getScheme());
        }

        public String getAuthenticationScheme() {
            return this.m_authScheme;
        }

        public void setAuthenticationScheme(String scheme) {
            this.m_authScheme = scheme;
        }

        public String getRole() {
            return this.m_role;
        }

        public void setRole(String role) {
            this.m_role = role;
        }
    }
}

