/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.server;

import com.tangosol.coherence.rest.config.RestConfig;
import com.tangosol.coherence.rest.io.MarshallerRegistry;
import com.tangosol.coherence.rest.query.QueryEngineRegistry;
import com.tangosol.coherence.rest.util.aggregator.AggregatorRegistry;
import com.tangosol.coherence.rest.util.processor.ProcessorRegistry;
import com.tangosol.net.Session;
import com.tangosol.net.options.WithClassLoader;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class InjectionBinder
extends AbstractBinder {
    protected final boolean m_fContainer;

    public InjectionBinder(boolean fContainer) {
        this.m_fContainer = fContainer;
    }

    protected void configure() {
        if (this.m_fContainer) {
            this.bind(Session.create(WithClassLoader.autoDetect())).to(Session.class);
        }
        this.bindFactory(RestConfigFactory.class).to(RestConfig.class).in(Singleton.class);
        this.bindFactory(MarshallerRegistryFactory.class).to(MarshallerRegistry.class).in(Singleton.class);
        this.bindFactory(ProcessorRegistryFactory.class).to(ProcessorRegistry.class).in(Singleton.class);
        this.bindFactory(AggregatorRegistryFactory.class).to(AggregatorRegistry.class).in(Singleton.class);
        this.bindFactory(QueryEngineRegistryFactory.class).to(QueryEngineRegistry.class).in(Singleton.class);
    }

    public static <T> T inject(T resource, ServiceLocator locator) {
        locator.inject(resource);
        locator.postConstruct(resource);
        return resource;
    }

    private static class QueryEngineRegistryFactory
    implements Factory<QueryEngineRegistry> {
        @Inject
        private RestConfig m_config;

        private QueryEngineRegistryFactory() {
        }

        public QueryEngineRegistry provide() {
            return this.m_config != null ? this.m_config.getQueryEngineRegistry() : new QueryEngineRegistry();
        }

        public void dispose(QueryEngineRegistry instance) {
        }
    }

    private static class AggregatorRegistryFactory
    implements Factory<AggregatorRegistry> {
        @Inject
        private RestConfig m_config;

        private AggregatorRegistryFactory() {
        }

        public AggregatorRegistry provide() {
            return this.m_config != null ? this.m_config.getAggregatorRegistry() : new AggregatorRegistry();
        }

        public void dispose(AggregatorRegistry instance) {
        }
    }

    private static class ProcessorRegistryFactory
    implements Factory<ProcessorRegistry> {
        @Inject
        private RestConfig m_config;

        private ProcessorRegistryFactory() {
        }

        public ProcessorRegistry provide() {
            return this.m_config != null ? this.m_config.getProcessorRegistry() : new ProcessorRegistry();
        }

        public void dispose(ProcessorRegistry instance) {
        }
    }

    private static class MarshallerRegistryFactory
    implements Factory<MarshallerRegistry> {
        @Inject
        private RestConfig m_config;

        private MarshallerRegistryFactory() {
        }

        public MarshallerRegistry provide() {
            return this.m_config != null ? this.m_config.getMarshallerRegistry() : new MarshallerRegistry();
        }

        public void dispose(MarshallerRegistry instance) {
        }
    }

    private static class RestConfigFactory
    implements Factory<RestConfig> {
        private RestConfigFactory() {
        }

        public RestConfig provide() {
            return RestConfig.create();
        }

        public void dispose(RestConfig instance) {
        }
    }
}

