/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StaticContent
implements ExternalizableLite,
PortableObject {
    protected Binary m_binContent;
    protected String m_sMediaType;

    public StaticContent() {
    }

    public StaticContent(Binary binContent, String sMediaType) {
        this.m_binContent = binContent;
        this.m_sMediaType = sMediaType;
    }

    @JsonIgnore
    public Binary getContent() {
        return this.m_binContent;
    }

    @JsonProperty
    public String getMediaType() {
        return this.m_sMediaType;
    }

    @JsonProperty
    public int getSize() {
        return this.m_binContent.length();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sMediaType = ExternalizableHelper.readSafeUTF(in);
        Binary binContent = new Binary();
        binContent.readExternal(in);
        this.m_binContent = binContent;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF(out, this.m_sMediaType);
        this.m_binContent.writeExternal(out);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sMediaType = in.readString(0);
        this.m_binContent = in.readBinary(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sMediaType);
        out.writeBinary(1, this.m_binContent);
    }
}

