/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util.aggregator;

import com.tangosol.coherence.rest.util.aggregator.AggregatorFactory;
import com.tangosol.coherence.rest.util.extractor.MvelExtractor;
import com.tangosol.util.Base;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public class DefaultAggregatorFactory
implements AggregatorFactory {
    private final Constructor m_ctorAggr;

    public DefaultAggregatorFactory(Class clzAggr) {
        if (clzAggr == null || !InvocableMap.EntryAggregator.class.isAssignableFrom(clzAggr)) {
            throw new IllegalArgumentException(clzAggr + " is not a valid aggregator class");
        }
        Constructor ctor = this.getConstructor(clzAggr.getConstructors());
        if (ctor == null) {
            throw new IllegalArgumentException("the aggregator class \"" + clzAggr.getName() + "\" cannot be used with the DefaultAggregatorFactory");
        }
        this.m_ctorAggr = ctor;
    }

    public InvocableMap.EntryAggregator getAggregator(String ... asArgs) {
        AbstractExtractor extractor = null;
        switch (asArgs.length) {
            case 0: {
                if (this.m_ctorAggr.getParameterTypes().length != 1) break;
                extractor = IdentityExtractor.INSTANCE;
                break;
            }
            case 1: {
                extractor = new MvelExtractor(asArgs[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("DefaultAggregatorFactory cannot be used with the given arguments: " + Arrays.toString(asArgs));
            }
        }
        return this.createAggregator(extractor);
    }

    protected InvocableMap.EntryAggregator createAggregator(ValueExtractor extractor) {
        try {
            Object[] objectArray;
            if (extractor == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new ValueExtractor[1];
                objectArray = objectArray2;
                objectArray2[0] = extractor;
            }
            Object[] ao = objectArray;
            return (InvocableMap.EntryAggregator)this.m_ctorAggr.newInstance(ao);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected Constructor getConstructor(Constructor[] aCtors) {
        Constructor ctorDefault = null;
        Constructor ctorExtractor = null;
        for (Constructor ctor : aCtors) {
            Class<?>[] aclzParams = ctor.getParameterTypes();
            int cclzParams = aclzParams.length;
            if (cclzParams == 0) {
                ctorDefault = ctor;
                continue;
            }
            if (cclzParams != 1 || !ValueExtractor.class.isAssignableFrom(aclzParams[0])) continue;
            ctorExtractor = ctor;
            break;
        }
        return ctorExtractor == null ? ctorDefault : ctorExtractor;
    }
}

