/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util.processor;

import com.tangosol.coherence.rest.util.processor.ProcessorFactory;
import com.tangosol.util.Base;
import com.tangosol.util.InvocableMap;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public class DefaultProcessorFactory
implements ProcessorFactory {
    private final Constructor m_ctorProcessor;

    public DefaultProcessorFactory(Class clzProcessor) {
        if (clzProcessor == null || !InvocableMap.EntryProcessor.class.isAssignableFrom(clzProcessor)) {
            throw new IllegalArgumentException(clzProcessor + " is not a valid processor class");
        }
        Constructor ctor = this.getConstructor(clzProcessor.getConstructors());
        if (ctor == null) {
            throw new IllegalArgumentException("the processor class \"" + clzProcessor.getName() + "\" cannot be used with the DefaultProcessorFactory");
        }
        this.m_ctorProcessor = ctor;
    }

    public InvocableMap.EntryProcessor getProcessor(String ... asArgs) {
        String sProperty = null;
        switch (asArgs.length) {
            case 0: {
                break;
            }
            case 1: {
                sProperty = asArgs[0];
                break;
            }
            default: {
                throw new IllegalArgumentException("DefaultProcessorFactory cannot be used with the given arguments: " + Arrays.toString(asArgs));
            }
        }
        return this.createProcessor(sProperty);
    }

    protected InvocableMap.EntryProcessor createProcessor(String sProperty) {
        try {
            return sProperty == null ? (InvocableMap.EntryProcessor)this.m_ctorProcessor.newInstance(new Object[0]) : (InvocableMap.EntryProcessor)this.m_ctorProcessor.newInstance(sProperty);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected Constructor getConstructor(Constructor[] aCtors) {
        Constructor ctorDefault = null;
        Constructor ctorProperty = null;
        for (Constructor ctor : aCtors) {
            Class<?>[] aclzParams = ctor.getParameterTypes();
            int cclzParams = aclzParams.length;
            if (cclzParams == 0) {
                ctorDefault = ctor;
                continue;
            }
            if (cclzParams != 1 || !String.class.isAssignableFrom(aclzParams[0])) continue;
            ctorProperty = ctor;
            break;
        }
        return ctorProperty == null ? ctorDefault : ctorProperty;
    }
}

