/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import weblogic.corba.j2ee.naming.EndPointSelector;
import weblogic.corba.j2ee.naming.NameParser;

public class EndPointList
implements Iterable<EndPointSelector> {
    private LoadBalancingType loadBalancingType;
    private int current = 0;
    private EndPointSelector[] endPointList;
    private static final NumberGenerator RANDOM_NUMBER_GENERATOR;
    private static NumberGenerator numberGenerator;

    boolean isUsingRandomLoadBalancing() {
        return this.loadBalancingType == LoadBalancingType.random;
    }

    public final EndPointSelector getStartingEndPoint() {
        return this.endPointList[this.current];
    }

    public EndPointIterator iterator() {
        return new EndPointIterator(this.getEndPointIndices());
    }

    private int[] getEndPointIndices() {
        return this.loadBalancingType.getEndPointIndices(this.endPointList.length, this.current);
    }

    public static EndPointList createEndPointList(String url) throws InvalidNameException {
        if (url == null) {
            throw new InvalidNameException("url is null");
        }
        String protocol = NameParser.getUrlClientProtocol(url);
        if ("complex".equals(protocol)) {
            return EndPointList.parseComplexURL(url);
        }
        if (protocol != null) {
            return EndPointList.parseSimpleUrl(protocol, url);
        }
        return null;
    }

    private static EndPointList parseSimpleUrl(String protocol, String url) throws InvalidNameException {
        String endPointList = url.substring(url.indexOf(58) + 1);
        if (!endPointList.startsWith("//")) {
            throw new InvalidNameException("url does not contain //");
        }
        endPointList = endPointList.substring(2);
        LoadBalancingType loadBalancingType = EndPointList.selectLoadBalancingType(endPointList);
        endPointList = endPointList.replace('|', ',');
        ArrayList<EndPointSelector> endPoints = new ArrayList<EndPointSelector>();
        StringTokenizer st = new StringTokenizer(endPointList, ",");
        while (st.hasMoreTokens()) {
            endPoints.add(EndPointSelector.createSimpleEndPoint(protocol, st.nextToken()));
        }
        return new EndPointList(loadBalancingType, endPoints);
    }

    private static LoadBalancingType selectLoadBalancingType(String addressList) {
        return addressList.contains("|") ? LoadBalancingType.random : LoadBalancingType.round_robin;
    }

    private EndPointList(LoadBalancingType loadBalancingType, List<EndPointSelector> endPointList) {
        this.loadBalancingType = loadBalancingType;
        this.endPointList = endPointList.toArray(new EndPointSelector[endPointList.size()]);
        this.randomizeStart();
    }

    private void randomizeStart() {
        this.current = (int)Math.round(numberGenerator.getNextNumber() * (double)this.endPointList.length + 0.5) - 1;
    }

    private static EndPointList parseComplexURL(String url) throws InvalidNameException {
        String serviceName;
        String addressList;
        String urlType = url.split(":", 2)[0];
        String body = url.split(":", 2)[1];
        if (urlType.equalsIgnoreCase("corbaloc")) {
            if (!body.contains("/")) {
                throw new InvalidNameException("bad corbaloc syntax: no service name specified");
            }
            addressList = body.split("/")[0];
            serviceName = body.split("/")[1];
        } else {
            addressList = body.split("#")[0];
            if (!addressList.contains("/")) {
                serviceName = "NameService";
            } else {
                addressList = addressList.split("/")[0];
                serviceName = addressList.split("/")[1];
            }
        }
        LoadBalancingType loadBalancingType = EndPointList.selectLoadBalancingType(addressList);
        addressList = addressList.replace('|', ',');
        ArrayList<EndPointSelector> endPoints = new ArrayList<EndPointSelector>();
        StringTokenizer st = new StringTokenizer(addressList, ",");
        while (st.hasMoreTokens()) {
            endPoints.add(EndPointSelector.createServiceEndPoint(serviceName, st.nextToken()));
        }
        return new EndPointList(loadBalancingType, endPoints);
    }

    public String toString() {
        return Arrays.toString(this.endPointList);
    }

    static void setNumberGenerator(NumberGenerator numberGenerator) {
        EndPointList.numberGenerator = numberGenerator;
    }

    static void resetNumberGenerator() {
        numberGenerator = RANDOM_NUMBER_GENERATOR;
    }

    static {
        numberGenerator = RANDOM_NUMBER_GENERATOR = new RandomNumberGenerator();
    }

    class EndPointIterator
    implements Iterator<EndPointSelector> {
        private int[] endPointIndices;
        private int nextIndex;

        EndPointIterator(int[] endPointIndices) {
            this.endPointIndices = endPointIndices;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.endPointIndices.length;
        }

        @Override
        public EndPointSelector next() {
            if (this.nextIndex >= this.endPointIndices.length) {
                throw new NoSuchElementException();
            }
            return EndPointList.this.endPointList[this.endPointIndices[this.nextIndex++]];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public void selectCurrentAsStart() {
            if (this.nextIndex > 0) {
                EndPointList.this.current = this.endPointIndices[this.nextIndex - 1];
            }
        }

        public void selectNextAsStart() {
            if (this.nextIndex > 0) {
                EndPointList.this.current = this.endPointIndices[Math.min(this.nextIndex, this.endPointIndices.length - 1)];
            }
        }
    }

    private static class RandomNumberGenerator
    implements NumberGenerator {
        private RandomNumberGenerator() {
        }

        @Override
        public double getNextNumber() {
            return Math.random();
        }
    }

    static interface NumberGenerator {
        public double getNextNumber();
    }

    static enum LoadBalancingType {
        round_robin{

            @Override
            int[] getEndPointIndices(int length, int first) {
                return LoadBalancingType.createOrderedArray(length, first);
            }
        }
        ,
        random{

            @Override
            int[] getEndPointIndices(int length, int first) {
                int[] result = LoadBalancingType.createOrderedArray(length, 0);
                this.shuffle(result);
                this.swapElements(result, 0, this.getIndexOf(result, first));
                return result;
            }

            private void shuffle(int[] array) {
                Random random = new Random();
                for (int i = array.length - 1; i > 0; --i) {
                    this.swapElements(array, i, random.nextInt(i + 1));
                }
            }

            private void swapElements(int[] array, int i, int j) {
                int temp = array[i];
                array[i] = array[j];
                array[j] = temp;
            }

            private int getIndexOf(int[] array, int value) {
                int offset;
                for (offset = 0; offset < array.length && array[offset] != value; ++offset) {
                }
                return offset;
            }
        };


        private static int[] createOrderedArray(int length, int first) {
            int[] result = new int[length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (first + i) % result.length;
            }
            return result;
        }

        abstract int[] getEndPointIndices(int var1, int var2);
    }
}

