/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.repository;

import java.util.Map;
import java.util.WeakHashMap;
import javax.validation.constraints.NotNull;
import org.omg.CORBA.BAD_PARAM;
import weblogic.corba.utils.ClassInfo;

public class SentClassesRepository {
    private static Map<String, ClassInfo> repositoryIdToClassInfoMap = new WeakHashMap<String, ClassInfo>();

    @NotNull
    public static ClassInfo findClassInfo(Class<?> aClass) {
        ClassInfo classInfo = ClassInfo.findClassInfo(aClass);
        if (SentClassesRepository.lookup(SentClassesRepository.getRepositoryIdString(classInfo)) == null) {
            repositoryIdToClassInfoMap.put(SentClassesRepository.getRepositoryIdString(classInfo), classInfo);
        }
        return classInfo;
    }

    private static String getRepositoryIdString(ClassInfo classInfo) {
        return classInfo.getRepositoryId().toString();
    }

    private static ClassInfo lookup(String repositoryId) {
        return repositoryIdToClassInfoMap.get(repositoryId);
    }

    @NotNull
    public static ClassInfo findClassInfo(String repositoryId) {
        ClassInfo classInfo = SentClassesRepository.lookup(repositoryId);
        if (classInfo == null) {
            throw new BAD_PARAM("Could not find FVD class for: " + repositoryId);
        }
        return classInfo;
    }
}

