/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.ior;

import java.io.IOException;
import weblogic.iiop.ior.ReplicaType;
import weblogic.iiop.protocol.CorbaInputStream;
import weblogic.iiop.protocol.CorbaOutputStream;
import weblogic.rmi.cluster.ReplicaID;
import weblogic.rmi.cluster.ReplicaVersion;

public class ReplicaState {
    private static final ReplicaVersion NULL_REPLICA_VERSION = new ReplicaVersion(0);
    private ReplicaType replicaType = ReplicaType.none;
    private ReplicaID replicaID = null;
    private ReplicaVersion replicaVersion = NULL_REPLICA_VERSION;

    public void copy(ReplicaState other) {
        this.setReplicaID(other.replicaID);
        this.setReplicaVersion(other.replicaVersion);
    }

    public ReplicaID getReplicaID() {
        return this.replicaID;
    }

    public void setReplicaID(ReplicaID id) {
        this.replicaID = id;
        this.replicaType = ReplicaType.forId(id);
    }

    public boolean isReplicaVersionChanged() {
        return this.replicaVersion != null && this.replicaVersion.hasVersionChanged();
    }

    public ReplicaVersion getReplicaVersion() {
        return this.replicaVersion;
    }

    public void setReplicaVersion(ReplicaVersion rv) {
        if (rv == null) {
            this.replicaVersion = NULL_REPLICA_VERSION;
        } else if (this.replicaVersion.equals((Object)NULL_REPLICA_VERSION)) {
            this.replicaVersion = new ReplicaVersion(rv.getVersion());
        } else {
            this.replicaVersion.copy(rv);
        }
    }

    public void read(CorbaInputStream in) {
        this.readReplicaId(in);
        this.readReplicaVersion(in);
    }

    private void readReplicaVersion(CorbaInputStream in) {
        this.replicaVersion = new ReplicaVersion(in.read_long());
    }

    private void readReplicaId(CorbaInputStream in) {
        try {
            this.replicaType = ReplicaType.values()[in.read_ulong()];
            this.replicaID = this.replicaType.read_value(in);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("unable to deserialize replicaId", e);
        }
    }

    public void write(CorbaOutputStream out) {
        this.writeReplicaId(out);
        this.writeReplicaVersion(out);
    }

    private void writeReplicaVersion(CorbaOutputStream out) {
        out.write_long(this.replicaVersion.getVersion());
    }

    private void writeReplicaId(CorbaOutputStream out) {
        try {
            out.write_ulong(this.replicaType.ordinal());
            this.replicaType.write_value(out, this.replicaID);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to serialize replicaId", e);
        }
    }
}

