/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.ior;

import java.util.ArrayList;
import java.util.List;
import weblogic.corba.cos.security.GSSUtil;
import weblogic.iiop.ior.RequirementType;
import weblogic.iiop.protocol.CorbaInputStream;
import weblogic.iiop.protocol.CorbaOutputStream;

public class SASContextSec {
    private static final int SUPPORTED_TYPES = 15;
    private short supports = 0;
    private short requires = 0;
    private int supportedIdentityTypes = 0;
    private List<byte[]> oidSequences = new ArrayList<byte[]>();

    public SASContextSec(RequirementType assertionRequirement, int supportedIdentityTypes) {
        this.supportedIdentityTypes = supportedIdentityTypes;
        if (supportedIdentityTypes != 0) {
            this.setFlags(assertionRequirement);
        }
        this.oidSequences.add(GSSUtil.getGSSUPMech());
    }

    private void setFlags(RequirementType assertionRequirement) {
        switch (assertionRequirement) {
            case REQUIRED: {
                this.requires = (short)1024;
            }
            case SUPPORTED: {
                this.supports = (short)1024;
            }
        }
    }

    public SASContextSec(CorbaInputStream in) {
        this.read(in);
    }

    public final void read(CorbaInputStream in) {
        this.supports = in.read_short();
        this.requires = in.read_short();
        this.readAndIgnoreServiceConfigurationList(in);
        this.oidSequences = new ArrayList<byte[]>();
        int numOIDs = in.read_long();
        for (int i = 0; i < numOIDs; ++i) {
            this.oidSequences.add(in.read_octet_sequence());
        }
        this.supportedIdentityTypes = in.read_long();
    }

    private void readAndIgnoreServiceConfigurationList(CorbaInputStream in) {
        int numServiceConfigurations = in.read_long();
        for (int i = 0; i < numServiceConfigurations; ++i) {
            in.read_long();
            in.read_octet_sequence();
        }
    }

    public final void write(CorbaOutputStream out) {
        out.write_short(this.supports);
        out.write_short(this.requires);
        out.write_long(0);
        if (this.supports != 0) {
            out.write_long(this.oidSequences.size());
            for (byte[] oidSequence : this.oidSequences) {
                out.write_octet_sequence(oidSequence);
            }
            out.write_long(this.supportedIdentityTypes);
        } else {
            out.write_long(0);
            out.write_long(0);
        }
    }

    public short getSupports() {
        return this.supports;
    }

    public short getRequires() {
        return this.requires;
    }

    public final boolean hasGSSUPIdentity() {
        if ((this.supports & 0x400) == 0) {
            return false;
        }
        if ((this.supportedIdentityTypes & 0xF) == 0) {
            return false;
        }
        for (byte[] oidSequence : this.oidSequences) {
            if (!GSSUtil.isGSSUPMech(oidSequence)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "SASContextSec (supports = " + this.supports + ",requires = " + this.requires + ")";
    }

    public int getSupportedIdentityTypes() {
        return this.supportedIdentityTypes;
    }
}

