/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.apache.commons.logging.impl;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class SimpleLog
implements Log,
Serializable {
    protected static final String systemPrefix = "com.bea.core.repackaged.apache.commons.logging.simplelog.";
    protected static final Properties simpleLogProps;
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static boolean showLogName;
    protected static boolean showShortName;
    protected static boolean showDateTime;
    protected static String dateTimeFormat;
    protected static DateFormat dateFormatter;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected String logName = null;
    protected int currentLogLevel;
    private String shortLogName = null;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$commons$logging$impl$SimpleLog;

    static {
        block5: {
            simpleLogProps = new Properties();
            showLogName = false;
            showShortName = true;
            showDateTime = false;
            dateTimeFormat = DEFAULT_DATE_TIME_FORMAT;
            dateFormatter = null;
            InputStream in = SimpleLog.getResourceAsStream("simplelog.properties");
            if (in != null) {
                try {
                    simpleLogProps.load(in);
                    in.close();
                }
                catch (IOException iOException) {}
            }
            showLogName = SimpleLog.getBooleanProperty("com.bea.core.repackaged.apache.commons.logging.simplelog.showlogname", showLogName);
            showShortName = SimpleLog.getBooleanProperty("com.bea.core.repackaged.apache.commons.logging.simplelog.showShortLogname", showShortName);
            if (!(showDateTime = SimpleLog.getBooleanProperty("com.bea.core.repackaged.apache.commons.logging.simplelog.showdatetime", showDateTime))) break block5;
            dateTimeFormat = SimpleLog.getStringProperty("com.bea.core.repackaged.apache.commons.logging.simplelog.dateTimeFormat", dateTimeFormat);
            try {
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                dateTimeFormat = DEFAULT_DATE_TIME_FORMAT;
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
        }
    }

    public SimpleLog(String name) {
        this.logName = name;
        this.setLevel(3);
        String lvl = SimpleLog.getStringProperty("com.bea.core.repackaged.apache.commons.logging.simplelog.log." + this.logName);
        int i = String.valueOf(name).lastIndexOf(".");
        while (lvl == null && i > -1) {
            name = name.substring(0, i);
            lvl = SimpleLog.getStringProperty("com.bea.core.repackaged.apache.commons.logging.simplelog.log." + name);
            i = String.valueOf(name).lastIndexOf(".");
        }
        if (lvl == null) {
            lvl = SimpleLog.getStringProperty("com.bea.core.repackaged.apache.commons.logging.simplelog.defaultlog");
        }
        if ("all".equalsIgnoreCase(lvl)) {
            this.setLevel(0);
        } else if ("trace".equalsIgnoreCase(lvl)) {
            this.setLevel(1);
        } else if ("debug".equalsIgnoreCase(lvl)) {
            this.setLevel(2);
        } else if ("info".equalsIgnoreCase(lvl)) {
            this.setLevel(3);
        } else if ("warn".equalsIgnoreCase(lvl)) {
            this.setLevel(4);
        } else if ("error".equalsIgnoreCase(lvl)) {
            this.setLevel(5);
        } else if ("fatal".equalsIgnoreCase(lvl)) {
            this.setLevel(6);
        } else if ("off".equalsIgnoreCase(lvl)) {
            this.setLevel(7);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public final void debug(Object message) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, null);
        }
    }

    public final void debug(Object message, Throwable t) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, t);
        }
    }

    public final void error(Object message) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, null);
        }
    }

    public final void error(Object message, Throwable t) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, t);
        }
    }

    public final void fatal(Object message) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, null);
        }
    }

    public final void fatal(Object message, Throwable t) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, t);
        }
    }

    private static boolean getBooleanProperty(String name, boolean dephault) {
        String prop = SimpleLog.getStringProperty(name);
        return prop == null ? dephault : "true".equalsIgnoreCase(prop);
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        if (classLoader == null) {
            try {
                Method method = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = SimpleLog.class$("java.lang.Thread"))).getMethod("getContextClassLoader", null);
                try {
                    classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException e) {
                    if (!(e.getTargetException() instanceof SecurityException)) {
                        throw new LogConfigurationException("Unexpected InvocationTargetException", e.getTargetException());
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (classLoader == null) {
            classLoader = (class$org$apache$commons$logging$impl$SimpleLog != null ? class$org$apache$commons$logging$impl$SimpleLog : (class$org$apache$commons$logging$impl$SimpleLog = SimpleLog.class$("com.bea.core.repackaged.apache.commons.logging.impl.SimpleLog"))).getClassLoader();
        }
        return classLoader;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    private static InputStream getResourceAsStream(final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader threadCL = SimpleLog.getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
    }

    private static String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {}
        return prop == null ? simpleLogProps.getProperty(name) : prop;
    }

    private static String getStringProperty(String name, String dephault) {
        String prop = SimpleLog.getStringProperty(name);
        return prop == null ? dephault : prop;
    }

    public final void info(Object message) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, null);
        }
    }

    public final void info(Object message, Throwable t) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, t);
        }
    }

    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    protected void log(int type, Object message, Throwable t) {
        StringBuffer buf = new StringBuffer();
        if (showDateTime) {
            buf.append(dateFormatter.format(new Date()));
            buf.append(" ");
        }
        switch (type) {
            case 1: {
                buf.append("[TRACE] ");
                break;
            }
            case 2: {
                buf.append("[DEBUG] ");
                break;
            }
            case 3: {
                buf.append("[INFO] ");
                break;
            }
            case 4: {
                buf.append("[WARN] ");
                break;
            }
            case 5: {
                buf.append("[ERROR] ");
                break;
            }
            case 6: {
                buf.append("[FATAL] ");
                break;
            }
        }
        if (showShortName) {
            if (this.shortLogName == null) {
                this.shortLogName = this.logName.substring(this.logName.lastIndexOf(".") + 1);
                this.shortLogName = this.shortLogName.substring(this.shortLogName.lastIndexOf("/") + 1);
            }
            buf.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (showLogName) {
            buf.append(String.valueOf(this.logName)).append(" - ");
        }
        buf.append(String.valueOf(message));
        if (t != null) {
            buf.append(" <");
            buf.append(t.toString());
            buf.append(">");
            StringWriter sw = new StringWriter(1024);
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            buf.append(sw.toString());
        }
        this.write(buf);
    }

    public void setLevel(int currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    public final void trace(Object message) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, null);
        }
    }

    public final void trace(Object message, Throwable t) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, t);
        }
    }

    public final void warn(Object message) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, null);
        }
    }

    public final void warn(Object message, Throwable t) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, t);
        }
    }

    protected void write(StringBuffer buffer) {
        System.err.println(buffer.toString());
    }
}

