/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated;

import com.tangosol.net.cache.CacheLoader;
import com.tangosol.util.Base;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceCacheHelper;
import oracle.eclipselink.coherence.integrated.querying.DeleteObjectThroughCoherence;
import oracle.eclipselink.coherence.integrated.querying.InsertObjectToCoherence;
import oracle.eclipselink.coherence.integrated.querying.UpdateObjectToCoherence;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.queries.QueryRedirector;

public class EclipseLinkJPACacheLoader
extends Base
implements CacheLoader {
    protected EntityManagerFactory emf;
    protected ClassDescriptor descriptor;
    protected boolean shouldTranslatePKs = true;

    public EclipseLinkJPACacheLoader(String cacheName, String puName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.session-name", "EclipseLinkCacheLoader-" + puName);
        this.emf = Persistence.createEntityManagerFactory((String)puName, properties);
        DatabaseSessionImpl session = JpaHelper.getEntityManagerFactory((EntityManagerFactory)this.emf).getDatabaseSession();
        session.setExternalTransactionController(null);
        Object property = session.getProperty("eclipselink.coherence.use-native-toplink-pk-classes");
        if (property != null && property instanceof String && ((String)property).toLowerCase().equals("true")) {
            this.shouldTranslatePKs = false;
        }
        for (ClassDescriptor desc : session.getDescriptors().values()) {
            if (cacheName.equals(CoherenceCacheHelper.getCacheName(desc))) {
                this.descriptor = desc;
            }
            if (desc.getProperty("coherence.descriptor.initialized") != null) continue;
            desc.setProperty("coherence.descriptor.initialized", (Object)Boolean.TRUE);
            desc.setDefaultReadAllQueryRedirector(null);
            desc.setDefaultReadObjectQueryRedirector(null);
            desc.setDefaultReportQueryRedirector(null);
            if (desc.getDefaultInsertObjectQueryRedirector() != null) {
                desc.setDefaultInsertObjectQueryRedirector(null);
                desc.setDefaultDeleteObjectQueryRedirector(null);
                desc.setDefaultUpdateObjectQueryRedirector(null);
            } else {
                desc.setDefaultInsertObjectQueryRedirector((QueryRedirector)new InsertObjectToCoherence());
                desc.setDefaultDeleteObjectQueryRedirector((QueryRedirector)new DeleteObjectThroughCoherence());
                desc.setDefaultUpdateObjectQueryRedirector((QueryRedirector)new UpdateObjectToCoherence());
            }
            desc.setIsIsolated(true);
            session.getProject().setHasIsolatedClasses(true);
            desc.setCacheInterceptorClass(null);
            if (!(desc.isChildDescriptor() || desc.isAggregateCollectionDescriptor() || desc.isAggregateDescriptor())) {
                session.getIdentityMapAccessor().initializeIdentityMap(desc.getJavaClass());
            }
            desc.setOptimisticLockingPolicy(null);
            desc.setSequenceNumberName(null);
            desc.setSequenceNumberField(null);
            CoherenceCacheHelper.defineWrapperClass(desc, session.getPlatform().getConversionManager().getLoader());
        }
    }

    protected EntityManagerFactory getEMF() {
        return this.emf;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Object id) {
        try (EntityManager em = this.getEMF().createEntityManager();){
            Object object = this.load(id, em);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map loadAll(Collection ids) {
        try (EntityManager em = this.getEMF().createEntityManager();){
            HashMap map = new HashMap(ids.size());
            for (Object key : ids) {
                Object result = this.load(key, em);
                if (result == null) continue;
                map.put(key, result);
            }
            HashMap hashMap = map;
            return hashMap;
        }
    }

    protected Object load(Object id, EntityManager em) {
        Object result = em.find(this.getDescriptor().getJavaClass(), id);
        if (result != null) {
            result = CoherenceCacheHelper.decomposeAndWrapEntity(result, this.getDescriptor(), (AbstractSession)((EntityManagerImpl)em).getActivePersistenceContext(null), this.shouldTranslatePKs, false);
        }
        return result;
    }
}

