/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated;

import com.tangosol.net.cache.CacheLoader;
import com.tangosol.util.Base;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceCacheHelper;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.factories.SessionManager;

public class EclipseLinkNativeCacheLoader
extends Base
implements CacheLoader {
    protected Session session;
    protected ClassDescriptor descriptor;
    protected ReadObjectQuery roq;
    protected static SessionManager localManager = new SessionManager();

    public EclipseLinkNativeCacheLoader(String cacheName, String sessionName) {
        this.session = localManager.getSession(sessionName, true);
        this.session.setExternalTransactionController(null);
        for (ClassDescriptor desc : this.session.getDescriptors().values()) {
            if (cacheName.equals(CoherenceCacheHelper.getCacheName(desc))) {
                this.descriptor = desc;
                this.roq = this.descriptor.getQueryManager().getReadObjectQuery();
            }
            if (desc.getProperty("coherence.descriptor.initialized") != null) continue;
            desc.setProperty("coherence.descriptor.initialized", (Object)Boolean.TRUE);
            desc.setDefaultReadAllQueryRedirector(null);
            desc.setDefaultReadObjectQueryRedirector(null);
            desc.setDefaultReportQueryRedirector(null);
            if (desc.getDefaultInsertObjectQueryRedirector() != null) {
                desc.setDefaultInsertObjectQueryRedirector(null);
                desc.setDefaultDeleteObjectQueryRedirector(null);
                desc.setDefaultUpdateObjectQueryRedirector(null);
            }
            desc.setIsIsolated(true);
            this.session.getProject().setHasIsolatedClasses(true);
            desc.setCacheInterceptorClass(null);
            if (!(desc.isChildDescriptor() || desc.isAggregateCollectionDescriptor() || desc.isAggregateDescriptor())) {
                this.session.getIdentityMapAccessor().initializeIdentityMap(desc.getJavaClass());
            }
            desc.setOptimisticLockingPolicy(null);
            desc.setSequenceNumberName(null);
            desc.setSequenceNumberField(null);
            desc.getQueryManager().checkDatabaseForDoesExist();
            CoherenceCacheHelper.defineWrapperClass(desc, this.session.getPlatform().getConversionManager().getLoader());
        }
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Object id) {
        UnitOfWork localSession = this.session.acquireUnitOfWork();
        try {
            Object object = this.load(id, localSession);
            return object;
        }
        finally {
            localSession.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map loadAll(Collection ids) {
        UnitOfWork uow = this.session.acquireUnitOfWork();
        try {
            HashMap map = new HashMap(ids.size());
            for (Object key : ids) {
                Object result = this.load(key, uow);
                if (result == null) continue;
                map.put(key, uow);
            }
            HashMap hashMap = map;
            return hashMap;
        }
        finally {
            uow.release();
        }
    }

    protected Object load(Object id, UnitOfWork uow) {
        ReadObjectQuery localQuery = (ReadObjectQuery)this.roq.clone();
        localQuery.setIsExecutionClone(true);
        if (this.descriptor.getCacheKeyType() == CacheKeyType.ID_VALUE) {
            localQuery.setSelectionId(id);
        } else {
            localQuery.setSelectionId((Object)new CacheId((Object[])id));
        }
        Object result = uow.executeQuery((DatabaseQuery)localQuery);
        if (result != null) {
            result = CoherenceCacheHelper.decomposeAndWrapEntity(result, this.getDescriptor(), (AbstractSession)uow, false, true);
        }
        return result;
    }
}

