/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated;

import com.tangosol.net.cache.CacheStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.eclipselink.coherence.integrated.EclipseLinkNativeCacheLoader;
import oracle.eclipselink.coherence.integrated.cache.Wrapper;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceCacheHelper;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.server.Server;

public class EclipseLinkNativeCacheStore
extends EclipseLinkNativeCacheLoader
implements CacheStore {
    protected DeleteAllQuery daq;

    public EclipseLinkNativeCacheStore(String cacheName, String sessionName) {
        super(cacheName, sessionName);
        this.daq = new DeleteAllQuery(this.descriptor.getJavaClass());
        this.daq.setSelectionCriteria(this.descriptor.getDescriptorQueryManager().getReadObjectQuery().getSelectionCriteria());
        this.daq.setIsExecutionClone(true);
        for (DatabaseField field : this.descriptor.getPrimaryKeyFields()) {
            this.daq.addArgument(field.getQualifiedName());
        }
    }

    public void erase(Object id) {
        UnitOfWork uow = this.session.acquireUnitOfWork();
        List<Object> arguments = null;
        if (this.descriptor.getCacheKeyType().equals((Object)CacheKeyType.CACHE_ID)) {
            arguments = Arrays.asList(((CacheId)id).getPrimaryKey());
        } else {
            arguments = new ArrayList();
            arguments.add(id);
        }
        uow.executeQuery((DatabaseQuery)this.daq, arguments);
        uow.commit();
    }

    public void eraseAll(Collection ids) {
        for (Object id : ids) {
            this.erase(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Object id, Object entity) {
        UnitOfWork uow = this.acquireUnitOfWork(this.session);
        try {
            this.store(id, entity, uow);
        }
        finally {
            uow.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAll(Map entities) {
        UnitOfWork uow = this.acquireUnitOfWork(this.session);
        try {
            for (Map.Entry entry : entities.entrySet()) {
                this.store(entry.getKey(), entry.getValue(), uow);
            }
            uow.commit();
        }
        finally {
            uow.release();
        }
    }

    protected void store(Object id, Object entity, UnitOfWork uow) {
        if (entity instanceof Wrapper) {
            entity = CoherenceCacheHelper.composeEntity(id, entity, null, this.descriptor, null, null, null, (AbstractSession)uow, true, false);
            uow.mergeCloneWithReferences(entity);
        } else {
            uow.mergeClone(entity);
        }
    }

    protected UnitOfWork acquireUnitOfWork(Session session) {
        if (session.isServerSession()) {
            session = ((Server)session).acquireClientSession();
        } else if (session.isSessionBroker() && ((SessionBroker)session).isServerSessionBroker()) {
            session = ((SessionBroker)session).acquireClientSessionBroker();
        }
        RepeatableWriteUnitOfWork uow = new RepeatableWriteUnitOfWork((AbstractSession)session, ReferenceMode.HARD);
        uow.setResumeUnitOfWorkOnTransactionCompletion(true);
        uow.setShouldDiscoverNewObjects(true);
        uow.setDiscoverUnregisteredNewObjectsWithoutPersist(false);
        uow.setFlushClearCache("DropInvalidate");
        uow.setShouldValidateExistence(false);
        uow.setShouldOrderUpdates(false);
        uow.setShouldCascadeCloneToJoinedRelationship(true);
        uow.setShouldStoreByPassCache(false);
        return uow;
    }
}

