/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.cache;

import com.tangosol.net.NamedCache;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.eclipselink.coherence.exceptions.IntegrationException;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceCacheHelper;
import oracle.eclipselink.coherence.integrated.querying.ReadAllFromCoherence;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.indirection.CacheBasedValueHolder;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.interceptors.CacheInterceptor;
import org.eclipse.persistence.sessions.interceptors.CacheKeyInterceptor;

public class CoherenceInterceptor
extends CacheInterceptor {
    protected NamedCache namedCache;
    protected ClassDescriptor descriptor;
    protected OptimisticLockingPolicy lockingPolicy;
    protected boolean shouldTranslatePKs = true;
    protected static final ThreadLocal<ConcurrentHashMap<Class<?>, ConcurrentHashMap<Object, CacheKey>>> lockedIdentityMap = new ThreadLocal();
    protected boolean isComponent = false;
    protected boolean triggerFetchGroups = false;
    protected static final ThreadLocal<DeferredLockedCacheKeys> deferredLockedCacheKeys = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoherenceInterceptor(IdentityMap targetIdentityMap, AbstractSession interceptedSession) {
        super(targetIdentityMap, interceptedSession);
        Object property;
        if (targetIdentityMap.getDescriptor() != null) {
            this.descriptor = targetIdentityMap.getDescriptor();
            AbstractSession abstractSession = interceptedSession;
            synchronized (abstractSession) {
                if (this.descriptor.getProperty("toplink-grid.descriptor.processed") == null) {
                    Object property2 = interceptedSession.getProperty("eclipselink.coherence.shared-components");
                    boolean allowSharedComponents = false;
                    if (property2 != null && (property2.equals(true) || property2 instanceof String && "true".equalsIgnoreCase((String)property2))) {
                        allowSharedComponents = true;
                    }
                    for (ClassDescriptor descriptor : interceptedSession.getDescriptors().values()) {
                        this.trackComponents(descriptor, descriptor, interceptedSession, allowSharedComponents);
                    }
                }
            }
            if (this.descriptor.getProperty("toplink-grid.descriptor.component-node") != null) {
                this.isComponent = true;
                return;
            }
            this.lockingPolicy = this.descriptor.getOptimisticLockingPolicy();
            if (this.lockingPolicy != null && (this.lockingPolicy.isStoredInCache() || !(this.lockingPolicy instanceof VersionLockingPolicy))) {
                throw IntegrationException.optimisticLockingPolicyNotSupported(this.descriptor.getJavaClassName());
            }
            try {
                this.namedCache = CoherenceCacheHelper.getNamedCache(this.descriptor, (Session)interceptedSession);
                if (this.namedCache == null) {
                    throw IntegrationException.unableToFindCoherenceCache(CoherenceCacheHelper.getCacheName(this.descriptor), null);
                }
            }
            catch (Exception ex) {
                throw IntegrationException.unableToFindCoherenceCache(CoherenceCacheHelper.getCacheName(this.descriptor), ex);
            }
        }
        if ((property = interceptedSession.getProperty("eclipselink.coherence.use-native-toplink-pk-classes")) != null && property instanceof String && ((String)property).toLowerCase().equals("true")) {
            this.shouldTranslatePKs = false;
        }
        if (this.descriptor.getDefaultReadAllQueryRedirector() != null && this.descriptor.getDefaultReadAllQueryRedirector() instanceof ReadAllFromCoherence) {
            this.triggerFetchGroups = true;
            property = interceptedSession.getProperty("eclipselink.coherence.allow-fetchgroups-for-grid-read");
            if (property != null) {
                if (property instanceof String && ((String)property).toLowerCase().equals("true")) {
                    this.triggerFetchGroups = false;
                }
            } else {
                property = this.descriptor.getProperty("eclipselink.coherence.allow-fetchgroups-for-grid-read");
                if (property != null && property instanceof String && ((String)property).toLowerCase().equals("true")) {
                    this.triggerFetchGroups = false;
                }
            }
        }
    }

    protected CacheKeyInterceptor createCacheKeyInterceptor(CacheKey wrappedCacheKey) {
        return new CoherenceOnlyCacheKeyWrapper(wrappedCacheKey);
    }

    public Object clone() {
        return new CoherenceInterceptor((IdentityMap)this.targetIdentityMap.clone(), this.interceptedSession);
    }

    public void trackComponents(ClassDescriptor sourceDesc, ClassDescriptor root, AbstractSession session, boolean allowSharedComponents) {
        AttributeGroup ag = sourceDesc.getAttributeGroup(sourceDesc.getAlias());
        Object property = sourceDesc.getProperty("toplink-grid.descriptor.processed");
        if (property == null) {
            sourceDesc.setProperty("toplink-grid.descriptor.processed", (Object)true);
            if (ag != null) {
                for (AttributeItem item : ag.getItems().values()) {
                    Map groups;
                    DatabaseMapping mapping = sourceDesc.getMappingForAttributeName(item.getAttributeName());
                    if (mapping.isForeignReferenceMapping()) {
                        MappedKeyMapContainerPolicy mkmcp;
                        ClassDescriptor referenceDescriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor();
                        Class clazz = (Class)referenceDescriptor.getProperty("toplink-grid.descriptor.component-node");
                        if (clazz != null & clazz != root.getJavaClass() && !allowSharedComponents) {
                            throw IntegrationException.componentEntityCanBeMemberOfOnlyOneGraph(sourceDesc.getJavaClassName(), referenceDescriptor.getJavaClassName(), clazz.getName());
                        }
                        referenceDescriptor.setProperty("toplink-grid.descriptor.component-node", (Object)root.getJavaClass());
                        ArrayList<AttributeAccessor> list = referenceDescriptor.getAccessorTree();
                        if (list != null) {
                            list.add(mapping.getAttributeAccessor());
                        } else {
                            list = new ArrayList<AttributeAccessor>();
                            list.add(mapping.getAttributeAccessor());
                            referenceDescriptor.setAccessorTree(list);
                        }
                        if (mapping.isCollectionMapping() && ((CollectionMapping)mapping).getContainerPolicy().isMappedKeyMapPolicy() && !(mkmcp = (MappedKeyMapContainerPolicy)((CollectionMapping)mapping).getContainerPolicy()).isMapKeyAttribute()) {
                            referenceDescriptor = mkmcp.getKeyMapping().getReferenceDescriptor();
                            clazz = (Class)referenceDescriptor.getProperty("toplink-grid.descriptor.component-node");
                            if (clazz != null & clazz != root.getJavaClass() && !allowSharedComponents) {
                                throw IntegrationException.componentEntityCanBeMemberOfOnlyOneGraph(sourceDesc.getJavaClassName(), referenceDescriptor.getJavaClassName(), clazz.getName());
                            }
                            referenceDescriptor.setProperty("toplink-grid.descriptor.component-node", (Object)root.getJavaClass());
                            throw new IllegalArgumentException("Map key Entities and Embeddables not yet supported.");
                        }
                    }
                    if ((groups = item.getGroups()) != null) {
                        for (Map.Entry group : groups.entrySet()) {
                            if (group.getKey() == ClassConstants.Object_Class) {
                                this.trackComponents(mapping.getReferenceDescriptor(), root, session, allowSharedComponents);
                                continue;
                            }
                            this.trackComponents(session.getDescriptor(group.getKey()), root, session, allowSharedComponents);
                        }
                    }
                    if ((groups = item.getKeyGroups()) == null) continue;
                    for (Map.Entry group : groups.entrySet()) {
                        if (group.getKey() == ClassConstants.Object_Class) {
                            this.trackComponents(mapping.getReferenceDescriptor(), root, session, allowSharedComponents);
                            continue;
                        }
                        this.trackComponents(session.getDescriptor(group.getKey()), root, session, allowSharedComponents);
                    }
                }
            }
        } else if (ag != null) {
            throw IntegrationException.onlyOneRootIsAllowedInEntityGraph(root.getJavaClassName(), sourceDesc.getJavaClassName());
        }
    }

    public CacheKey acquireDeferredLock(Object primaryKey, boolean isCacheCheckComplete) {
        CacheKey tempKey = this.checkLockedObjects(primaryKey);
        if (tempKey == null) {
            tempKey = new CacheKey(primaryKey, null, null, System.currentTimeMillis(), false);
            if (!this.isComponent) {
                tempKey = this.createCacheKeyInterceptor(tempKey);
            }
            this.storeLockedCacheKey(tempKey, true);
        }
        tempKey.getWrappedCacheKey().acquire();
        try {
            ((CoherenceOnlyCacheKeyWrapper)tempKey).setAcquiredForRead(true);
            if (!this.isComponent && tempKey.getObject() == null && !isCacheCheckComplete) {
                ((CoherenceOnlyCacheKeyWrapper)tempKey).internalSetObject(CoherenceCacheHelper.getFromCoherence(this.descriptor, this.interceptedSession, this.namedCache, primaryKey, tempKey, this.shouldTranslatePKs));
            }
            return tempKey;
        }
        catch (RuntimeException ex) {
            tempKey.releaseDeferredLock();
            throw ex;
        }
        catch (Error ex) {
            tempKey.releaseDeferredLock();
            throw ex;
        }
    }

    public CacheKey acquireLock(Object primaryKey, boolean forMerge, boolean isCacheCheckComplete) {
        CacheKey tempKey = this.checkLockedObjects(primaryKey);
        if (tempKey == null) {
            tempKey = new CacheKey(primaryKey, null, null, System.currentTimeMillis(), false);
            if (!this.isComponent) {
                tempKey = this.createCacheKeyInterceptor(tempKey);
            }
            this.storeLockedCacheKey(tempKey, false);
        }
        tempKey.getWrappedCacheKey().acquire();
        try {
            ((CoherenceOnlyCacheKeyWrapper)tempKey).setAcquiredForRead(!forMerge);
            if (!this.isComponent && tempKey.getObject() == null && !isCacheCheckComplete) {
                ((CoherenceOnlyCacheKeyWrapper)tempKey).internalSetObject(CoherenceCacheHelper.getFromCoherence(this.descriptor, this.interceptedSession, this.namedCache, primaryKey, tempKey, this.shouldTranslatePKs));
            }
            return tempKey;
        }
        catch (RuntimeException ex) {
            tempKey.release();
            throw ex;
        }
        catch (Error ex) {
            tempKey.releaseDeferredLock();
            throw ex;
        }
    }

    public CacheKey acquireLockNoWait(Object primaryKey, boolean forMerge) {
        CacheKey tempKey = this.checkLockedObjects(primaryKey);
        if (tempKey == null) {
            if (forMerge) {
                tempKey = new CacheKey(primaryKey, null, null, System.currentTimeMillis(), false);
                if (!this.isComponent) {
                    tempKey = this.createCacheKeyInterceptor(tempKey);
                }
                this.storeLockedCacheKey(tempKey, false);
            } else {
                tempKey = new CacheKey(primaryKey, null, null, System.currentTimeMillis(), false);
            }
        }
        tempKey.getWrappedCacheKey().acquire();
        return tempKey;
    }

    public CacheKey acquireLockWithWait(Object primaryKey, boolean forMerge, int wait) {
        CacheKey tempKey = this.checkLockedObjects(primaryKey);
        if (tempKey == null) {
            if (forMerge) {
                tempKey = new CacheKey(primaryKey, null, null, System.currentTimeMillis(), false);
                if (!this.isComponent) {
                    tempKey = this.createCacheKeyInterceptor(tempKey);
                }
                this.storeLockedCacheKey(tempKey, false);
            } else {
                tempKey = new CacheKey(primaryKey, null, null, System.currentTimeMillis(), false);
            }
        }
        tempKey.getWrappedCacheKey().acquire();
        return tempKey;
    }

    public Map<Object, Object> getAllFromIdentityMapWithEntityPK(Object[] pkList, ClassDescriptor descriptor, AbstractSession session) {
        if (this.isComponent) {
            return null;
        }
        return CoherenceCacheHelper.getAllFromCoherenceWithCohKey(pkList, descriptor, this.interceptedSession, (IdentityMap)this, this.namedCache, this.shouldTranslatePKs);
    }

    public Map<Object, CacheKey> getAllCacheKeysFromIdentityMapWithEntityPK(Object[] pkList, ClassDescriptor descriptor, AbstractSession session) {
        if (this.isComponent) {
            return null;
        }
        Map<Object, CacheKey> result = CoherenceCacheHelper.getAllCacheKeysFromCoherenceWithCohKey(pkList, descriptor, this.interceptedSession, (IdentityMap)this, this.namedCache, this.shouldTranslatePKs);
        for (Map.Entry<Object, CacheKey> entry : result.entrySet()) {
            entry.setValue((CacheKey)this.createCacheKeyInterceptor(entry.getValue()));
        }
        return result;
    }

    public CacheKey getCacheKey(Object searchKey, boolean forMerge) {
        CacheKey tempKey = this.checkLockedObjects(searchKey);
        if (tempKey != null) {
            return tempKey;
        }
        if (!forMerge) {
            if (this.isComponent) {
                return null;
            }
            tempKey = new CacheKey(searchKey, null, null, System.currentTimeMillis(), false);
            tempKey.setOwningMap((IdentityMap)this);
            Object cachedObject = CoherenceCacheHelper.getFromCoherence(this.descriptor, this.interceptedSession, this.namedCache, searchKey, tempKey, this.shouldTranslatePKs);
            if (cachedObject != null) {
                tempKey.setObject(cachedObject);
                if (cachedObject instanceof PersistenceEntity) {
                    tempKey.setOwningMap((IdentityMap)this);
                    ((PersistenceEntity)cachedObject)._persistence_setCacheKey(tempKey);
                }
                return this.createCacheKeyInterceptor(tempKey);
            }
            return null;
        }
        if (this.isComponent) {
            return new CacheKey(searchKey, null, null, System.currentTimeMillis(), false);
        }
        return (CoherenceOnlyCacheKeyWrapper)this.createCacheKeyInterceptor(new CacheKey(searchKey, null, null, System.currentTimeMillis(), false));
    }

    public CacheKey getCacheKeyForLock(Object searchKey) {
        CacheKey tempKey = this.checkLockedObjects(searchKey);
        if (tempKey == null) {
            tempKey = new CacheKey(searchKey, null, null, System.currentTimeMillis(), false);
        }
        return tempKey;
    }

    public NamedCache getNamedCache() {
        return this.namedCache;
    }

    public void lazyRelationshipLoaded(Object rootEntity, ValueHolderInterface valueHolder, ForeignReferenceMapping mapping) {
        ClassDescriptor descriptor = this.interceptedSession.getDescriptor(rootEntity);
        if (mapping.isOneToOneMapping() && ((OneToOneMapping)mapping).isForeignKeyRelationship()) {
            return;
        }
        if (mapping.getDescriptor().isAggregateCollectionDescriptor()) {
            throw IntegrationException.relationshipFromElementCollectionEmbeddablesNotSupported();
        }
        if (!(valueHolder instanceof CacheBasedValueHolder)) {
            Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(rootEntity, this.interceptedSession);
            AttributeAccessor[] accessorArray = null;
            if (mapping.getDescriptor().getAccessorTree() == null) {
                accessorArray = new AttributeAccessor[]{mapping.getAttributeAccessor()};
            } else {
                accessorArray = new AttributeAccessor[mapping.getDescriptor().getAccessorTree().size() + 1];
                mapping.getDescriptor().getAccessorTree().toArray(accessorArray);
                accessorArray[mapping.getDescriptor().getAccessorTree().size()] = mapping.getAttributeAccessor();
            }
            CoherenceCacheHelper.updateRelationship(descriptor, this.interceptedSession, this.namedCache, primaryKey, valueHolder.getValue(), rootEntity, mapping, accessorArray, this.shouldTranslatePKs);
        }
    }

    public CacheKey put(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        if (this.isComponent) {
            return null;
        }
        CoherenceCacheHelper.putIntoCoherence(this.descriptor, this.interceptedSession, this.namedCache, primaryKey, object, null, false, this.shouldTranslatePKs, this.triggerFetchGroups);
        return new CacheKey(primaryKey, object, writeLockValue, readTime, false);
    }

    public void release() {
        this.namedCache.release();
    }

    public Object remove(Object primaryKey, Object object) {
        if (object != null && !this.isComponent) {
            CoherenceCacheHelper.removeFromCoherence(this.descriptor, this.interceptedSession, this.namedCache, primaryKey, object, this.shouldTranslatePKs);
            return object;
        }
        return null;
    }

    public Object remove(CacheKey cacheKey) {
        CacheKey key = cacheKey;
        if (cacheKey.isWrapper()) {
            key = cacheKey.getWrappedCacheKey();
        }
        if (!this.isComponent && key.getObject() != null) {
            CoherenceCacheHelper.removeFromCoherence(this.descriptor, this.interceptedSession, this.namedCache, key.getKey(), key.getObject(), this.shouldTranslatePKs);
            return key.getObject();
        }
        return null;
    }

    public CacheKey acquireReadLockOnCacheKey(Object primaryKey) {
        CacheKey newCacheKey = new CacheKey(primaryKey, null, (Object)0, 0L, false);
        newCacheKey.acquireReadLock();
        return newCacheKey;
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Object primaryKey) {
        CacheKey newCacheKey = new CacheKey(primaryKey, null, (Object)0, 0L, false);
        newCacheKey.acquireReadLock();
        return newCacheKey;
    }

    public boolean containsKey(Object primaryKey) {
        return false;
    }

    public Enumeration elements() {
        return null;
    }

    public Object get(Object primaryKey) {
        return null;
    }

    public int getMaxSize() {
        return -1;
    }

    public int getSize() {
        return -1;
    }

    public int getSize(Class myClass, boolean recurse) {
        return -1;
    }

    public Object getWrapper(Object primaryKey) {
        return null;
    }

    public Object getWriteLockValue(Object primaryKey) {
        return -1;
    }

    public void updateMaxSize(int maxSize) {
    }

    public void setDescriptor(ClassDescriptor descriptor) {
    }

    public void setWrapper(Object primaryKey, Object wrapper) {
    }

    public void setWriteLockValue(Object primaryKey, Object writeLockValue) {
    }

    public String toString() {
        return " Coherence Cache Interceptor ";
    }

    protected CacheKey checkLockedObjects(Object pk) {
        ConcurrentHashMap<Object, CacheKey> classMap;
        ConcurrentHashMap<Class<?>, ConcurrentHashMap<Object, CacheKey>> localLockedKeys = lockedIdentityMap.get();
        if (localLockedKeys != null && (classMap = localLockedKeys.get(this.descriptor.getJavaClass())) != null) {
            return classMap.get(pk);
        }
        return null;
    }

    protected void storeLockedCacheKey(CacheKey cacheKey, boolean isDeferredLock) {
        ConcurrentHashMap<Class<Object>, ConcurrentHashMap<Object, Object>> localLockedKeys = lockedIdentityMap.get();
        ConcurrentHashMap<Object, Object> classMap = null;
        if (localLockedKeys == null) {
            localLockedKeys = new ConcurrentHashMap();
            lockedIdentityMap.set(localLockedKeys);
        } else {
            classMap = localLockedKeys.get(this.descriptor.getJavaClass());
        }
        if (classMap == null) {
            classMap = new ConcurrentHashMap();
            localLockedKeys.put(this.descriptor.getJavaClass(), classMap);
        }
        classMap.put(cacheKey.getKey(), cacheKey);
        if (isDeferredLock) {
            DeferredLockedCacheKeys localDeferredLockedCacheKeys = deferredLockedCacheKeys.get();
            if (localDeferredLockedCacheKeys == null) {
                localDeferredLockedCacheKeys = new DeferredLockedCacheKeys();
                deferredLockedCacheKeys.set(localDeferredLockedCacheKeys);
            }
            localDeferredLockedCacheKeys.acquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLockedCacheKey(CacheKey cacheKey, boolean isDeferredLock) {
        if (!cacheKey.isAcquired()) {
            DeferredLockedCacheKeys localDeferredLockedCacheKeys;
            ConcurrentHashMap<Object, CacheKey> classMap;
            ConcurrentHashMap<Class<?>, ConcurrentHashMap<Object, CacheKey>> localLockedKeys = lockedIdentityMap.get();
            if (localLockedKeys != null && (classMap = localLockedKeys.get(this.descriptor.getJavaClass())) != null) {
                classMap.remove(cacheKey.getKey());
                if (classMap.isEmpty()) {
                    localLockedKeys.remove(this.descriptor.getJavaClass());
                    if (localLockedKeys.isEmpty()) {
                        lockedIdentityMap.remove();
                    }
                }
            }
            if (isDeferredLock && (localDeferredLockedCacheKeys = deferredLockedCacheKeys.get()) != null) {
                try {
                    localDeferredLockedCacheKeys.release((CoherenceOnlyCacheKeyWrapper)cacheKey);
                }
                finally {
                    if (localDeferredLockedCacheKeys.isEmpty()) {
                        deferredLockedCacheKeys.remove();
                    }
                }
            }
        }
    }

    public boolean shouldTriggerFetchGroups() {
        return this.triggerFetchGroups;
    }

    public void setTriggerFetchGroups(boolean triggerFetchGroups) {
        this.triggerFetchGroups = triggerFetchGroups;
    }

    public class CoherenceOnlyCacheKeyWrapper
    extends CacheKeyInterceptor {
        protected boolean updated;
        protected boolean acquiredForRead;

        public CoherenceOnlyCacheKeyWrapper(CacheKey cacheKey) {
            super(cacheKey);
            this.updated = false;
            this.acquiredForRead = false;
        }

        public Object clone() {
            CoherenceOnlyCacheKeyWrapper wrapper = new CoherenceOnlyCacheKeyWrapper((CacheKey)this.wrappedKey.clone());
            wrapper.acquiredForRead = this.acquiredForRead;
            wrapper.updated = this.updated;
            return wrapper;
        }

        public void setAcquiredForRead(boolean acquiredForRead) {
            this.acquiredForRead = acquiredForRead;
        }

        public void acquireLock(ObjectBuildingQuery query) {
            CacheKey tempKey = CoherenceInterceptor.this.checkLockedObjects(this.wrappedKey.getKey());
            if (tempKey == null) {
                CoherenceInterceptor.this.storeLockedCacheKey((CacheKey)this, query.requiresDeferredLocks());
            }
            this.getWrappedCacheKey().acquire();
        }

        public void release() {
            this.getWrappedCacheKey().release();
            CoherenceInterceptor.this.removeLockedCacheKey((CacheKey)this, false);
            this.putInCoherence();
        }

        public void releaseDeferredLock() {
            this.getWrappedCacheKey().release();
            CoherenceInterceptor.this.removeLockedCacheKey((CacheKey)this, true);
        }

        protected void putInCoherence() {
            if (this.updated && this.wrappedKey.getObject() != null) {
                try {
                    CoherenceCacheHelper.putIntoCoherence(CoherenceInterceptor.this.descriptor, CoherenceInterceptor.this.interceptedSession, CoherenceInterceptor.this.namedCache, this.wrappedKey.getKey(), this.wrappedKey.getObject(), this.wrappedKey.getProtectedForeignKeys(), this.acquiredForRead, CoherenceInterceptor.this.shouldTranslatePKs, CoherenceInterceptor.this.triggerFetchGroups);
                }
                finally {
                    this.updated = false;
                }
            }
        }

        public void setReadTime(long readTime) {
            this.updated = true;
            this.wrappedKey.setReadTime(readTime);
        }

        public void setObject(Object object) {
            this.updated = true;
            this.wrappedKey.setObject(object);
        }

        public void internalSetObject(Object object) {
            this.wrappedKey.setObject(object);
        }

        public int getInvalidationState() {
            return this.wrappedKey.getInvalidationState();
        }

        public AbstractRecord getProtectedForeignKeys() {
            return this.wrappedKey.getProtectedForeignKeys();
        }

        public void setProtectedForeignKeys(AbstractRecord protectedForeignKeys) {
            this.wrappedKey.setProtectedForeignKeys(protectedForeignKeys);
        }
    }

    protected class DeferredLockedCacheKeys {
        int count;
        List<CoherenceOnlyCacheKeyWrapper> cacheKeys;

        protected DeferredLockedCacheKeys() {
        }

        void acquire() {
            ++this.count;
        }

        void release(CoherenceOnlyCacheKeyWrapper cacheKey) {
            --this.count;
            if (this.count == 0) {
                if (this.cacheKeys == null) {
                    cacheKey.putInCoherence();
                } else {
                    this.cacheKeys.add(cacheKey);
                    RuntimeException exception = null;
                    for (CoherenceOnlyCacheKeyWrapper currentCacheKey : this.cacheKeys) {
                        try {
                            currentCacheKey.putInCoherence();
                        }
                        catch (RuntimeException ex) {
                            if (exception != null) continue;
                            exception = ex;
                        }
                    }
                    if (exception != null) {
                        throw exception;
                    }
                }
            } else {
                if (this.cacheKeys == null) {
                    this.cacheKeys = new ArrayList<CoherenceOnlyCacheKeyWrapper>();
                }
                this.cacheKeys.add(cacheKey);
            }
        }

        boolean isEmpty() {
            return this.count == 0;
        }
    }
}

