/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.cache;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipselink.coherence.integrated.cache.WrapperPofSerializer;
import oracle.eclipselink.coherence.integrated.internal.cache.ClassLoaderAwareImpl;
import oracle.eclipselink.coherence.integrated.internal.cache.ElementCollectionUpdateProcessor;
import oracle.eclipselink.coherence.integrated.internal.cache.LockVersionExtractor;
import oracle.eclipselink.coherence.integrated.internal.cache.RelationshipUpdateProcessor;
import oracle.eclipselink.coherence.integrated.internal.cache.VersionPutProcessor;
import oracle.eclipselink.coherence.integrated.internal.cache.VersionRemoveProcessor;
import oracle.eclipselink.coherence.integrated.internal.cache.WrapperInternal;
import oracle.eclipselink.coherence.integrated.internal.querying.EclipseLinkFilterFactory;
import oracle.eclipselink.coherence.integrated.internal.querying.FilterExtractor;

public class TopLinkGridSerializer
extends ClassLoaderAwareImpl
implements PofSerializer {
    static Factory[] factories = new Factory[]{new Factory(){

        @Override
        PortableObject instantiate() {
            return new FilterExtractor();
        }
    }, new Factory(){

        @Override
        PortableObject instantiate() {
            return new EclipseLinkFilterFactory.SubClassOf();
        }
    }, new Factory(){

        @Override
        PortableObject instantiate() {
            return new VersionPutProcessor();
        }
    }, new Factory(){

        @Override
        PortableObject instantiate() {
            return new VersionRemoveProcessor();
        }
    }, new Factory(){

        @Override
        PortableObject instantiate() {
            return new RelationshipUpdateProcessor();
        }
    }, new Factory(){

        @Override
        PortableObject instantiate() {
            return new ElementCollectionUpdateProcessor();
        }
    }, new Factory(){

        @Override
        PortableObject instantiate() {
            return new LockVersionExtractor();
        }
    }};
    static Map<Class, Integer> classesToIds = new HashMap<Class, Integer>(factories.length, 2.0f);
    public static final int WrapperInternal = -1;
    protected WrapperPofSerializer wrapperPofSerializer;

    public TopLinkGridSerializer() {
        this.wrapperPofSerializer = new WrapperPofSerializer();
    }

    public TopLinkGridSerializer(ClassLoader loader) {
        this.setContextClassLoader(loader);
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        super.setContextClassLoader(loader);
        this.wrapperPofSerializer = new WrapperPofSerializer(loader);
    }

    public Object deserialize(PofReader in) throws IOException {
        int id = in.readInt(0);
        if (id == -1) {
            return this.wrapperPofSerializer.deserialize(in.createNestedPofReader(1));
        }
        PortableObject obj = factories[id].instantiate();
        obj.readExternal(in.createNestedPofReader(1));
        in.readRemainder();
        return obj;
    }

    public void serialize(PofWriter out, Object obj) throws IOException {
        if (obj instanceof WrapperInternal) {
            out.writeInt(0, -1);
            this.wrapperPofSerializer.serialize(out.createNestedPofWriter(1), obj);
        } else {
            Integer id = classesToIds.get(obj.getClass());
            if (id != null) {
                out.writeInt(0, id.intValue());
                ((PortableObject)obj).writeExternal(out.createNestedPofWriter(1));
                out.writeRemainder(null);
            } else {
                throw new IllegalArgumentException("Cannot serialize object " + obj + ". Class " + obj.getClass() + " is unknown to TopLinkGridSerializer.");
            }
        }
    }

    static {
        for (int i = 0; i < factories.length; ++i) {
            classesToIds.put(factories[i].instantiate().getClass(), i);
        }
    }

    static abstract class Factory {
        Factory() {
        }

        abstract PortableObject instantiate();
    }
}

