/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.cache;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipselink.coherence.integrated.internal.cache.ClassLoaderAwareImpl;
import oracle.eclipselink.coherence.integrated.internal.cache.WrapperGenerator;
import oracle.eclipselink.coherence.integrated.internal.cache.WrapperInternal;

public class WrapperPofSerializer
extends ClassLoaderAwareImpl
implements PofSerializer {
    protected Map<String, Class> classes = new HashMap<String, Class>();
    protected boolean isNotEclipseLink = System.getProperty("eclipselink.coherence.not-eclipselink") != null;

    public WrapperPofSerializer() {
    }

    public WrapperPofSerializer(ClassLoader loader) {
        this();
        this.setContextClassLoader(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(PofReader pofreader) throws IOException {
        Object wrapperName = pofreader.readObject(0);
        if (wrapperName instanceof String) {
            Object entity = pofreader.readObject(1);
            if (this.isNotEclipseLink) {
                pofreader.readRemainder();
                return entity;
            }
            Class<?> wrapperClass = this.classes.get(wrapperName);
            if (wrapperClass == null) {
                Map<String, Class> map = this.classes;
                synchronized (map) {
                    try {
                        wrapperClass = Class.forName((String)wrapperName, false, this.getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        WrapperGenerator generator = new WrapperGenerator();
                        generator.createWrapperFor(entity.getClass(), this.getContextClassLoader());
                        try {
                            wrapperClass = Class.forName((String)wrapperName, false, this.getContextClassLoader());
                        }
                        catch (ClassNotFoundException ex2) {
                            pofreader.readRemainder();
                            return entity;
                        }
                    }
                    this.classes.put((String)wrapperName, wrapperClass);
                }
            }
            boolean exception = false;
            WrapperInternal wrapperInstance = null;
            try {
                wrapperInstance = (WrapperInternal)wrapperClass.newInstance();
                wrapperInstance.wrap(entity);
                wrapperInstance.setForeignKeys(pofreader.readMap(2, new HashMap()));
                wrapperInstance.setPrimaryKeys(pofreader.readMap(3, new HashMap()));
                wrapperInstance.setFetchedAttributeNames(pofreader.readMap(4, new HashMap()));
                pofreader.readRemainder();
            }
            catch (InstantiationException e) {
                exception = true;
            }
            catch (IllegalAccessException e) {
                exception = true;
            }
            if (exception) {
                return entity;
            }
            return wrapperInstance;
        }
        return wrapperName;
    }

    public void serialize(PofWriter pofwriter, Object obj) throws IOException {
        if (obj instanceof WrapperInternal) {
            WrapperInternal wrapper = (WrapperInternal)obj;
            pofwriter.writeString(0, wrapper.getWrapperClassName());
            pofwriter.writeObject(1, wrapper.unwrap());
            pofwriter.writeMap(2, wrapper.getForeignKeys());
            pofwriter.writeMap(3, wrapper.getPrimaryKeys());
            pofwriter.writeMap(4, wrapper.getFetchedAttributeNames());
            pofwriter.writeRemainder(null);
        } else {
            pofwriter.writeObject(0, obj);
        }
    }

    public boolean isNotEclipseLink() {
        return this.isNotEclipseLink;
    }

    public void setNotEclipseLink(boolean isNotEclipseLink) {
        this.isNotEclipseLink = isNotEclipseLink;
    }
}

