/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.internal.cache;

import com.tangosol.net.NamedCache;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.processor.AbstractProcessor;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.eclipselink.coherence.exceptions.IntegrationException;
import oracle.eclipselink.coherence.integrated.cache.CoherenceInterceptor;
import oracle.eclipselink.coherence.integrated.cache.Wrapper;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceAdaptor;
import oracle.eclipselink.coherence.integrated.internal.cache.ComposeIdentityMap;
import oracle.eclipselink.coherence.integrated.internal.cache.ElementCollectionUpdateProcessor;
import oracle.eclipselink.coherence.integrated.internal.cache.RelationshipUpdateProcessor;
import oracle.eclipselink.coherence.integrated.internal.cache.VersionPutProcessor;
import oracle.eclipselink.coherence.integrated.internal.cache.VersionRemoveProcessor;
import oracle.eclipselink.coherence.integrated.internal.cache.WrapperGenerator;
import oracle.eclipselink.coherence.integrated.internal.cache.WrapperInternal;
import oracle.eclipselink.coherence.integrated.internal.querying.FilterExtractor;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.indirection.CacheBasedValueHolder;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;

public abstract class CoherenceCacheHelper {
    protected static final ThreadLocal<ComposeIdentityMap> composeIdentityMap = new ThreadLocal();
    protected static CoherenceAdaptor coherenceAdaptor;
    protected static final int DECO_TOPLINK = 8;

    public static Object composeStub(ForeignReferenceMapping mapping, Object referencePKs, AbstractSession session) {
        if (referencePKs == null) {
            return null;
        }
        Object newObject = null;
        ObjectBuilder builder = mapping.getReferenceDescriptor().getObjectBuilder();
        ObjectBuildingQuery clonedQuery = (ObjectBuildingQuery)mapping.getSelectionQuery().clone();
        clonedQuery.setSession(session);
        newObject = mapping.getReferenceDescriptor().getInstantiationPolicy().buildNewInstance();
        builder.buildPrimaryKeyAttributesIntoObject(newObject, builder.buildRowFromPrimaryKeyValues(referencePKs, session), clonedQuery, session);
        return newObject;
    }

    public static Object composeAllStubs(ForeignReferenceMapping mapping, Object[] referencePKs, AbstractSession session) {
        if (mapping.isObjectReferenceMapping()) {
            if (referencePKs.length > 0) {
                return CoherenceCacheHelper.composeStub(mapping, referencePKs[0], session);
            }
            return null;
        }
        ContainerPolicy cp = ((CollectionMapping)mapping).getContainerPolicy();
        if (referencePKs.length > 0) {
            if (cp.isMapPolicy()) {
                Object container = cp.containerInstance(referencePKs.length / 2);
                boolean isElementCollection = mapping.isElementCollectionMapping();
                for (int index = 0; index < referencePKs.length; ++index) {
                    Object entryKey = referencePKs[index];
                    ++index;
                    if (cp.isMappedKeyMapPolicy()) {
                        entryKey = ((MappedKeyMapContainerPolicy)cp).getKeyMapping().createStubbedMapComponentFromSerializableKeyInfo(entryKey, session);
                    }
                    Object entryValue = referencePKs[index];
                    if (!isElementCollection) {
                        entryValue = CoherenceCacheHelper.composeStub(mapping, referencePKs[index], session);
                    }
                    cp.addInto(entryKey, entryValue, container, session);
                }
                return container;
            }
            Vector<Object> values = new Vector<Object>(referencePKs.length);
            for (Object pks : referencePKs) {
                values.add(CoherenceCacheHelper.composeStub(mapping, pks, session));
            }
            return cp.buildContainerFromVector(values, session);
        }
        return cp.containerInstance(0);
    }

    public static Object getFromCoherence(ClassDescriptor descriptor, AbstractSession interceptedSession, NamedCache namedCache, Object cacheId, CacheKey owningKey, boolean shouldTranslatePKs) {
        Object cohKey = CoherenceCacheHelper.getCoherenceKey(descriptor, cacheId, interceptedSession, shouldTranslatePKs);
        return CoherenceCacheHelper.getFromCoherenceWithCohKey(descriptor, interceptedSession, namedCache, cohKey, owningKey, shouldTranslatePKs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Object, Object> getAllFromCoherenceWithCohKey(Object[] pkList, ClassDescriptor descriptor, AbstractSession interceptedSession, IdentityMap owningMap, NamedCache namedCache, boolean shouldTranslatePKs) {
        if (shouldTranslatePKs) {
            pkList = CoherenceCacheHelper.translateToCoherencePKs(pkList, descriptor, interceptedSession);
        }
        if (interceptedSession.shouldLog(2, "cache")) {
            interceptedSession.log(2, "cache", "Coherence(" + namedCache.getCacheName() + ")::GetAll: " + pkList, (Object[])null, null, false);
        }
        Map gridEntities = namedCache.getAll(Arrays.asList(pkList));
        HashMap<Object, Object> result = new HashMap<Object, Object>(gridEntities.size());
        ComposeIdentityMap cim = composeIdentityMap.get();
        if (cim == null) {
            cim = new ComposeIdentityMap();
            composeIdentityMap.set(cim);
        }
        try {
            cim.incrementDepth();
            for (Map.Entry entry : gridEntities.entrySet()) {
                Object pk = entry.getKey();
                if (shouldTranslatePKs) {
                    pk = CoherenceCacheHelper.translateToEclipseLinkPKs(new Object[]{entry.getKey()}, descriptor, interceptedSession)[0];
                }
                Object cachedObject = null;
                cachedObject = cim.getComposedEntity(descriptor.getJavaClass(), entry.getKey());
                if (cachedObject == null) {
                    CacheKey cacheKey = new CacheKey(pk);
                    cacheKey.setOwningMap(owningMap);
                    cachedObject = CoherenceCacheHelper.composeEntity(entry.getKey(), entry.getValue(), cacheKey, descriptor, descriptor.getAttributeGroup(descriptor.getAlias()), null, null, interceptedSession, false, shouldTranslatePKs);
                    if (cachedObject != null) {
                        cim.addComposedEntity(entry.getKey(), cachedObject);
                    }
                    if (cachedObject instanceof PersistenceEntity) {
                        cacheKey.setObject(cachedObject);
                        ((PersistenceEntity)cachedObject)._persistence_setCacheKey(cacheKey);
                        ((PersistenceEntity)cachedObject)._persistence_setId(pk);
                    }
                }
                result.put(pk, cachedObject);
            }
        }
        finally {
            cim.decrementDepth();
            if (cim.atStart()) {
                composeIdentityMap.set(null);
            }
        }
        if (interceptedSession.shouldLog(3, "cache")) {
            interceptedSession.log(3, "cache", "Coherence(" + namedCache.getCacheName() + ")::Get: " + pkList + " result size: " + result.size(), (Object[])null, null, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Object, CacheKey> getAllCacheKeysFromCoherenceWithCohKey(Object[] pkList, ClassDescriptor descriptor, AbstractSession interceptedSession, IdentityMap owningMap, NamedCache namedCache, boolean shouldTranslatePKs) {
        Object[] cohPKs = pkList;
        if (shouldTranslatePKs) {
            cohPKs = CoherenceCacheHelper.translateToCoherencePKs(pkList, descriptor, interceptedSession);
        }
        if (interceptedSession.shouldLog(2, "cache")) {
            interceptedSession.log(2, "cache", "Coherence(" + namedCache.getCacheName() + ")::GetAll: " + pkList, (Object[])null, null, false);
        }
        Map gridEntities = namedCache.getAll(Arrays.asList(cohPKs));
        HashMap<Object, CacheKey> result = new HashMap<Object, CacheKey>(gridEntities.size());
        int size = pkList.length;
        ComposeIdentityMap cim = composeIdentityMap.get();
        if (cim == null) {
            cim = new ComposeIdentityMap();
            composeIdentityMap.set(cim);
        }
        try {
            cim.incrementDepth();
            for (int i = 0; i < size; ++i) {
                Object tlPK = pkList[i];
                Object cohPK = cohPKs[i];
                CacheKey cacheKey = new CacheKey(tlPK);
                cacheKey.setOwningMap(owningMap);
                Object cachedObject = null;
                cachedObject = cim.getComposedEntity(descriptor.getJavaClass(), cohPK);
                if (cachedObject == null) {
                    cachedObject = CoherenceCacheHelper.composeEntity(cohPK, gridEntities.get(cohPK), cacheKey, descriptor, descriptor.getAttributeGroup(descriptor.getAlias()), null, null, interceptedSession, false, shouldTranslatePKs);
                    if (cachedObject != null) {
                        cim.addComposedEntity(cohPK, cachedObject);
                    }
                    if (cachedObject instanceof PersistenceEntity) {
                        ((PersistenceEntity)cachedObject)._persistence_setCacheKey(cacheKey);
                        ((PersistenceEntity)cachedObject)._persistence_setId(tlPK);
                    }
                }
                cacheKey.setObject(cachedObject);
                result.put(tlPK, cacheKey);
            }
        }
        finally {
            cim.decrementDepth();
            if (cim.atStart()) {
                composeIdentityMap.set(null);
            }
        }
        if (interceptedSession.shouldLog(3, "cache")) {
            interceptedSession.log(3, "cache", "Coherence(" + namedCache.getCacheName() + ")::Get: " + Arrays.toString(pkList) + " result size: " + result.size(), (Object[])null, null, false);
        }
        return result;
    }

    public static Object getFromCoherenceWithCohKey(ClassDescriptor descriptor, AbstractSession interceptedSession, NamedCache namedCache, Object cohKey, CacheKey owningKey, boolean shouldTranslatePKs) {
        Object cachedObject = null;
        ComposeIdentityMap cim = composeIdentityMap.get();
        if (cim != null && (cachedObject = cim.getComposedEntity(descriptor.getJavaClass(), cohKey)) != null) {
            return cachedObject;
        }
        if (interceptedSession.shouldLog(2, "cache")) {
            interceptedSession.log(2, "cache", "Coherence(" + namedCache.getCacheName() + ")::Get: " + cohKey, (Object[])null, null, false);
        }
        cachedObject = namedCache.get(cohKey);
        AttributeGroup group = descriptor.getAttributeGroup(descriptor.getAlias());
        cachedObject = CoherenceCacheHelper.composeEntity(cohKey, cachedObject, owningKey, descriptor, group, null, null, interceptedSession, false, shouldTranslatePKs);
        if (cim != null && cachedObject != null) {
            cim.addComposedEntity(cohKey, cachedObject);
        }
        if (interceptedSession.shouldLog(3, "cache")) {
            interceptedSession.log(3, "cache", "Coherence(" + namedCache.getCacheName() + ")::Get: " + cohKey + " result: " + (cachedObject != null ? cachedObject.getClass().getName() + " hashcode: " + System.identityHashCode(cachedObject) : "null"), (Object[])null, null, false);
        }
        return cachedObject;
    }

    protected static void createCacheIndex(DatabaseMapping mapping, NamedCache cache, ClassDescriptor descriptor, Session session) {
        FilterExtractor extractor = new FilterExtractor(mapping);
        cache.addIndex((ValueExtractor)extractor, false, null);
    }

    public static InvocableMap.EntryProcessor createConditionalPutForOptLocking(ClassDescriptor descriptor, VersionLockingPolicy policy, Object original, Object objectToPut) {
        Object writeLockValue = policy.getWriteLockValue(original, null, null);
        return new VersionPutProcessor(writeLockValue, policy.getVersionMapping().getAttributeAccessor(), objectToPut, true);
    }

    public static InvocableMap.EntryProcessor createConditionalPutWithOptLocking(ClassDescriptor descriptor, VersionLockingPolicy policy, Object original, Object objectToPut) {
        Object writeLockValue = policy.getWriteLockValue(original, null, null);
        return new VersionPutProcessor(writeLockValue, policy.getVersionMapping().getAttributeAccessor(), objectToPut, false);
    }

    public static InvocableMap.EntryProcessor createConditionalRemoveForOptLocking(ClassDescriptor descriptor, VersionLockingPolicy policy, Object original) {
        Object writeLockValue = policy.getWriteLockValue(original, null, null);
        return new VersionRemoveProcessor(writeLockValue, policy.getVersionMapping().getAttributeAccessor());
    }

    public static boolean usesCoherenceInterceptor(ClassDescriptor descriptor) {
        return descriptor.getCacheInterceptorClass() != null && descriptor.getCacheInterceptorClass() == CoherenceInterceptor.class || descriptor.getCacheInterceptorClassName() != null && descriptor.getCacheInterceptorClassName().equals(CoherenceInterceptor.class.getName());
    }

    public static void updateRelationship(ClassDescriptor descriptor, AbstractSession interceptedSession, NamedCache namedCache, Object pk, Object attributeValue, Object rootEntity, ForeignReferenceMapping mapping, AttributeAccessor[] accessors, boolean translatePKs) {
        AbstractProcessor processor;
        Object versionValue = null;
        AttributeAccessor versionAccessor = null;
        VersionLockingPolicy policy = (VersionLockingPolicy)descriptor.getOptimisticLockingPolicy();
        if (policy != null) {
            versionValue = policy.getWriteLockValue(rootEntity, null, interceptedSession);
            versionAccessor = policy.getVersionMapping().getAttributeAccessor();
        }
        StringBuilder attributeName = new StringBuilder(accessors[0].getAttributeName());
        Object original = rootEntity;
        int length = accessors.length;
        int firstLoop = length - 1;
        for (int i = 1; i < firstLoop; ++i) {
            attributeName.append(".");
            attributeName.append(accessors[i].getAttributeName());
            original = accessors[i - 1].getAttributeValueFromObject(original);
        }
        if (firstLoop > 0) {
            attributeName.append(".");
            attributeName.append(accessors[firstLoop].getAttributeName());
            original = accessors[firstLoop - 1].getAttributeValueFromObject(original);
        }
        if (mapping.isElementCollectionMapping() && !CoherenceCacheHelper.isElementCollectionMapWithEntityKey((DatabaseMapping)mapping)) {
            processor = new ElementCollectionUpdateProcessor(attributeValue, accessors, versionValue, versionAccessor, attributeName.toString());
        } else {
            Object[] references = mapping.buildReferencesPKList(original, attributeValue, interceptedSession);
            if (translatePKs) {
                references = CoherenceCacheHelper.translateToCoherencePKs(references, mapping, interceptedSession);
            }
            processor = new RelationshipUpdateProcessor(references, attributeName.toString(), mapping.isCollectionMapping(), versionValue, versionAccessor);
        }
        namedCache.invoke(CoherenceCacheHelper.getCoherenceKey(descriptor, pk, interceptedSession, translatePKs), (InvocableMap.EntryProcessor)processor);
    }

    public static String getCacheName(ClassDescriptor descriptor) {
        String property = (String)descriptor.getProperty("eclipselink.coherence.cache.name");
        if (property == null && (property = (String)descriptor.getProperty("coherence.cache.name")) == null) {
            String defaultName = descriptor.getAlias();
            return defaultName == null ? descriptor.getJavaClassName() : defaultName;
        }
        return property;
    }

    public static CoherenceAdaptor getCoherenceAdapter() {
        return coherenceAdaptor;
    }

    public static String getWrapperClassName(Class javaClass) {
        return CoherenceCacheHelper.getWrapperClassName(javaClass.getName());
    }

    public static String getWrapperClassName(String javaClassName) {
        return "oracle.eclipselink.coherence.integrated.cache.wrappers." + javaClassName + "_Wrapper";
    }

    public static NamedCache getNamedCache(ClassDescriptor descriptor, Session session) {
        if (descriptor.hasInheritance()) {
            descriptor = descriptor.getInheritancePolicy().getRootParentDescriptor();
        }
        NamedCache cache = null;
        if (coherenceAdaptor == null) {
            try {
                Class<?> adaptorClass = Class.forName("oracle.eclipselink.coherence.integrated.internal.cache.Coherence35Adaptor");
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(adaptorClass, new Class[0], true));
                    coherenceAdaptor = (CoherenceAdaptor)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[0]));
                } else {
                    Constructor constructor = PrivilegedAccessHelper.getDeclaredConstructorFor(adaptorClass, (Class[])new Class[0], (boolean)true);
                    coherenceAdaptor = (CoherenceAdaptor)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[0]);
                }
            }
            catch (Exception exception) {
                coherenceAdaptor = new CoherenceAdaptor();
            }
        }
        cache = coherenceAdaptor.getNamedCache(descriptor, session);
        CoherenceCacheHelper.initializeForDescriptor(descriptor, cache, session);
        return cache;
    }

    public static ClassDescriptor getDescriptor(String cacheName, Session session, boolean requiresCacheInterceptor) {
        for (ClassDescriptor desc : session.getDescriptors().values()) {
            if (!cacheName.equals(CoherenceCacheHelper.getCacheName(desc))) continue;
            if (requiresCacheInterceptor) {
                if (!CoherenceCacheHelper.usesCoherenceInterceptor(desc)) continue;
                return desc;
            }
            return desc;
        }
        throw IntegrationException.unableToFindDescriptor(cacheName, session);
    }

    public static NamedCache getNamedCache(Class entityClass, Session session) {
        ClassDescriptor descriptor = session.getClassDescriptor(entityClass);
        if (descriptor == null) {
            throw new IllegalArgumentException("No descriptor found for class: " + entityClass);
        }
        return CoherenceCacheHelper.getNamedCache(descriptor, session);
    }

    public static void initializeForDescriptor(ClassDescriptor descriptor, NamedCache cache, Session session) {
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().isRootParentDescriptor()) {
            for (ClassDescriptor childDesc : descriptor.getInheritancePolicy().getChildDescriptors()) {
                CoherenceCacheHelper.initializeForDescriptor(childDesc, cache, session);
            }
        }
        if (descriptor.getProperty("coherence.descriptor.initialized") == null) {
            CoherenceCacheHelper.defineWrapperClass(descriptor, session.getPlatform().getConversionManager().getLoader());
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (mapping.getProperty((Object)"eclipselink.coherence.indexed") == null) continue;
                CoherenceCacheHelper.createCacheIndex(mapping, cache, descriptor, session);
            }
            descriptor.setProperty("coherence.descriptor.initialized", (Object)Boolean.TRUE);
        }
    }

    protected static void prepareForeignReferenceComponent(Object originalEntity, Object wrappedEntity, Object rootEntity, Wrapper cacheWrapper, ForeignReferenceMapping mapping, ClassDescriptor parentDescriptor, ClassDescriptor rootDescriptor, String attributePath, AttributeItem item, AbstractSession session, boolean translatePKs, AbstractRecord protectedForeignKeys, boolean loadFetchGroup) {
        IndirectionPolicy ip = mapping.getIndirectionPolicy();
        Object originalAttribute = mapping.getAttributeValueFromObject(originalEntity);
        ClassDescriptor targetDescriptor = mapping.getReferenceDescriptor();
        if (ip.objectIsInstantiated(originalAttribute)) {
            if (mapping.isCollectionMapping()) {
                if (mapping.isAggregateCollectionMapping()) {
                    throw new UnsupportedOperationException("Element Collections of embeddables not currently supported for Entity Aggregate caching.");
                }
                if (mapping.isDirectCollectionMapping()) {
                    if (mapping.getContainerPolicy().isMapPolicy()) {
                        Map map = (Map)ip.getRealAttributeValueFromObject(originalEntity, originalAttribute);
                        Map newMap = (Map)mapping.getContainerPolicy().containerInstance();
                        if (!((MapContainerPolicy)mapping.getContainerPolicy()).isMapKeyAttribute() && ((MapContainerPolicy)mapping.getContainerPolicy()).isMappedKeyMapPolicy()) {
                            ClassDescriptor keyDescriptor = ((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).getKeyMapping().getReferenceDescriptor();
                            if (keyDescriptor.isAggregateDescriptor()) {
                                throw new UnsupportedOperationException("Map types with Embeddable key is not supported for Entity Aggregate caching");
                            }
                            for (Map.Entry entry : map.entrySet()) {
                                Object key = entry.getKey();
                                Object value = entry.getValue();
                                if (keyDescriptor.hasInheritance() && !key.getClass().equals(keyDescriptor.getJavaClass())) {
                                    keyDescriptor = session.getDescriptor(key);
                                }
                                Object keypk = keyDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(key, session);
                                String identifier = "";
                                identifier = targetDescriptor.getCacheKeyType() == CacheKeyType.CACHE_ID ? Arrays.toString(((CacheId)keypk).getPrimaryKey()) : String.valueOf(keypk);
                                key = CoherenceCacheHelper.decomposeEntity(key, keyDescriptor, (AttributeGroup)item.getKeyGroup(key.getClass()), attributePath + ".KEY." + identifier, cacheWrapper, protectedForeignKeys, session, translatePKs, loadFetchGroup);
                                newMap.put(key, value);
                            }
                        } else {
                            mapping.setRealAttributeValueInObject(wrappedEntity, mapping.getRealAttributeValueFromObject(originalEntity, session));
                        }
                    } else {
                        mapping.setRealAttributeValueInObject(wrappedEntity, mapping.getRealAttributeValueFromObject(originalEntity, session));
                    }
                } else if (mapping.getContainerPolicy().isMapPolicy()) {
                    Map map = (Map)ip.getRealAttributeValueFromObject(originalEntity, originalAttribute);
                    Map newMap = (Map)mapping.getContainerPolicy().containerInstance();
                    if (!((MapContainerPolicy)mapping.getContainerPolicy()).isMapKeyAttribute() && ((MapContainerPolicy)mapping.getContainerPolicy()).isMappedKeyMapPolicy()) {
                        ClassDescriptor keyDescriptor = ((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).getKeyMapping().getReferenceDescriptor();
                        if (keyDescriptor.isAggregateDescriptor()) {
                            throw new UnsupportedOperationException("Map types with Embeddable key is not supported for Entity Aggregate caching");
                        }
                        for (Map.Entry entry : map.entrySet()) {
                            Object key = entry.getKey();
                            Object value = entry.getValue();
                            if (keyDescriptor.hasInheritance() && !key.getClass().equals(keyDescriptor.getJavaClass())) {
                                keyDescriptor = session.getDescriptor(key);
                            }
                            Object keypk = keyDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(key, session);
                            String identifier = "";
                            identifier = targetDescriptor.getCacheKeyType() == CacheKeyType.CACHE_ID ? Arrays.toString(((CacheId)keypk).getPrimaryKey()) : String.valueOf(keypk);
                            key = CoherenceCacheHelper.decomposeEntity(key, keyDescriptor, (AttributeGroup)item.getKeyGroup(key.getClass()), attributePath + ".KEY." + identifier, cacheWrapper, protectedForeignKeys, session, translatePKs, loadFetchGroup);
                            if (targetDescriptor.hasInheritance() && !value.getClass().equals(targetDescriptor.getJavaClass())) {
                                targetDescriptor = session.getDescriptor(value);
                            }
                            Object pk = targetDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(value, session);
                            identifier = "";
                            identifier = targetDescriptor.getCacheKeyType() == CacheKeyType.CACHE_ID ? Arrays.toString(((CacheId)pk).getPrimaryKey()) : String.valueOf(pk);
                            value = CoherenceCacheHelper.decomposeEntity(value, targetDescriptor, (AttributeGroup)item.getGroup(value.getClass()), attributePath + "." + identifier, cacheWrapper, protectedForeignKeys, session, translatePKs, loadFetchGroup);
                            newMap.put(key, value);
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            Object key = entry.getKey();
                            Object value = entry.getValue();
                            if (targetDescriptor.hasInheritance() && !value.getClass().equals(targetDescriptor.getJavaClass())) {
                                targetDescriptor = session.getDescriptor(value);
                            }
                            Object pk = targetDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(value, session);
                            String identifier = "";
                            identifier = targetDescriptor.getCacheKeyType() == CacheKeyType.CACHE_ID ? Arrays.toString(((CacheId)pk).getPrimaryKey()) : String.valueOf(pk);
                            value = CoherenceCacheHelper.decomposeEntity(value, targetDescriptor, (AttributeGroup)item.getGroup(value.getClass()), attributePath + "." + identifier, cacheWrapper, protectedForeignKeys, session, translatePKs, loadFetchGroup);
                            newMap.put(key, value);
                        }
                    }
                } else {
                    Collection newCollection = (Collection)mapping.getContainerPolicy().containerInstance();
                    for (Object originalElement : (Collection)ip.getRealAttributeValueFromObject(originalEntity, originalAttribute)) {
                        if (targetDescriptor.hasInheritance() && !originalElement.getClass().equals(targetDescriptor.getJavaClass())) {
                            targetDescriptor = session.getDescriptor(originalElement);
                        }
                        Object pk = targetDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(originalElement, session);
                        String identifier = "";
                        identifier = targetDescriptor.getCacheKeyType() == CacheKeyType.CACHE_ID ? Arrays.toString(((CacheId)pk).getPrimaryKey()) : String.valueOf(pk);
                        newCollection.add(CoherenceCacheHelper.decomposeEntity(originalElement, targetDescriptor, (AttributeGroup)item.getGroup(originalElement.getClass()), attributePath + "." + identifier, cacheWrapper, protectedForeignKeys, session, translatePKs, loadFetchGroup));
                    }
                    mapping.setRealAttributeValueInObject(wrappedEntity, (Object)newCollection);
                }
            } else {
                Object target = mapping.getRealAttributeValueFromAttribute(originalAttribute, originalEntity, session);
                if (targetDescriptor.hasInheritance() && !target.getClass().equals(targetDescriptor.getJavaClass())) {
                    targetDescriptor = session.getDescriptor(target);
                }
                mapping.setRealAttributeValueInObject(wrappedEntity, CoherenceCacheHelper.decomposeEntity(target, targetDescriptor, (AttributeGroup)item.getGroup(target.getClass()), attributePath, cacheWrapper, protectedForeignKeys, session, translatePKs, loadFetchGroup));
            }
        } else {
            CoherenceCacheHelper.decomposeForeignReferenceMapping(originalEntity, wrappedEntity, rootEntity, cacheWrapper, mapping, attributePath, parentDescriptor, rootDescriptor, translatePKs, session);
        }
    }

    public static void putIntoCoherence(ClassDescriptor descriptor, AbstractSession interceptedSession, NamedCache namedCache, Object key, Object original, AbstractRecord protectedForeignKeys, boolean forRead, boolean translatePKs, boolean loadFetchGroup) {
        if (descriptor.hasInheritance() && !original.getClass().equals(descriptor.getJavaClass())) {
            descriptor = interceptedSession.getDescriptor(original);
        }
        Object objectToPut = original;
        if (descriptor.hasRelationships()) {
            objectToPut = CoherenceCacheHelper.decomposeAndWrapEntity(original, descriptor, interceptedSession, translatePKs, loadFetchGroup);
        }
        Object cohKey = CoherenceCacheHelper.getCoherenceKey(descriptor, key, interceptedSession, translatePKs);
        if (descriptor.getOptimisticLockingPolicy() != null) {
            if (interceptedSession.shouldLog(3, "cache")) {
                interceptedSession.log(3, "cache", "Coherence(" + namedCache.getCacheName() + ")::ConditionalPut: " + cohKey + " value: " + original.getClass().getName() + " hashcode: " + System.identityHashCode(original), (Object[])null, null, false);
            }
            InvocableMap.EntryProcessor condPut = null;
            condPut = descriptor.getDefaultInsertObjectQueryRedirector() != null && !forRead ? CoherenceCacheHelper.createConditionalPutForOptLocking(descriptor, (VersionLockingPolicy)descriptor.getOptimisticLockingPolicy(), original, objectToPut) : CoherenceCacheHelper.createConditionalPutWithOptLocking(descriptor, (VersionLockingPolicy)descriptor.getOptimisticLockingPolicy(), original, objectToPut);
            Object result = namedCache.invoke(cohKey, condPut);
            if (result != null) {
                UpdateObjectQuery query = new UpdateObjectQuery();
                query.setSession(interceptedSession);
                throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating((Object)original, (ObjectLevelModifyQuery)query);
            }
        } else {
            if (interceptedSession.shouldLog(3, "cache")) {
                interceptedSession.log(3, "cache", "Coherence(" + namedCache.getCacheName() + ")::Put: " + cohKey + " value: " + original.getClass().getName() + " hashcode: " + System.identityHashCode(original), (Object[])null, null, false);
            }
            HashMap<Object, Object> putMap = new HashMap<Object, Object>();
            putMap.put(cohKey, objectToPut);
            namedCache.putAll(putMap);
        }
    }

    public static void composeForeignReferenceMapping(Object object, CacheKey owningKey, ForeignReferenceMapping mapping, ClassDescriptor rootDescriptor, String attributeName, List<AttributeAccessor> accessors, Wrapper cacheWrapper, AbstractSession session, boolean inCacheStore, boolean shouldTranslatePKs) {
        Object[] row;
        Object[] referencePKs = cacheWrapper.getPrimaryKeyValuesFor(attributeName);
        IndirectionPolicy ip = mapping.getIndirectionPolicy();
        Object vh = null;
        boolean shouldUpdateRelationship = false;
        if (!mapping.isCacheable()) {
            AbstractRecord record = owningKey.getProtectedForeignKeys();
            if (record == null) {
                record = CoherenceCacheHelper.composeDatabaseRecord(cacheWrapper.getForeignKeyValuesFor(attributeName));
            } else {
                record.putAll((Map)CoherenceCacheHelper.composeDatabaseRecord(cacheWrapper.getForeignKeyValuesFor(attributeName)));
            }
            return;
        }
        if (ip.usesIndirection()) {
            if (!(ip.getOriginalValueHolder(mapping.getAttributeValueFromObject(object), session) instanceof ValueHolder)) {
                return;
            }
            if (referencePKs == null) {
                row = cacheWrapper.getForeignKeyValuesFor(attributeName);
                if (row == null) {
                    if (mapping.getIndirectionPolicy().usesTransparentIndirection()) {
                        Object container = mapping.getRealAttributeValueFromObject(object, session);
                        if (container != null && mapping.isElementCollectionMapping() && !CoherenceCacheHelper.isElementCollectionMapWithEntityKey((DatabaseMapping)mapping)) {
                            if (mapping.getContainerPolicy().isListPolicy()) {
                                int index = 0;
                                Vector newVector = new Vector(((List)container).size());
                                for (Object element : (List)container) {
                                    Collection<String> fg = cacheWrapper.getFetchedAttributeNames().get(attributeName + "." + index);
                                    if (fg != null && !fg.isEmpty()) {
                                        EntityFetchGroup entityFetchGroup = new EntityFetchGroup(fg);
                                        entityFetchGroup.setRootEntity((FetchGroupTracker)owningKey.getObject());
                                        ((FetchGroupTracker)element)._persistence_setFetchGroup((FetchGroup)entityFetchGroup);
                                    }
                                    newVector.add(element);
                                }
                                mapping.setRealAttributeValueInObject(object, newVector);
                            } else if (mapping.getContainerPolicy().isMapPolicy() && !(container instanceof Hashtable)) {
                                Hashtable newMap = new Hashtable((Map)container);
                                mapping.setRealAttributeValueInObject(object, newMap);
                            }
                        } else {
                            mapping.setRealAttributeValueInObject(object, mapping.getContainerPolicy().containerInstance());
                        }
                    }
                    return;
                }
                vh = ip.valueFromQuery(mapping.getSelectionQuery(), (AbstractRecord)CoherenceCacheHelper.composeDatabaseRecord(row), owningKey.getObject(), session);
            } else {
                if (shouldTranslatePKs) {
                    referencePKs = CoherenceCacheHelper.translateToEclipseLinkPKs(referencePKs, mapping, session);
                }
                DatabaseRecord fks = CoherenceCacheHelper.composeDatabaseRecord(cacheWrapper.getForeignKeyValuesFor(attributeName));
                CacheBasedValueHolder cbvh = new CacheBasedValueHolder(referencePKs, (AbstractRecord)fks, session, mapping);
                cbvh.setShouldAllowInstantiationDeferral(false);
                vh = ip.buildIndirectObject((ValueHolderInterface)cbvh);
                if (inCacheStore) {
                    cbvh.setValue(CoherenceCacheHelper.composeAllStubs(mapping, referencePKs, session));
                }
            }
            mapping.setAttributeValueInObject(object, vh);
        } else if (referencePKs != null) {
            if (shouldTranslatePKs) {
                referencePKs = CoherenceCacheHelper.translateToEclipseLinkPKs(referencePKs, mapping, session);
            }
            if (inCacheStore) {
                vh = CoherenceCacheHelper.composeAllStubs(mapping, referencePKs, session);
            } else {
                AbstractSession querySession = session;
                while (querySession.isUnitOfWork()) {
                    querySession = querySession.getParent();
                }
                DatabaseRecord fks = CoherenceCacheHelper.composeDatabaseRecord(cacheWrapper.getForeignKeyValuesFor(attributeName));
                vh = new CacheBasedValueHolder(referencePKs, (AbstractRecord)fks, querySession, mapping).getValue();
            }
            mapping.setAttributeValueInObject(object, vh);
        } else {
            row = cacheWrapper.getForeignKeyValuesFor(attributeName);
            if (row != null) {
                AbstractSession querySession = session;
                while (querySession.isUnitOfWork()) {
                    querySession = querySession.getParent();
                }
                vh = session.executeQuery((DatabaseQuery)mapping.getSelectionQuery(), (AbstractRecord)CoherenceCacheHelper.composeDatabaseRecord(row));
                shouldUpdateRelationship = !inCacheStore;
                mapping.setAttributeValueInObject(object, vh);
            }
        }
        if (shouldUpdateRelationship) {
            int accessorsSize = 0;
            if (accessors != null) {
                accessorsSize = accessors.size();
            }
            AttributeAccessor[] finalArray = new AttributeAccessor[accessorsSize + 1];
            if (accessors != null) {
                accessors.toArray(finalArray);
            }
            finalArray[accessorsSize] = mapping.getAttributeAccessor();
            CoherenceCacheHelper.updateRelationship(rootDescriptor, session, CoherenceCacheHelper.getNamedCache(rootDescriptor, (Session)session), owningKey.getKey(), vh, owningKey.getObject(), mapping, finalArray, shouldTranslatePKs);
        }
    }

    public static void composeForeignReferenceComponent(Object object, CacheKey owningKey, AttributeItem item, ForeignReferenceMapping mapping, ClassDescriptor rootDescriptor, String attributeName, WrapperInternal cacheWrapper, AbstractSession session, boolean inCacheStore, boolean shouldTranslatePKs) {
        Object originalAttribute = mapping.getAttributeValueFromObject(object);
        IndirectionPolicy ip = mapping.getIndirectionPolicy();
        ClassDescriptor targetDescriptor = mapping.getReferenceDescriptor();
        Object attributeValue = null;
        if (originalAttribute != null) {
            if (mapping.isCollectionMapping()) {
                attributeValue = mapping.getContainerPolicy().containerInstance();
                if (mapping.getContainerPolicy().isMapPolicy()) {
                    Map map = (Map)ip.getRealAttributeValueFromObject(object, originalAttribute);
                    if (!((MapContainerPolicy)mapping.getContainerPolicy()).isMapKeyAttribute() && ((MapContainerPolicy)mapping.getContainerPolicy()).isMappedKeyMapPolicy()) {
                        ClassDescriptor keyDescriptor = ((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).getKeyMapping().getReferenceDescriptor();
                        if (keyDescriptor.isAggregateDescriptor()) {
                            throw new UnsupportedOperationException("Map types with Embeddable key is not supported for Entity Aggregate caching");
                        }
                        if (!mapping.isDirectCollectionMapping()) {
                            for (Map.Entry entry : map.entrySet()) {
                                if (keyDescriptor.hasInheritance() && !entry.getKey().getClass().equals(keyDescriptor.getJavaClass())) {
                                    keyDescriptor = session.getDescriptor(entry.getKey());
                                }
                                Object key = CoherenceCacheHelper.composeKey(entry.getKey(), owningKey, keyDescriptor, cacheWrapper, (AttributeGroup)item.getKeyGroup(entry.getKey().getClass()), attributeName, session, inCacheStore, shouldTranslatePKs);
                                if (targetDescriptor.hasInheritance() && !entry.getValue().getClass().equals(targetDescriptor.getJavaClass())) {
                                    targetDescriptor = session.getDescriptor(entry.getValue());
                                }
                                Object value = CoherenceCacheHelper.composeElement(entry.getValue(), owningKey, (AttributeGroup)item.getGroup(entry.getValue().getClass()), targetDescriptor, session, cacheWrapper, attributeName, inCacheStore, shouldTranslatePKs);
                                ((Map)attributeValue).put(key, value);
                            }
                        } else {
                            for (Map.Entry entry : map.entrySet()) {
                                if (keyDescriptor.hasInheritance() && !entry.getKey().getClass().equals(keyDescriptor.getJavaClass())) {
                                    keyDescriptor = session.getDescriptor(entry.getKey());
                                }
                                Object key = CoherenceCacheHelper.composeKey(entry.getKey(), owningKey, keyDescriptor, cacheWrapper, (AttributeGroup)item.getKeyGroup(entry.getKey().getClass()), attributeName, session, inCacheStore, shouldTranslatePKs);
                                ((Map)attributeValue).put(key, entry.getValue());
                            }
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            Object elementPK = targetDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(entry.getValue(), session);
                            if (targetDescriptor.hasInheritance() && !entry.getValue().getClass().equals(targetDescriptor.getJavaClass())) {
                                targetDescriptor = session.getDescriptor(entry.getValue());
                            }
                            Object value = CoherenceCacheHelper.composeElement(entry.getValue(), owningKey, (AttributeGroup)item.getGroup(entry.getValue().getClass()), targetDescriptor, session, cacheWrapper, attributeName, inCacheStore, shouldTranslatePKs);
                            ((Map)attributeValue).put(mapping.getContainerPolicy().keyFrom(value, session), value);
                        }
                    }
                } else if (!mapping.isDirectCollectionMapping()) {
                    for (Object originalElement : (Collection)ip.getRealAttributeValueFromObject(object, originalAttribute)) {
                        if (targetDescriptor.hasInheritance() && !originalElement.getClass().equals(targetDescriptor.getJavaClass())) {
                            targetDescriptor = session.getDescriptor(originalElement);
                        }
                        Object elementPK = targetDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(originalElement, session);
                        ((Collection)attributeValue).add(CoherenceCacheHelper.composeElement(originalElement, owningKey, (AttributeGroup)item.getGroup(originalElement.getClass()), targetDescriptor, session, cacheWrapper, attributeName, inCacheStore, shouldTranslatePKs));
                    }
                } else {
                    attributeValue = ip.getRealAttributeValueFromObject(object, originalAttribute);
                }
            } else {
                Object originalTarget = mapping.getRealAttributeValueFromAttribute(originalAttribute, object, session);
                Object cohKey = CoherenceCacheHelper.getCoherenceKey(targetDescriptor, targetDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(originalTarget, session), session, shouldTranslatePKs);
                attributeValue = CoherenceCacheHelper.composeEntity(cohKey, originalTarget, owningKey, targetDescriptor, (AttributeGroup)item.getGroup(originalTarget.getClass()), cacheWrapper, attributeName, session, inCacheStore, shouldTranslatePKs);
            }
            mapping.setRealAttributeValueInObject(object, attributeValue);
        }
    }

    protected static Object composeElement(Object originalElement, CacheKey owningKey, AttributeGroup group, ClassDescriptor targetDescriptor, AbstractSession session, WrapperInternal rootWrapper, String attributeName, boolean inCacheStore, boolean shouldTranslatePKs) {
        if (targetDescriptor.hasInheritance() && !originalElement.getClass().equals(targetDescriptor.getJavaClass())) {
            targetDescriptor = session.getDescriptor(originalElement);
        }
        Object elementPK = targetDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(originalElement, session);
        String identifier = "";
        identifier = targetDescriptor.getCacheKeyType() == CacheKeyType.CACHE_ID ? Arrays.toString(((CacheId)elementPK).getPrimaryKey()) : String.valueOf(elementPK);
        return CoherenceCacheHelper.composeEntity(CoherenceCacheHelper.getCoherenceKey(targetDescriptor, elementPK, session, shouldTranslatePKs), originalElement, owningKey, targetDescriptor, group, rootWrapper, attributeName + "." + identifier, session, inCacheStore, shouldTranslatePKs);
    }

    protected static Object composeKey(Object key, CacheKey owningKey, ClassDescriptor keyDescriptor, WrapperInternal cacheWrapper, AttributeGroup group, String attributeName, AbstractSession session, boolean inCacheStore, boolean shouldTranslatePKs) {
        Object keypk = keyDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(key, session);
        String identifier = "";
        identifier = keyDescriptor.getCacheKeyType() == CacheKeyType.CACHE_ID ? Arrays.toString(((CacheId)keypk).getPrimaryKey()) : String.valueOf(keypk);
        return CoherenceCacheHelper.composeEntity(CoherenceCacheHelper.getCoherenceKey(keyDescriptor, keypk, session, shouldTranslatePKs), key, owningKey, keyDescriptor, group, cacheWrapper, attributeName + ".KEY." + identifier, session, inCacheStore, shouldTranslatePKs);
    }

    public static void composeAggregate(Object aggregate, String attributeName, AttributeGroup group, WrapperInternal cacheWrapper, CacheKey owningKey, ClassDescriptor aggDescriptor, ClassDescriptor rootDescriptor, AbstractSession session, boolean inCacheStore, boolean shouldTranslatePKs) {
        if (aggregate == null) {
            return;
        }
        Collection<String> fetchGroup = cacheWrapper.getFetchedAttributeNames().get(attributeName);
        if (fetchGroup != null && !fetchGroup.isEmpty()) {
            EntityFetchGroup efg = new EntityFetchGroup(fetchGroup);
            efg.setRootEntity((FetchGroupTracker)cacheWrapper.unwrap());
            ((FetchGroupTracker)aggregate)._persistence_setFetchGroup((FetchGroup)efg);
        }
        for (DatabaseMapping mapping : aggDescriptor.getMappings()) {
            Object[] record;
            if (mapping.isForeignReferenceMapping()) {
                AttributeItem item = null;
                if (group != null) {
                    item = group.getItem(mapping.getAttributeName());
                }
                String newPath = CoherenceCacheHelper.createNewPath(attributeName, mapping.getAttributeName());
                if (item == null || cacheWrapper.getForeignKeyValuesFor(newPath) != null) {
                    CoherenceCacheHelper.composeForeignReferenceMapping(aggregate, owningKey, (ForeignReferenceMapping)mapping, rootDescriptor, newPath, aggDescriptor.getAccessorTree(), cacheWrapper, session, inCacheStore, shouldTranslatePKs);
                } else {
                    CoherenceCacheHelper.composeForeignReferenceComponent(aggregate, owningKey, item, (ForeignReferenceMapping)mapping, aggDescriptor, newPath, cacheWrapper, session, inCacheStore, shouldTranslatePKs);
                }
            }
            if (mapping.isTransformationMapping() && (record = cacheWrapper.getForeignKeyValuesFor(CoherenceCacheHelper.createNewPath(attributeName, mapping.getAttributeName()))) != null) {
                IndirectionPolicy ip = ((TransformationMapping)mapping).getIndirectionPolicy();
                mapping.setAttributeValueInObject(aggregate, ip.valueFromMethod(aggregate, (AbstractRecord)CoherenceCacheHelper.composeDatabaseRecord(record), session));
            }
            if (!mapping.isAggregateObjectMapping()) continue;
            AttributeGroup subGraph = null;
            if (group != null) {
                subGraph = group.getGroup(mapping.getAttributeName());
            }
            CoherenceCacheHelper.composeAggregate(mapping.getAttributeValueFromObject(aggregate), CoherenceCacheHelper.createNewPath(attributeName, mapping.getAttributeName()), subGraph, cacheWrapper, owningKey, mapping.getReferenceDescriptor(), rootDescriptor, session, inCacheStore, shouldTranslatePKs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object composeEntity(Object cohPk, Object object, CacheKey owningKey, ClassDescriptor descriptor, AttributeGroup group, WrapperInternal rootWrapper, String currentPath, AbstractSession session, boolean inCacheStore, boolean shouldTranslatePKs) {
        if (object == null) {
            return null;
        }
        WrapperInternal cacheWrapper = null;
        Object original = null;
        if (object instanceof WrapperInternal) {
            cacheWrapper = (WrapperInternal)object;
            original = cacheWrapper.unwrap();
        } else if (rootWrapper != null) {
            cacheWrapper = rootWrapper;
            original = object;
        } else {
            return object;
        }
        ComposeIdentityMap cim = composeIdentityMap.get();
        if (cim == null) {
            cim = new ComposeIdentityMap();
            composeIdentityMap.set(cim);
        }
        if (descriptor.hasInheritance() && !original.getClass().equals(descriptor.getJavaClass())) {
            descriptor = session.getDescriptor(original);
        }
        try {
            cim.incrementDepth();
            Object entity = cim.getComposedEntity(descriptor.getJavaClass(), cohPk);
            if (entity != null) {
                Object object2 = entity;
                return object2;
            }
            entity = descriptor.getCopyPolicy().buildClone(original, (Session)session);
            cim.addComposedEntity(cohPk, entity);
            owningKey.getWrappedCacheKey().setObject(entity);
            Collection<String> fetchGroup = cacheWrapper.getFetchedAttributeNames().get(currentPath);
            if (fetchGroup != null && !fetchGroup.isEmpty()) {
                ((FetchGroupTracker)entity)._persistence_setFetchGroup((FetchGroup)new EntityFetchGroup(fetchGroup));
            }
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (mapping.isForeignReferenceMapping()) {
                    AttributeItem item = null;
                    if (group != null) {
                        item = group.getItem(mapping.getAttributeName());
                    }
                    String newPath = CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName());
                    if (item == null || cacheWrapper.getForeignKeyValuesFor(newPath) != null) {
                        CoherenceCacheHelper.composeForeignReferenceMapping(entity, owningKey, (ForeignReferenceMapping)mapping, descriptor, newPath, null, cacheWrapper, session, inCacheStore, shouldTranslatePKs);
                        continue;
                    }
                    CoherenceCacheHelper.composeForeignReferenceComponent(entity, owningKey, item, (ForeignReferenceMapping)mapping, descriptor, newPath, cacheWrapper, session, inCacheStore, shouldTranslatePKs);
                    continue;
                }
                if (mapping.isAggregateObjectMapping()) {
                    AttributeGroup subGroup = null;
                    if (group != null) {
                        subGroup = group.getGroup(mapping.getAttributeName());
                    }
                    CoherenceCacheHelper.composeAggregate(mapping.getAttributeValueFromObject(entity), CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName()), subGroup, cacheWrapper, owningKey, mapping.getReferenceDescriptor(), descriptor, session, inCacheStore, shouldTranslatePKs);
                    continue;
                }
                if (mapping.isTransformationMapping()) {
                    Object[] record = cacheWrapper.getForeignKeyValuesFor(CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName()));
                    if (record == null) continue;
                    IndirectionPolicy ip = ((TransformationMapping)mapping).getIndirectionPolicy();
                    mapping.setAttributeValueInObject(entity, ip.valueFromMethod(entity, (AbstractRecord)CoherenceCacheHelper.composeDatabaseRecord(record), session));
                    continue;
                }
                mapping.setAttributeValueInObject(entity, mapping.getAttributeValueFromObject(original));
            }
            Object object3 = entity;
            return object3;
        }
        finally {
            cim.decrementDepth();
            if (cim.atStart()) {
                composeIdentityMap.set(null);
            }
        }
    }

    public static Object decomposeAggregate(Object aggregate, Object rootEntity, Wrapper cacheWrapper, String attributeName, AttributeGroup group, ClassDescriptor aggDescriptor, ClassDescriptor rootDescriptor, AbstractRecord protectedForeignKeys, AbstractSession session, boolean translatePKs, boolean loadFetchGroup) {
        if (aggregate == null) {
            return null;
        }
        if (aggregate instanceof FetchGroupTracker && ((FetchGroupTracker)aggregate)._persistence_getFetchGroup() != null) {
            cacheWrapper.getFetchedAttributeNames().put(attributeName, ((FetchGroupTracker)aggregate)._persistence_getFetchGroup().getAttributeNames());
        }
        Object wrappedAggregate = aggDescriptor.getObjectBuilder().buildNewInstance();
        for (DatabaseMapping mapping : aggDescriptor.getMappings()) {
            Object attributeValue;
            IndirectionPolicy ip;
            if (!mapping.isCacheable()) {
                if (protectedForeignKeys != null) {
                    cacheWrapper.setForeignKeyValuesFor(CoherenceCacheHelper.createNewPath(attributeName, mapping.getAttributeName()), CoherenceCacheHelper.decomposeDatabaseRecord(protectedForeignKeys, CoherenceCacheHelper.getKeyFields(mapping)));
                    continue;
                }
                List<DatabaseField> fields = CoherenceCacheHelper.getKeyFields(mapping);
                cacheWrapper.setForeignKeyValuesFor(CoherenceCacheHelper.createNewPath(attributeName, mapping.getAttributeName()), CoherenceCacheHelper.decomposeDatabaseRecord(CoherenceCacheHelper.extractForeignKeyValues(rootEntity, fields, rootDescriptor, session), fields));
                continue;
            }
            if (mapping.isOneToManyMapping() || mapping.isObjectReferenceMapping() || mapping.isManyToManyMapping() || CoherenceCacheHelper.isElementCollectionMapWithEntityKey(mapping)) {
                AttributeItem item = null;
                if (group != null) {
                    item = group.getItem(mapping.getAttributeName());
                }
                if (item == null) {
                    CoherenceCacheHelper.decomposeForeignReferenceMapping(aggregate, wrappedAggregate, rootEntity, cacheWrapper, (ForeignReferenceMapping)mapping, CoherenceCacheHelper.createNewPath(attributeName, mapping.getAttributeName()), aggDescriptor, rootDescriptor, translatePKs, session);
                    continue;
                }
                CoherenceCacheHelper.prepareForeignReferenceComponent(aggregate, wrappedAggregate, rootEntity, cacheWrapper, (ForeignReferenceMapping)mapping, aggDescriptor, rootDescriptor, CoherenceCacheHelper.createNewPath(attributeName, mapping.getAttributeName()), item, session, translatePKs, protectedForeignKeys, loadFetchGroup);
                continue;
            }
            if (mapping.isElementCollectionMapping()) {
                if (mapping.getReferenceDescriptor() != null && mapping.getReferenceDescriptor().hasRelationships()) {
                    throw IntegrationException.relationshipFromElementCollectionEmbeddablesNotSupported();
                }
                ip = ((ForeignReferenceMapping)mapping).getIndirectionPolicy();
                attributeValue = mapping.getAttributeValueFromObject(aggregate);
                if (attributeValue == null) continue;
                if (ip.usesIndirection()) {
                    Object vh = ip.getOriginalValueHolder(attributeValue, session);
                    if (!ip.objectIsInstantiated(attributeValue)) {
                        if (vh instanceof DatabaseValueHolder) {
                            Vector[] row = new Vector[]{((DatabaseValueHolder)vh).getRow().getFields(), ((DatabaseValueHolder)vh).getRow().getValues()};
                            cacheWrapper.setForeignKeyValuesFor(CoherenceCacheHelper.createNewPath(attributeName, mapping.getAttributeName()), CoherenceCacheHelper.decomposeDatabaseRecord(((DatabaseValueHolder)vh).getRow(), CoherenceCacheHelper.getKeyFields(mapping)));
                            mapping.setAttributeValueInObject(wrappedAggregate, ip.buildIndirectObject((ValueHolderInterface)new ValueHolder()));
                            continue;
                        }
                        ip.instantiateObject(aggregate, attributeValue);
                        mapping.setAttributeValueInObject(wrappedAggregate, mapping.buildCloneForPartObject(attributeValue, aggregate, null, wrappedAggregate, session, null, true, false));
                        continue;
                    }
                    mapping.setAttributeValueInObject(wrappedAggregate, mapping.buildCloneForPartObject(attributeValue, aggregate, null, wrappedAggregate, session, null, true, false));
                    continue;
                }
                mapping.setAttributeValueInObject(wrappedAggregate, mapping.buildCloneForPartObject(attributeValue, aggregate, null, wrappedAggregate, session, null, true, false));
                continue;
            }
            if (mapping.isAggregateObjectMapping()) {
                ClassDescriptor aggDesc = mapping.getReferenceDescriptor();
                AttributeGroup subGroup = null;
                if (group != null) {
                    group.getGroup(mapping.getAttributeName());
                }
                Object newAggregate = CoherenceCacheHelper.decomposeAggregate(mapping.getRealAttributeValueFromObject(aggregate, session), rootEntity, cacheWrapper, CoherenceCacheHelper.createNewPath(attributeName, mapping.getAttributeName()), subGroup, aggDesc, rootDescriptor, protectedForeignKeys, session, translatePKs, loadFetchGroup);
                mapping.setRealAttributeValueInObject(wrappedAggregate, newAggregate);
                continue;
            }
            if (mapping.isTransformationMapping()) {
                ip = ((TransformationMapping)mapping).getIndirectionPolicy();
                if (!ip.objectIsInstantiated(attributeValue = mapping.getAttributeValueFromObject(aggregate))) {
                    cacheWrapper.setForeignKeyValuesFor(attributeName, CoherenceCacheHelper.decomposeDatabaseRecord(((DatabaseValueHolder)ip.getOriginalValueHolder(attributeValue, session)).getRow(), CoherenceCacheHelper.getKeyFields(mapping)));
                    continue;
                }
                mapping.setAttributeValueInObject(wrappedAggregate, attributeValue);
                continue;
            }
            mapping.setAttributeValueInObject(wrappedAggregate, mapping.getAttributeValueFromObject(aggregate));
        }
        return wrappedAggregate;
    }

    public static Object decomposeAndWrapEntity(Object entity, ClassDescriptor descriptor, AbstractSession session, boolean translatePKs, boolean loadFetchGroup) {
        if (descriptor.hasRelationships()) {
            Wrapper cacheWrapper = CoherenceCacheHelper.createEntityWrapper(descriptor, entity.getClass().getClassLoader());
            cacheWrapper.wrap(CoherenceCacheHelper.decomposeEntity(entity, descriptor, descriptor.getAttributeGroup(descriptor.getAlias()), null, cacheWrapper, null, session, translatePKs, loadFetchGroup));
            return cacheWrapper;
        }
        return entity;
    }

    public static Object decomposeEntity(Object originalEntity, ClassDescriptor descriptor, AttributeGroup group, String currentPath, Wrapper cacheWrapper, AbstractRecord protectedForeignKeys, AbstractSession session, boolean translatePKs, boolean loadFetchGroup) {
        Object wrappedEntity = descriptor.getObjectBuilder().buildNewInstance();
        if (wrappedEntity instanceof FetchGroupTracker && ((FetchGroupTracker)originalEntity)._persistence_getFetchGroup() != null) {
            FetchGroup efg = ((FetchGroupTracker)originalEntity)._persistence_getFetchGroup();
            if (loadFetchGroup) {
                efg.onUnfetchedAttribute((FetchGroupTracker)originalEntity, (String)efg.getAttributeNames().iterator().next());
            } else {
                cacheWrapper.getFetchedAttributeNames().put(currentPath, ((FetchGroupTracker)originalEntity)._persistence_getFetchGroup().getAttributeNames());
            }
        }
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            Object attributeValue;
            IndirectionPolicy ip;
            if (!mapping.isCacheable()) {
                if (protectedForeignKeys != null) {
                    cacheWrapper.setForeignKeyValuesFor(CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName()), CoherenceCacheHelper.decomposeDatabaseRecord(protectedForeignKeys, CoherenceCacheHelper.getKeyFields(mapping)));
                    continue;
                }
                List<DatabaseField> fields = CoherenceCacheHelper.getKeyFields(mapping);
                cacheWrapper.setForeignKeyValuesFor(CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName()), CoherenceCacheHelper.decomposeDatabaseRecord(CoherenceCacheHelper.extractForeignKeyValues(originalEntity, fields, descriptor, session), fields));
                continue;
            }
            if (mapping.isOneToManyMapping() || mapping.isObjectReferenceMapping() || mapping.isManyToManyMapping() || CoherenceCacheHelper.isElementCollectionMapWithEntityKey(mapping)) {
                AttributeItem item = null;
                if (group != null) {
                    item = group.getItem(mapping.getAttributeName());
                }
                if (item == null) {
                    CoherenceCacheHelper.decomposeForeignReferenceMapping(originalEntity, wrappedEntity, originalEntity, cacheWrapper, (ForeignReferenceMapping)mapping, CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName()), descriptor, descriptor, translatePKs, session);
                    continue;
                }
                CoherenceCacheHelper.prepareForeignReferenceComponent(originalEntity, wrappedEntity, originalEntity, cacheWrapper, (ForeignReferenceMapping)mapping, descriptor, descriptor, CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName()), item, session, translatePKs, protectedForeignKeys, loadFetchGroup);
                continue;
            }
            if (mapping.isElementCollectionMapping()) {
                if (mapping.getReferenceDescriptor() != null && mapping.getReferenceDescriptor().hasRelationships()) {
                    throw IntegrationException.relationshipFromElementCollectionEmbeddablesNotSupported();
                }
                ip = ((ForeignReferenceMapping)mapping).getIndirectionPolicy();
                attributeValue = mapping.getAttributeValueFromObject(originalEntity);
                if (attributeValue == null) continue;
                if (ip.usesIndirection()) {
                    Object vh = ip.getOriginalValueHolder(attributeValue, session);
                    if (!ip.objectIsInstantiated(attributeValue)) {
                        if (vh instanceof DatabaseValueHolder) {
                            Vector[] row = new Vector[]{((DatabaseValueHolder)vh).getRow().getFields(), ((DatabaseValueHolder)vh).getRow().getValues()};
                            cacheWrapper.setForeignKeyValuesFor(mapping.getAttributeName(), CoherenceCacheHelper.decomposeDatabaseRecord(((DatabaseValueHolder)vh).getRow(), CoherenceCacheHelper.getKeyFields(mapping)));
                            continue;
                        }
                        ip.instantiateObject(originalEntity, attributeValue);
                        mapping.setAttributeValueInObject(wrappedEntity, mapping.buildCloneForPartObject(attributeValue, originalEntity, null, wrappedEntity, session, null, true, false));
                        continue;
                    }
                    boolean index = false;
                    if (mapping.getReferenceDescriptor() != null && mapping.getReferenceDescriptor().hasFetchGroupManager()) {
                        CoherenceCacheHelper.recordFetchGroups(attributeValue, CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName()), mapping.getContainerPolicy(), cacheWrapper);
                    }
                    mapping.setAttributeValueInObject(wrappedEntity, mapping.buildCloneForPartObject(attributeValue, originalEntity, null, wrappedEntity, session, null, true, false));
                    continue;
                }
                if (mapping.getReferenceDescriptor() != null && mapping.getReferenceDescriptor().hasFetchGroupManager()) {
                    CoherenceCacheHelper.recordFetchGroups(attributeValue, CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName()), mapping.getContainerPolicy(), cacheWrapper);
                }
                mapping.setAttributeValueInObject(wrappedEntity, mapping.buildCloneForPartObject(attributeValue, originalEntity, null, wrappedEntity, session, null, true, false));
                continue;
            }
            if (mapping.isAggregateObjectMapping()) {
                ClassDescriptor aggDesc = mapping.getReferenceDescriptor();
                AttributeGroup subGraph = null;
                if (group != null) {
                    group.getGroup(mapping.getAttributeName());
                }
                Object newAggregate = CoherenceCacheHelper.decomposeAggregate(mapping.getRealAttributeValueFromObject(originalEntity, session), originalEntity, cacheWrapper, CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName()), subGraph, aggDesc, descriptor, protectedForeignKeys, session, translatePKs, loadFetchGroup);
                mapping.setRealAttributeValueInObject(wrappedEntity, newAggregate);
                continue;
            }
            if (mapping.isTransformationMapping()) {
                ip = ((TransformationMapping)mapping).getIndirectionPolicy();
                if (!ip.objectIsInstantiated(attributeValue = mapping.getAttributeValueFromObject(originalEntity))) {
                    cacheWrapper.setForeignKeyValuesFor(CoherenceCacheHelper.createNewPath(currentPath, mapping.getAttributeName()), CoherenceCacheHelper.decomposeDatabaseRecord(((DatabaseValueHolder)ip.getOriginalValueHolder(attributeValue, session)).getRow(), CoherenceCacheHelper.getKeyFields(mapping)));
                    continue;
                }
                mapping.setAttributeValueInObject(wrappedEntity, attributeValue);
                continue;
            }
            mapping.setAttributeValueInObject(wrappedEntity, mapping.getAttributeValueFromObject(originalEntity));
        }
        return wrappedEntity;
    }

    protected static void recordFetchGroups(Object attributeValue, String attributeName, ContainerPolicy containerPolicy, Wrapper cacheWrapper) {
        if (containerPolicy.isMappedKeyMapPolicy()) {
            CoherenceCacheHelper.recordFetchGroups(attributeValue, attributeName, (MappedKeyMapContainerPolicy)containerPolicy, cacheWrapper);
            return;
        }
        if (attributeValue instanceof Set) {
            Iterator iterator = (Iterator)containerPolicy.iteratorFor(attributeValue);
            while (iterator.hasNext()) {
                FetchGroupTracker element = (FetchGroupTracker)iterator.next();
                element._persistence_getFetchGroup().onUnfetchedAttribute(element, "");
            }
            return;
        }
        int i = 0;
        Iterator iterator = (Iterator)containerPolicy.iteratorFor(attributeValue);
        while (iterator.hasNext()) {
            FetchGroupTracker element = (FetchGroupTracker)iterator.next();
            FetchGroup fg = element._persistence_getFetchGroup();
            if (fg == null) continue;
            String prefix = attributeName + "." + i;
            cacheWrapper.getFetchedAttributeNames().put(prefix, fg.getAttributeNames());
        }
    }

    protected static void recordFetchGroups(Object attributeValue, String attributeName, MappedKeyMapContainerPolicy containerPolicy, Wrapper cacheWrapper) {
        boolean i = false;
        Iterator iterator = (Iterator)containerPolicy.iteratorFor(attributeValue);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!containerPolicy.isMapKeyAttribute()) {
                if (key instanceof FetchGroupTracker && ((FetchGroupTracker)key)._persistence_getFetchGroup() != null) {
                    ((FetchGroupTracker)key)._persistence_getFetchGroup().onUnfetchedAttribute((FetchGroupTracker)key, "");
                }
                if (!(value instanceof FetchGroupTracker) || ((FetchGroupTracker)value)._persistence_getFetchGroup() == null) continue;
                ((FetchGroupTracker)value)._persistence_getFetchGroup().onUnfetchedAttribute((FetchGroupTracker)value, "");
                continue;
            }
            if (!(value instanceof FetchGroupTracker) || ((FetchGroupTracker)value)._persistence_getFetchGroup() == null) continue;
            FetchGroup fg = ((FetchGroupTracker)value)._persistence_getFetchGroup();
            cacheWrapper.getFetchedAttributeNames().put(attributeName + ".KEY_" + key.toString(), fg.getAttributeNames());
        }
    }

    protected static void decomposeForeignReferenceMapping(Object originalEntity, Object wrappedEntity, Object rootEntity, Wrapper cacheWrapper, ForeignReferenceMapping mapping, String attributePath, ClassDescriptor descriptor, ClassDescriptor rootDescriptor, boolean translatePKs, AbstractSession session) {
        IndirectionPolicy ip = mapping.getIndirectionPolicy();
        Object attributeValue = mapping.getAttributeValueFromObject(originalEntity);
        if (attributeValue == null) {
            Object[] references = new Object[]{};
            cacheWrapper.setPrimaryKeyValuesFor(attributePath, references);
            return;
        }
        if (ip.usesIndirection()) {
            Object vh = ip.getOriginalValueHolder(attributeValue, session);
            boolean hasSetForeignKey = false;
            if (ip.objectIsInstantiated(attributeValue) || mapping.isObjectReferenceMapping() && ip.objectIsInstantiated(vh)) {
                Object[] references = mapping.buildReferencesPKList(originalEntity, attributeValue, session);
                if (translatePKs) {
                    references = CoherenceCacheHelper.translateToCoherencePKs(references, mapping, session);
                }
                cacheWrapper.setPrimaryKeyValuesFor(attributePath, references);
            } else if (vh instanceof CacheBasedValueHolder) {
                Object[] references = ((CacheBasedValueHolder)vh).getCachedPKs();
                if (translatePKs) {
                    references = CoherenceCacheHelper.translateToCoherencePKs(references, mapping, session);
                }
                cacheWrapper.setPrimaryKeyValuesFor(attributePath, references);
            } else if (vh instanceof DatabaseValueHolder) {
                cacheWrapper.setForeignKeyValuesFor(attributePath, CoherenceCacheHelper.decomposeDatabaseRecord(((DatabaseValueHolder)vh).getRow(), CoherenceCacheHelper.getKeyFields((DatabaseMapping)mapping)));
                hasSetForeignKey = true;
            }
            if (mapping.isCollectionMapping()) {
                if (!hasSetForeignKey) {
                    List<DatabaseField> fields = CoherenceCacheHelper.getKeyFields((DatabaseMapping)mapping);
                    cacheWrapper.setForeignKeyValuesFor(attributePath, CoherenceCacheHelper.decomposeDatabaseRecord(CoherenceCacheHelper.extractForeignKeyValues(rootEntity, fields, rootDescriptor, session), fields));
                }
            } else {
                mapping.setAttributeValueInObject(wrappedEntity, ip.buildIndirectObject((ValueHolderInterface)new ValueHolder()));
            }
        } else {
            Object[] references = mapping.buildReferencesPKList(originalEntity, attributeValue, session);
            if (translatePKs) {
                references = CoherenceCacheHelper.translateToCoherencePKs(references, mapping, session);
            }
            cacheWrapper.setPrimaryKeyValuesFor(attributePath, references);
            if (mapping.isCollectionMapping()) {
                List<DatabaseField> fields = CoherenceCacheHelper.getKeyFields((DatabaseMapping)mapping);
                cacheWrapper.setForeignKeyValuesFor(attributePath, CoherenceCacheHelper.decomposeDatabaseRecord(CoherenceCacheHelper.extractForeignKeyValues(rootEntity, fields, rootDescriptor, session), fields));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class defineWrapperClass(ClassDescriptor descriptor, ClassLoader classLoader) {
        Class wrapperClass = (Class)descriptor.getProperty("coherence.cache.wrapper");
        if (wrapperClass == null) {
            ClassDescriptor classDescriptor = descriptor;
            synchronized (classDescriptor) {
                wrapperClass = CoherenceCacheHelper.defineWrapperClass(descriptor.getJavaClass(), classLoader);
                descriptor.setProperty("coherence.cache.wrapper", (Object)wrapperClass);
            }
        }
        return wrapperClass;
    }

    public static AbstractRecord extractForeignKeyValues(Object entity, List<DatabaseField> fields, ClassDescriptor descriptor, AbstractSession session) {
        DatabaseRecord dbRecord = new DatabaseRecord();
        for (DatabaseField field : fields) {
            dbRecord.add(field, descriptor.getObjectBuilder().extractValueFromObjectForField(entity, field, session));
        }
        return dbRecord;
    }

    public static Class defineWrapperClass(Class wrappedClass, ClassLoader classLoader) {
        Class wrapperClass;
        block12: {
            block11: {
                wrapperClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            wrapperClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(CoherenceCacheHelper.getWrapperClassName(wrappedClass), true, classLoader));
                            return wrapperClass;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            break block11;
                        }
                    }
                    wrapperClass = PrivilegedAccessHelper.getClassForName((String)CoherenceCacheHelper.getWrapperClassName(wrappedClass), (boolean)true, (ClassLoader)classLoader);
                    return wrapperClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (wrapperClass == null) {
                WrapperGenerator generator = new WrapperGenerator();
                generator.createWrapperFor(wrappedClass, classLoader);
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            wrapperClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(CoherenceCacheHelper.getWrapperClassName(wrappedClass), true, classLoader));
                            break block12;
                        }
                        catch (PrivilegedActionException exception) {
                            throw IntegrationException.failedToLoadWrapperClass(CoherenceCacheHelper.getWrapperClassName(wrappedClass), exception.getException());
                        }
                    }
                    wrapperClass = PrivilegedAccessHelper.getClassForName((String)CoherenceCacheHelper.getWrapperClassName(wrappedClass), (boolean)true, (ClassLoader)classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw IntegrationException.failedToLoadWrapperClass(CoherenceCacheHelper.getWrapperClassName(wrappedClass), exc);
                }
            }
        }
        return wrapperClass;
    }

    public static Wrapper createEntityWrapper(ClassDescriptor descriptor, ClassLoader classLoader) {
        return CoherenceCacheHelper.createEntityWrapper(CoherenceCacheHelper.defineWrapperClass(descriptor, classLoader));
    }

    public static String createNewPath(String path, String attributeName) {
        if (path == null) {
            return attributeName;
        }
        StringBuffer buffer = new StringBuffer(path);
        buffer.append(".");
        buffer.append(attributeName);
        return buffer.toString();
    }

    public static Wrapper createEntityWrapper(Class wrapperClass) {
        Wrapper wrapperInstance = null;
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    wrapperInstance = (Wrapper)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(wrapperClass));
                }
                catch (PrivilegedActionException exc) {
                    IntegrationException.failedToCreateWrapperInstance(wrapperClass.getName(), exc);
                }
            } else {
                wrapperInstance = (Wrapper)PrivilegedAccessHelper.newInstanceFromClass((Class)wrapperClass);
            }
        }
        catch (InstantiationException e) {
            IntegrationException.failedToCreateWrapperInstance(wrapperClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            IntegrationException.failedToCreateWrapperInstance(wrapperClass.getName(), e);
        }
        return wrapperInstance;
    }

    public static Wrapper wrap(Object entity) {
        Wrapper wrapperInstance = CoherenceCacheHelper.createEntityWrapper(CoherenceCacheHelper.defineWrapperClass(entity.getClass(), entity.getClass().getClassLoader()));
        wrapperInstance.wrap(entity);
        return wrapperInstance;
    }

    public static void removeFromCoherence(ClassDescriptor descriptor, AbstractSession interceptedSession, NamedCache namedCache, Object key, Object object, boolean shouldTranslatePKs) {
        Object cohKey = CoherenceCacheHelper.getCoherenceKey(descriptor, key, interceptedSession, shouldTranslatePKs);
        if (descriptor.getOptimisticLockingPolicy() != null && descriptor.getDefaultDeleteObjectQueryRedirector() != null) {
            Object result;
            if (interceptedSession.shouldLog(3, "cache")) {
                interceptedSession.log(3, "cache", "Coherence(" + namedCache.getCacheName() + ")::ConditionalRemove: " + cohKey, (Object[])null, null, false);
            }
            if ((result = namedCache.invoke(cohKey, CoherenceCacheHelper.createConditionalRemoveForOptLocking(descriptor, (VersionLockingPolicy)descriptor.getOptimisticLockingPolicy(), object))) != null) {
                DeleteObjectQuery query = new DeleteObjectQuery();
                query.setSession(interceptedSession);
                throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating((Object)object, (ObjectLevelModifyQuery)query);
            }
        } else {
            if (interceptedSession.shouldLog(3, "cache")) {
                interceptedSession.log(3, "cache", "Coherence(" + namedCache.getCacheName() + ")::Remove: " + cohKey, (Object[])null, null, false);
            }
            namedCache.remove(cohKey);
        }
    }

    public static Object[] translateToEclipseLinkPKs(Object[] cohKeys, ForeignReferenceMapping mapping, AbstractSession session) {
        if (cohKeys.length == 0) {
            return cohKeys;
        }
        ClassDescriptor desc = mapping.getReferenceDescriptor();
        CMPPolicy cmpPolicy = null;
        if (desc != null && !desc.isDescriptorTypeAggregate() && desc.hasCMPPolicy() && desc.getCacheKeyType() == CacheKeyType.CACHE_ID) {
            cmpPolicy = desc.getCMPPolicy();
        }
        CMPPolicy keyCmpPolicy = null;
        boolean isMap = false;
        if (mapping.isCollectionMapping() && mapping.getContainerPolicy().isMapPolicy()) {
            ClassDescriptor keyDescriptor;
            isMap = true;
            if (mapping.getContainerPolicy().isMappedKeyMapPolicy() && ((DatabaseMapping)((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).getKeyMapping()).isForeignReferenceMapping() && (keyDescriptor = ((ForeignReferenceMapping)((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).getKeyMapping()).getReferenceDescriptor()).hasCMPPolicy() && keyDescriptor.getCacheKeyType() == CacheKeyType.CACHE_ID) {
                keyCmpPolicy = keyDescriptor.getCMPPolicy();
            }
        }
        if (cmpPolicy != null || keyCmpPolicy != null) {
            int index;
            Object[] translatedPKs = new Object[cohKeys.length];
            int indexStart = 0;
            int indexIncrement = 1;
            if (isMap) {
                if (keyCmpPolicy != null) {
                    for (index = 0; index < cohKeys.length; index += 2) {
                        translatedPKs[index] = keyCmpPolicy.createPrimaryKeyFromId(cohKeys[index], session);
                    }
                } else {
                    for (index = 0; index < cohKeys.length; index += 2) {
                        translatedPKs[index] = cohKeys[index];
                    }
                }
                indexStart = 1;
                indexIncrement = 2;
            }
            if (cmpPolicy != null) {
                for (index = indexStart; index < cohKeys.length; index += indexIncrement) {
                    translatedPKs[index] = cmpPolicy.createPrimaryKeyFromId(cohKeys[index], session);
                }
            } else {
                for (index = indexStart; index < cohKeys.length; index += indexIncrement) {
                    translatedPKs[index] = cohKeys[index];
                }
            }
            return translatedPKs;
        }
        return cohKeys;
    }

    public static Object[] translateToEclipseLinkPKs(Object[] cohKeys, ClassDescriptor descriptor, AbstractSession session) {
        if (cohKeys.length > 0 && descriptor.hasCMPPolicy() && descriptor.getCacheKeyType() == CacheKeyType.CACHE_ID) {
            CMPPolicy cmpPolicy = descriptor.getCMPPolicy();
            Object[] translatedPKs = new Object[cohKeys.length];
            for (int index = 0; index < cohKeys.length; ++index) {
                translatedPKs[index] = cmpPolicy.createPrimaryKeyFromId(cohKeys[index], session);
            }
            return translatedPKs;
        }
        return cohKeys;
    }

    public static Object[] translateToCoherencePKs(Object[] eclipseLinkKeys, ForeignReferenceMapping mapping, AbstractSession session) {
        if (eclipseLinkKeys.length == 0) {
            return eclipseLinkKeys;
        }
        ClassDescriptor desc = mapping.getReferenceDescriptor();
        CMPPolicy cmpPolicy = null;
        if (desc != null && !desc.isDescriptorTypeAggregate() && desc.hasCMPPolicy() && desc.getCacheKeyType() == CacheKeyType.CACHE_ID) {
            cmpPolicy = desc.getCMPPolicy();
        }
        CMPPolicy keyCmpPolicy = null;
        boolean isMap = false;
        if (mapping.isCollectionMapping() && mapping.getContainerPolicy().isMapPolicy()) {
            ClassDescriptor keyDescriptor;
            isMap = true;
            if (mapping.getContainerPolicy().isMappedKeyMapPolicy() && ((DatabaseMapping)((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).getKeyMapping()).isForeignReferenceMapping() && (keyDescriptor = ((ForeignReferenceMapping)((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).getKeyMapping()).getReferenceDescriptor()).hasCMPPolicy() && keyDescriptor.getCacheKeyType() == CacheKeyType.CACHE_ID) {
                keyCmpPolicy = keyDescriptor.getCMPPolicy();
            }
        }
        if (cmpPolicy != null || keyCmpPolicy != null) {
            int index;
            Object[] result = new Object[eclipseLinkKeys.length];
            int indexStart = 0;
            int indexIncrement = 1;
            if (isMap) {
                if (keyCmpPolicy != null) {
                    for (index = 0; index < eclipseLinkKeys.length; index += 2) {
                        result[index] = keyCmpPolicy.createPrimaryKeyInstanceFromId(eclipseLinkKeys[index], session);
                    }
                } else {
                    for (index = 0; index < eclipseLinkKeys.length; index += 2) {
                        result[index] = eclipseLinkKeys[index];
                    }
                }
                indexStart = 1;
                indexIncrement = 2;
            }
            if (cmpPolicy != null) {
                for (index = indexStart; index < eclipseLinkKeys.length; index += indexIncrement) {
                    result[index] = cmpPolicy.createPrimaryKeyInstanceFromId(eclipseLinkKeys[index], session);
                }
            } else {
                for (index = indexStart; index < eclipseLinkKeys.length; index += indexIncrement) {
                    result[index] = eclipseLinkKeys[index];
                }
            }
            return result;
        }
        return eclipseLinkKeys;
    }

    public static Object[] translateToCoherencePKs(Object[] eclipseLinkKeys, ClassDescriptor descriptor, AbstractSession session) {
        if (eclipseLinkKeys.length > 0 && descriptor.hasCMPPolicy() && descriptor.getCacheKeyType() == CacheKeyType.CACHE_ID) {
            CMPPolicy cmpPolicy = descriptor.getCMPPolicy();
            Object[] result = new Object[eclipseLinkKeys.length];
            for (int index = 0; index < eclipseLinkKeys.length; ++index) {
                result[index] = cmpPolicy.createPrimaryKeyInstanceFromId(eclipseLinkKeys[index], session);
            }
            return result;
        }
        return eclipseLinkKeys;
    }

    public static Object getCoherenceKey(ClassDescriptor descriptor, Object key, AbstractSession interceptedSession, boolean shouldTranslatePKs) {
        if (key == null || descriptor.getCacheKeyType() == CacheKeyType.CACHE_ID && ((CacheId)key).getPrimaryKey() == null) {
            throw new IllegalStateException("Cannot have null or empty PK vector");
        }
        if (shouldTranslatePKs && descriptor.hasCMPPolicy() && descriptor.getCMPPolicy().isCMP3Policy()) {
            try {
                CMP3Policy policy = (CMP3Policy)descriptor.getCMPPolicy();
                if (policy != null) {
                    return policy.createPrimaryKeyInstanceFromId(key, interceptedSession);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return key;
    }

    protected static List<DatabaseField> getKeyFields(DatabaseMapping mapping) {
        List keyFields = null;
        keyFields = mapping.isObjectReferenceMapping() ? (mapping.isOneToOneMapping() && (((OneToOneMapping)mapping).hasRelationTable() || !((OneToOneMapping)mapping).isForeignKeyRelationship()) ? mapping.getDescriptor().getPrimaryKeyFields() : ((ObjectReferenceMapping)mapping).getForeignKeyFields()) : (mapping.isOneToManyMapping() ? ((OneToManyMapping)mapping).getSourceKeyFields() : (mapping.isManyToManyMapping() ? ((ManyToManyMapping)mapping).getSourceKeyFields() : (mapping.isDirectCollectionMapping() || mapping.isDirectMapMapping() ? ((DirectCollectionMapping)mapping).getSourceKeyFields() : (mapping.isAggregateCollectionMapping() ? ((AggregateCollectionMapping)mapping).getSourceKeyFields() : (mapping.isTransformationMapping() ? ((TransformationMapping)mapping).getFields() : new Vector())))));
        return keyFields;
    }

    public static Object[] decomposeDatabaseRecord(AbstractRecord record, Collection<DatabaseField> keyFields) {
        if (record == null) {
            return null;
        }
        Object[] row = new Object[2];
        String[] fields = new String[keyFields.size()];
        Vector<Object> values = new Vector<Object>();
        if (record != null) {
            int index = 0;
            for (DatabaseField keyField : keyFields) {
                fields[index] = keyField.getQualifiedName();
                values.add(record.get(keyField));
                ++index;
            }
        }
        row[0] = fields;
        row[1] = values;
        return row;
    }

    public static DatabaseRecord composeDatabaseRecord(Object[] record) {
        if (record == null) {
            return null;
        }
        Vector<DatabaseField> fields = new Vector<DatabaseField>();
        Object[] fieldNames = (Object[])record[0];
        for (int index = 0; index < fieldNames.length; ++index) {
            fields.add(new DatabaseField((String)fieldNames[index]));
        }
        return new DatabaseRecord(fields, new Vector((List)record[1]));
    }

    public static Object getVersionFromBinaryEntry(BinaryEntry binaryEntry) {
        return binaryEntry.getContext().getInternalValueDecoration((Object)binaryEntry.getBinaryValue(), 8);
    }

    public static Object getVersionFromBinaryEntry(BinaryEntry binaryEntry, AttributeAccessor accessor) {
        Object version = CoherenceCacheHelper.getVersionFromBinaryEntry(binaryEntry);
        if (version == null) {
            version = CoherenceCacheHelper.getAttributeValueFromObject(accessor, binaryEntry.getValue());
        }
        return (Comparable)version;
    }

    public static Binary getBinaryValueWithVersion(BinaryEntry binaryEntry, Binary binaryValue, Object version) {
        return (Binary)binaryEntry.getContext().addInternalValueDecoration((Object)binaryValue, 8, version);
    }

    public static Object getAttributeValueFromObject(AttributeAccessor accessor, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        if (!accessor.isInitialized()) {
            accessor.initializeAttributes(obj.getClass());
        }
        return accessor.getAttributeValueFromObject(obj);
    }

    public static boolean isElementCollectionMapWithEntityKey(DatabaseMapping mapping) {
        return mapping.isElementCollectionMapping() && ((CollectionMapping)mapping).getContainerPolicy().isMappedKeyMapPolicy() && ((DatabaseMapping)((MappedKeyMapContainerPolicy)((CollectionMapping)mapping).getContainerPolicy()).getKeyMapping()).isForeignReferenceMapping();
    }
}

