/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.internal.cache;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import oracle.eclipselink.coherence.integrated.cache.TopLinkGridPortableObject;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceCacheHelper;
import oracle.eclipselink.coherence.integrated.internal.cache.SerializationHelper;
import oracle.eclipselink.coherence.integrated.internal.cache.WrapperInternal;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class RelationshipUpdateProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject,
TopLinkGridPortableObject {
    protected Object[] references;
    protected String attributeName;
    protected boolean shouldKeepFk;
    protected Object versionValue;
    protected AttributeAccessor versionAccessor;

    public RelationshipUpdateProcessor() {
    }

    public RelationshipUpdateProcessor(Object[] references, String attributeName, boolean shouldKeepFk, Object versionValue, AttributeAccessor versionAccessor) {
        this.references = references;
        this.attributeName = attributeName;
        this.shouldKeepFk = shouldKeepFk;
        this.versionValue = versionValue;
        this.versionAccessor = versionAccessor;
    }

    public Object process(InvocableMap.Entry entry) {
        if (entry.isPresent()) {
            Comparable entryVersionValue;
            if (this.versionAccessor != null && (entryVersionValue = (Comparable)CoherenceCacheHelper.getVersionFromBinaryEntry((BinaryEntry)entry, this.versionAccessor)) != null && entryVersionValue.compareTo(this.versionValue) != 0) {
                return null;
            }
            WrapperInternal wrapper = (WrapperInternal)entry.getValue();
            wrapper.getPrimaryKeys().put(this.attributeName, this.references);
            if (!this.shouldKeepFk) {
                wrapper.getForeignKeys().remove(this.attributeName);
            }
            if (((BinaryEntry)entry).getBackingMap() instanceof ReadWriteBackingMap) {
                Converter valueConvertor = ((BinaryEntry)entry).getContext().getValueToInternalConverter();
                Object convertedValue = valueConvertor.convert((Object)wrapper);
                ((ReadWriteBackingMap)((BinaryEntry)entry).getBackingMap()).getInternalCache().put((Object)((BinaryEntry)entry).getBinaryKey(), convertedValue);
            } else {
                entry.setValue((Object)wrapper, true);
            }
        }
        return null;
    }

    public Map processAll(Set setEntries) {
        return null;
    }

    public void readExternal(DataInput in) throws IOException {
        this.references = (Object[])ExternalizableHelper.readObject((DataInput)in);
        this.attributeName = (String)ExternalizableHelper.readObject((DataInput)in);
        this.shouldKeepFk = in.readBoolean();
        this.versionValue = ExternalizableHelper.readObject((DataInput)in);
        this.versionAccessor = SerializationHelper.readAttributeAccessor(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.references);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.attributeName);
        out.writeBoolean(this.shouldKeepFk);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.versionValue);
        SerializationHelper.writeAttributeAccessor(out, this.versionAccessor);
    }

    public void readExternal(PofReader in) throws IOException {
        this.references = in.readObjectArray(0, new Object[0]);
        this.attributeName = in.readString(1);
        this.shouldKeepFk = in.readBoolean(2);
        this.versionValue = in.readObject(3);
        this.versionAccessor = SerializationHelper.readAttributeAccessor(in.createNestedPofReader(4));
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObjectArray(0, this.references);
        out.writeString(1, this.attributeName);
        out.writeBoolean(2, this.shouldKeepFk);
        out.writeObject(3, this.versionValue);
        SerializationHelper.writeAttributeAccessor(out.createNestedPofWriter(4), this.versionAccessor);
    }
}

