/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.internal.cache;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.eclipselink.coherence.integrated.cache.TopLinkGridPortableObject;
import oracle.eclipselink.coherence.integrated.cache.WrapperSerializer;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceCacheHelper;
import oracle.eclipselink.coherence.integrated.internal.cache.SerializationHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class VersionPutProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject,
TopLinkGridPortableObject {
    protected Object versionValue;
    protected AttributeAccessor versionAccessor;
    protected Object objectToPut;
    protected boolean returnFailure;

    public VersionPutProcessor() {
    }

    public VersionPutProcessor(Object versionValue, AttributeAccessor versionAccessor, Object objectToPut, boolean returnFailure) {
        this.versionValue = versionValue;
        this.versionAccessor = versionAccessor;
        this.objectToPut = objectToPut;
        this.returnFailure = returnFailure;
    }

    public Object process(InvocableMap.Entry entry) {
        if (!entry.isPresent() || this.isVersionValid(entry)) {
            this.updateEntryValue(entry);
        } else if (this.returnFailure) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected boolean isVersionValid(InvocableMap.Entry entry) {
        Comparable entryVersion = (Comparable)CoherenceCacheHelper.getVersionFromBinaryEntry((BinaryEntry)entry, this.versionAccessor);
        if (entryVersion == null) {
            return true;
        }
        if (this.versionValue == null) {
            return false;
        }
        return entryVersion.compareTo(this.versionValue) <= 0;
    }

    protected void updateEntryValue(InvocableMap.Entry entry) {
        Binary binaryObjectToPut = (Binary)((BinaryEntry)entry).getContext().getValueToInternalConverter().convert(this.objectToPut);
        ((BinaryEntry)entry).updateBinaryValue(CoherenceCacheHelper.getBinaryValueWithVersion((BinaryEntry)entry, binaryObjectToPut, this.versionValue));
    }

    public void readExternal(DataInput in) throws IOException {
        this.versionValue = ExternalizableHelper.readObject((DataInput)in);
        this.versionAccessor = SerializationHelper.readAttributeAccessor(in);
        this.objectToPut = WrapperSerializer.deserialize(this, ExternalizableHelper.readObject((DataInput)in));
        this.returnFailure = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.versionValue);
        SerializationHelper.writeAttributeAccessor(out, this.versionAccessor);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)WrapperSerializer.serialize(this.objectToPut));
        out.writeBoolean(this.returnFailure);
    }

    public void readExternal(PofReader in) throws IOException {
        this.versionValue = in.readObject(0);
        this.versionAccessor = SerializationHelper.readAttributeAccessor(in.createNestedPofReader(1));
        this.objectToPut = in.readObject(2);
        this.returnFailure = in.readBoolean(3);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.versionValue);
        SerializationHelper.writeAttributeAccessor(out.createNestedPofWriter(1), this.versionAccessor);
        out.writeObject(2, this.objectToPut);
        out.writeBoolean(3, this.returnFailure);
    }
}

