/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.internal.cache;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.eclipselink.coherence.integrated.cache.TopLinkGridPortableObject;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceCacheHelper;
import oracle.eclipselink.coherence.integrated.internal.cache.SerializationHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class VersionRemoveProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject,
TopLinkGridPortableObject {
    protected Object versionValue;
    protected AttributeAccessor versionAccessor;

    public VersionRemoveProcessor() {
    }

    public VersionRemoveProcessor(Object versionValue, AttributeAccessor versionAccessor) {
        this.versionValue = versionValue;
        this.versionAccessor = versionAccessor;
    }

    public Object process(InvocableMap.Entry entry) {
        if (entry.isPresent()) {
            if (this.isVersionValid(entry)) {
                entry.remove(false);
            } else {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected boolean isVersionValid(InvocableMap.Entry entry) {
        Comparable entryVersion = (Comparable)CoherenceCacheHelper.getVersionFromBinaryEntry((BinaryEntry)entry, this.versionAccessor);
        if (entryVersion == null) {
            return true;
        }
        if (this.versionValue == null) {
            return false;
        }
        return entryVersion.compareTo(this.versionValue) == 0;
    }

    public void readExternal(DataInput in) throws IOException {
        this.versionValue = ExternalizableHelper.readObject((DataInput)in);
        this.versionAccessor = SerializationHelper.readAttributeAccessor(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.versionValue);
        SerializationHelper.writeAttributeAccessor(out, this.versionAccessor);
    }

    public void readExternal(PofReader in) throws IOException {
        this.versionValue = in.readObject(0);
        this.versionAccessor = SerializationHelper.readAttributeAccessor(in.createNestedPofReader(1));
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.versionValue);
        SerializationHelper.writeAttributeAccessor(out.createNestedPofWriter(1), this.versionAccessor);
    }
}

