/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.internal.cache;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import oracle.eclipselink.coherence.exceptions.IntegrationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class WrapperGenerator {
    protected Method defineClass;
    protected String wrapperClassName;

    public WrapperGenerator() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                this.defineClass = (Method)AccessController.doPrivileged(new PrivilegedGetMethod(ClassLoader.class, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE}, true));
            }
            catch (PrivilegedActionException exception) {
                throw IntegrationException.unableToAccessDefineClassMethodOfClassLader(exception.getException());
            }
        }
        try {
            this.defineClass = PrivilegedAccessHelper.getMethod(ClassLoader.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE}, (boolean)true);
        }
        catch (NoSuchMethodException e) {
            throw IntegrationException.unableToAccessDefineClassMethodOfClassLader(e);
        }
    }

    public String getInternalWrapperClassName(Class javaClass) {
        if (this.wrapperClassName == null) {
            this.wrapperClassName = "oracle/eclipselink/coherence/integrated/cache/wrappers/" + Type.getInternalName((Class)javaClass) + "_Wrapper";
        }
        return this.wrapperClassName;
    }

    protected void defineClass(String className, ClassLoader classloader, byte[] classBytes) {
        block6: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(this.defineClass, (Object)classloader, new Object[]{null, classBytes, 0, classBytes.length}));
                        break block6;
                    }
                    catch (PrivilegedActionException exception) {
                        throw IntegrationException.unableToDefineGeneratedWrapperClass(className, exception.getException());
                    }
                }
                PrivilegedAccessHelper.invokeMethod((Method)this.defineClass, (Object)classloader, (Object[])new Object[]{null, classBytes, 0, classBytes.length});
            }
            catch (IllegalAccessException ex) {
                throw IntegrationException.unableToDefineGeneratedWrapperClass(className, ex);
            }
            catch (InvocationTargetException ex) {
                throw IntegrationException.unableToDefineGeneratedWrapperClass(className, ex);
            }
        }
    }

    public void createWrapperFor(Class javaClass, ClassLoader classLoader) {
        String wrapperName = this.getInternalWrapperClassName(javaClass);
        this.defineClass(wrapperName, classLoader, this.generateWrapper(javaClass, wrapperName));
    }

    public byte[] generateWrapper(Class javaClass, String wrapperClassName) {
        String castType = Type.getDescriptor((Class)javaClass);
        ClassWriter cw = new ClassWriter(2);
        cw.visit(49, 33, wrapperClassName, null, "java/lang/Object", new String[]{"oracle/eclipselink/coherence/integrated/internal/cache/WrapperInternal"});
        cw.visitField(4, "delegate", castType, null, null);
        cw.visitField(4, "relationships", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;[Ljava/lang/Object;>;", null);
        cw.visitField(4, "rows", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;[Ljava/lang/Object;>;", null);
        cw.visitField(4, "fetchedAttributeNames", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;[Ljava/lang/Collection<Ljava/lang/String;>;>;", null);
        MethodVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        cv.visitVarInsn(25, 0);
        cv.visitTypeInsn(187, "java/util/HashMap");
        cv.visitInsn(89);
        cv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        cv.visitFieldInsn(181, wrapperClassName, "relationships", "Ljava/util/Map;");
        cv.visitVarInsn(25, 0);
        cv.visitTypeInsn(187, "java/util/HashMap");
        cv.visitInsn(89);
        cv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        cv.visitFieldInsn(181, wrapperClassName, "rows", "Ljava/util/Map;");
        cv.visitVarInsn(25, 0);
        cv.visitTypeInsn(187, "java/util/HashMap");
        cv.visitInsn(89);
        cv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        cv.visitFieldInsn(181, wrapperClassName, "fetchedAttributeNames", "Ljava/util/Map;");
        cv.visitInsn(177);
        cv.visitMaxs(4, 1);
        cv = cw.visitMethod(1, "unwrap", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, wrapperClassName, "delegate", castType);
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "wrap", "(Ljava/lang/Object;)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, Type.getInternalName((Class)javaClass));
        cv.visitFieldInsn(181, wrapperClassName, "delegate", castType);
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        cv = cw.visitMethod(1, "getForeignKeyValuesFor", "(Ljava/lang/String;)[Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, wrapperClassName, "rows", "Ljava/util/Map;");
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitTypeInsn(192, "[Ljava/lang/Object;");
        cv.visitInsn(176);
        cv.visitMaxs(2, 2);
        cv = cw.visitMethod(1, "setForeignKeyValuesFor", "(Ljava/lang/String;[Ljava/lang/Object;)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, wrapperClassName, "rows", "Ljava/util/Map;");
        cv.visitVarInsn(25, 1);
        cv.visitVarInsn(25, 2);
        cv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitInsn(87);
        cv.visitInsn(177);
        cv.visitMaxs(3, 3);
        cv = cw.visitMethod(1, "getPrimaryKeyValuesFor", "(Ljava/lang/String;)[Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, wrapperClassName, "relationships", "Ljava/util/Map;");
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitTypeInsn(192, "[Ljava/lang/Object;");
        cv.visitInsn(176);
        cv.visitMaxs(2, 2);
        cv = cw.visitMethod(1, "setPrimaryKeyValuesFor", "(Ljava/lang/String;[Ljava/lang/Object;)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, wrapperClassName, "relationships", "Ljava/util/Map;");
        cv.visitVarInsn(25, 1);
        cv.visitVarInsn(25, 2);
        cv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitInsn(87);
        cv.visitInsn(177);
        cv.visitMaxs(3, 3);
        cv = cw.visitMethod(1, "setForeignKeys", "(Ljava/util/Map;)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitFieldInsn(181, wrapperClassName, "rows", "Ljava/util/Map;");
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        cv = cw.visitMethod(1, "setPrimaryKeys", "(Ljava/util/Map;)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitFieldInsn(181, wrapperClassName, "relationships", "Ljava/util/Map;");
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        cv = cw.visitMethod(1, "getForeignKeys", "()Ljava/util/Map;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, wrapperClassName, "rows", "Ljava/util/Map;");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "getPrimaryKeys", "()Ljava/util/Map;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, wrapperClassName, "relationships", "Ljava/util/Map;");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "getWrapperClassName", "()Ljava/lang/String;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        cv.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "setWrapperClassName", "(Ljava/lang/String;)V", null, null);
        cv.visitInsn(177);
        cv.visitMaxs(0, 2);
        cv = cw.visitMethod(1, "getFetchedAttributeNames", "()Ljava/util/Map;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, wrapperClassName, "fetchedAttributeNames", "Ljava/util/Map;");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(1, "setFetchedAttributeNames", "(Ljava/util/Map;)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitFieldInsn(181, wrapperClassName, "fetchedAttributeNames", "Ljava/util/Map;");
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        ArrayList list = new ArrayList();
        Method[] methods = javaClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getName().contains("getClass") || Modifier.isStatic(method.getModifiers())) continue;
            Class<?> attributeClass = method.getReturnType();
            String type = Type.getDescriptor(attributeClass);
            cv = cw.visitMethod(1, method.getName(), "()" + type, null, null);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, wrapperClassName, "delegate", castType);
            cv.visitMethodInsn(182, Type.getInternalName((Class)javaClass), method.getName(), "()" + type);
            if (attributeClass.isPrimitive()) {
                if (attributeClass.equals(ClassConstants.PDOUBLE)) {
                    cv.visitInsn(175);
                } else if (attributeClass.equals(ClassConstants.PFLOAT)) {
                    cv.visitInsn(174);
                } else if (attributeClass.equals(ClassConstants.PLONG)) {
                    cv.visitInsn(173);
                } else {
                    cv.visitInsn(172);
                }
            } else {
                cv.visitInsn(176);
            }
            cv.visitMaxs(1, 1);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }
}

