/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.internal.querying;

import com.tangosol.net.NamedCache;
import oracle.eclipselink.coherence.exceptions.IntegrationException;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceCacheHelper;
import oracle.eclipselink.coherence.integrated.internal.querying.FilterFactoryResolver;
import oracle.eclipselink.coherence.integrated.internal.querying.TranslationFailureDelegateResolver;
import oracle.eclipselink.coherence.integrated.querying.FilterFactory;
import oracle.eclipselink.coherence.integrated.querying.TranslationFailureDelegate;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.Session;

public abstract class CoherenceRedirector {
    protected NamedCache namedCache;
    protected FilterFactory filterFactory;
    protected TranslationFailureDelegate translationDelegate;
    protected Boolean shouldTranslatePKs;

    public FilterFactory getFilterFactory(Session session) {
        if (this.filterFactory == null) {
            this.filterFactory = FilterFactoryResolver.resolve(session);
        }
        return this.filterFactory;
    }

    public TranslationFailureDelegate getTranslationFailureDelegate(Session session) {
        if (this.translationDelegate == null) {
            this.translationDelegate = TranslationFailureDelegateResolver.resolve(session);
        }
        return this.translationDelegate;
    }

    protected NamedCache getNamedCache(ClassDescriptor descriptor, Session session) {
        if (this.namedCache == null) {
            try {
                this.namedCache = CoherenceCacheHelper.getNamedCache(descriptor, session);
            }
            catch (Exception ex) {
                throw IntegrationException.unableToFindCoherenceCache(CoherenceCacheHelper.getCacheName(descriptor), ex);
            }
        }
        return this.namedCache;
    }

    protected boolean shouldTranslatePKs(Session session) {
        if (this.shouldTranslatePKs == null) {
            Object property = session.getProperty("eclipselink.coherence.use-native-toplink-pk-classes");
            this.shouldTranslatePKs = property != null && property instanceof String && ((String)property).toLowerCase().equals("true") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return this.shouldTranslatePKs;
    }
}

