/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.internal.querying;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import oracle.eclipselink.coherence.exceptions.IntegrationException;
import oracle.eclipselink.coherence.integrated.internal.querying.EclipseLinkFilterFactory;
import oracle.eclipselink.coherence.integrated.querying.FilterFactory;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.sessions.Session;

public class FilterFactoryResolver {
    protected static FilterFactory factory;

    public static FilterFactory resolve(Session session) {
        if (factory != null) {
            return factory;
        }
        String className = (String)session.getProperty("eclipselink.coherence.filter-factory");
        if (className == null) {
            factory = new EclipseLinkFilterFactory();
            return factory;
        }
        try {
            Class<?> filterFactory = session.getPlatform().getConversionManager().getLoader().loadClass(className);
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(filterFactory, new Class[0], true));
                factory = (FilterFactory)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[0]));
            } else {
                Constructor constructor = PrivilegedAccessHelper.getDeclaredConstructorFor(filterFactory, (Class[])new Class[0], (boolean)true);
                factory = (FilterFactory)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[0]);
            }
            return factory;
        }
        catch (Exception e) {
            throw IntegrationException.unableToInstantiateFilterFactory(className, e);
        }
    }
}

