/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.querying;

import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.aggregator.CompositeAggregator;
import com.tangosol.util.processor.CompositeProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipselink.coherence.integrated.internal.querying.CoherenceRedirector;
import oracle.eclipselink.coherence.integrated.querying.FilterFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class ReportQueryFromCoherence
extends CoherenceRedirector
implements QueryRedirector {
    protected static final Boolean RESULT_IGNORED = true;

    public Object invokeQuery(DatabaseQuery query, Record arguments, Session session) {
        ReportQuery reportQuery = (ReportQuery)query;
        ArrayList<InvocableMap.EntryAggregator> aggregators = new ArrayList<InvocableMap.EntryAggregator>();
        ArrayList<InvocableMap.EntryProcessor> extractors = new ArrayList<InvocableMap.EntryProcessor>();
        boolean failedToTranslate = false;
        for (ReportItem item : reportQuery.getItems()) {
            if (item.getAttributeExpression() != null) {
                if (item.getAttributeExpression().isFunctionExpression()) {
                    if (!extractors.isEmpty()) {
                        failedToTranslate = true;
                        break;
                    }
                    InvocableMap.EntryAggregator aggregator = this.getFilterFactory(session).createAggregator(item, reportQuery, arguments, (AbstractSession)session);
                    if (aggregator != null) {
                        aggregators.add(aggregator);
                        continue;
                    }
                    failedToTranslate = true;
                    break;
                }
                if (!aggregators.isEmpty()) {
                    failedToTranslate = true;
                    break;
                }
                InvocableMap.EntryProcessor extractor = this.getFilterFactory(session).createValueExtractor(item, reportQuery, arguments, (AbstractSession)session);
                if (extractor != null) {
                    extractors.add(extractor);
                    continue;
                }
                failedToTranslate = true;
                break;
            }
            failedToTranslate = true;
            break;
        }
        if (failedToTranslate) {
            return this.getTranslationFailureDelegate(session).translationFailed((DatabaseQuery)reportQuery, arguments, session);
        }
        Filter filter = this.getFilterFactory(session).create((ObjectLevelReadQuery)reportQuery, arguments, session);
        if (filter == FilterFactory.NO_FILTER) {
            return this.getTranslationFailureDelegate(session).translationFailed((DatabaseQuery)reportQuery, arguments, session);
        }
        Object distinctSet = null;
        NamedCache cache = this.getNamedCache(query.getDescriptor().getRootDescriptor(), session);
        if (!aggregators.isEmpty()) {
            List aggregateResult = (List)cache.aggregate(filter, (InvocableMap.EntryAggregator)CompositeAggregator.createInstance((InvocableMap.EntryAggregator[])aggregators.toArray(new InvocableMap.EntryAggregator[aggregators.size()])));
            return this.wrapResultInList(this.buildObject(reportQuery, aggregateResult.toArray(), null, (AbstractSession)session));
        }
        if (!extractors.isEmpty()) {
            ArrayList extractorResult = new ArrayList(cache.invokeAll(filter, (InvocableMap.EntryProcessor)new CompositeProcessor(extractors.toArray(new InvocableMap.EntryProcessor[extractors.size()]))).values());
            return this.buildObject(reportQuery, extractorResult, (AbstractSession)session);
        }
        return null;
    }

    public String buildResultKeyForDistinct(Object[] resultRow) {
        StringBuffer key = new StringBuffer();
        for (Object object : resultRow) {
            if (object != null) {
                key.append(object.toString());
            } else {
                key.append("NULL");
            }
            key.append("_");
        }
        return key.toString();
    }

    public Object buildObject(ReportQuery query, Object[] resultRow, Set<Object> distinctSet, AbstractSession session) {
        if (distinctSet != null) {
            String key = this.buildResultKeyForDistinct(resultRow);
            if (distinctSet.contains(key)) {
                return RESULT_IGNORED;
            }
            distinctSet.add(key);
        }
        if (query.shouldReturnSingleAttribute()) {
            return this.processCloning(query, resultRow, session)[0];
        }
        if (query.shouldReturnArray()) {
            return this.processCloning(query, resultRow, session);
        }
        if (query.shouldReturnWithoutReportQueryResult()) {
            if (resultRow.length == 1) {
                return this.processCloning(query, resultRow, session)[0];
            }
            return this.processCloning(query, resultRow, session);
        }
        if (query.shouldReturnSingleValue()) {
            return this.processCloning(query, resultRow, session)[0];
        }
        return new ReportQueryResult(Arrays.asList(this.processCloning(query, resultRow, session)), null);
    }

    protected Object[] processCloning(ReportQuery query, Object[] results, AbstractSession session) {
        if (session.isUnitOfWork()) {
            UnitOfWorkImpl uow = (UnitOfWorkImpl)session;
            CacheKey parentKey = new CacheKey((Object)3);
            int size = results.length;
            for (int i = 0; i < size; ++i) {
                ReportItem item = (ReportItem)query.getItems().get(i);
                Expression expression = item.getAttributeExpression();
                if (expression == null || !expression.isObjectExpression() || expression.isQueryKeyExpression() && ((QueryKeyExpression)expression).isAttribute()) continue;
                ClassDescriptor descriptor = ((ObjectExpression)expression).getDescriptor();
                Object value = results[i];
                parentKey.setKey(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(value, session));
                parentKey.setObject(value);
                JoinedAttributeManager jam = null;
                if (item.hasJoining()) {
                    jam = item.getJoinedAttributeManager();
                }
                ClassDescriptor concreteDescriptor = item.getDescriptor();
                if (descriptor.hasInheritance()) {
                    concreteDescriptor = item.getDescriptor().getInheritancePolicy().getDescriptor(value.getClass());
                }
                results[i] = query.registerIndividualResult(value, parentKey.getKey(), uow, jam, concreteDescriptor);
            }
        }
        return results;
    }

    protected Object buildObject(ReportQuery reportQuery, Collection results, AbstractSession session) {
        if (reportQuery.shouldReturnSingleResult() || reportQuery.shouldReturnSingleValue()) {
            if (results == null || results.isEmpty()) {
                return null;
            }
            return this.wrapResultInList(this.buildObject(reportQuery, (Object[])results.iterator().next(), null, session));
        }
        ContainerPolicy containerPolicy = reportQuery.getContainerPolicy();
        int size = results.size();
        Object reportResults = containerPolicy.containerInstance(size);
        HashSet distinctSet = null;
        if (reportQuery.shouldDistinctBeUsed()) {
            distinctSet = new HashSet(size);
        }
        Iterator rows = results.iterator();
        while (rows.hasNext()) {
            Object result = this.buildObject(reportQuery, (Object[])rows.next(), null, session);
            if (result == RESULT_IGNORED) continue;
            containerPolicy.addInto(result, reportResults, session);
        }
        if (reportQuery.shouldCacheQueryResults()) {
            reportQuery.setTemporaryCachedQueryResults(reportResults);
        }
        return reportResults;
    }

    protected Object wrapResultInList(Object result) {
        ArrayList<Object> reportResults = new ArrayList<Object>();
        reportResults.add(result);
        return reportResults;
    }
}

