/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.services;

import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.eclipselink.coherence.exceptions.IntegrationException;
import oracle.eclipselink.coherence.logging.LoggingLocalization;
import oracle.eclipselink.coherence.logging.MessageGenerator;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ReflectivePOFSerializer
implements PofSerializer {
    protected static final Class<boolean[]> APBOOLEAN = boolean[].class;
    protected static final Class<double[]> APDOUBLE = double[].class;
    protected static final Class<float[]> APFLOAT = float[].class;
    protected static final Class<int[]> APINT = int[].class;
    protected static final Class<long[]> APLONG = long[].class;
    protected static final Class<short[]> APSHORT = short[].class;
    protected static final Class<Date> DATE = Date.class;
    protected static final Class<Timestamp> TIMESTAMP = Timestamp.class;
    protected Class type;
    protected List<FieldAccessor> fields;
    protected transient Set<Class> additionalTypes;
    protected String[] ignoreFieldTokens;

    public ReflectivePOFSerializer(Class type, SessionLog log, ClassDescriptor descriptor, String[] ignoreFieldTokens) {
        this.type = type;
        this.ignoreFieldTokens = ignoreFieldTokens;
        this.additionalTypes = new HashSet<Class>();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(Collator.getInstance());
        for (Class superType = type; superType != Object.class && superType != null; superType = superType.getSuperclass()) {
            Field[] fields = superType.getDeclaredFields();
            if (fields == null) continue;
            for (Field field : fields) {
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                boolean useField = true;
                for (String preFix : ignoreFieldTokens) {
                    if (field.getName().indexOf(preFix) != 0) continue;
                    useField = false;
                    break;
                }
                if (!useField) continue;
                field.setAccessible(true);
                map.put(field.getName(), field);
            }
        }
        if (log.shouldLog(2, "CONFIG")) {
            log.log(2, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_index", new Object[]{type}));
        }
        this.fields = new ArrayList<FieldAccessor>();
        int index = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (log.shouldLog(2, "CONFIG")) {
                log.log(2, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_index_entry", new Object[]{entry.getKey(), index}));
            }
            DatabaseMapping mapping = null;
            if (descriptor != null) {
                mapping = descriptor.getMappingForAttributeName(((Field)entry.getValue()).getName());
            }
            this.fields.add(this.getFieldAccessor((Field)entry.getValue(), mapping));
            ++index;
        }
    }

    public void serialize(PofWriter writer, Object object) throws IOException {
        int index = 0;
        for (FieldAccessor field : this.fields) {
            try {
                field.write(writer, object, index);
            }
            catch (Exception e) {
                throw IntegrationException.failureDuringObjectSerialization(this.type, field.getField().getName(), e);
            }
            ++index;
        }
        writer.writeRemainder(null);
    }

    public void clear() {
        this.additionalTypes = null;
    }

    public Object deserialize(PofReader reader) throws IOException {
        Object object = null;
        try {
            object = this.type.newInstance();
        }
        catch (IllegalAccessException exception) {
            try {
                Constructor defaultConstructor = this.type.getDeclaredConstructor(new Class[0]);
                defaultConstructor.setAccessible(true);
                object = defaultConstructor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw IntegrationException.failureDuringObjectSerialization(this.type, "", ex);
            }
        }
        catch (Exception e2) {
            throw IntegrationException.failureDuringObjectSerialization(this.type, "", e2);
        }
        try {
            reader.registerIdentity(object);
        }
        catch (Exception e) {
            throw IntegrationException.failureDuringObjectSerialization(this.type, "", e);
        }
        int index = 0;
        for (FieldAccessor field : this.fields) {
            try {
                field.read(reader, index, object);
            }
            catch (Exception e) {
                throw IntegrationException.failureDuringObjectSerialization(this.type, field.getField().getName(), e);
            }
            ++index;
        }
        try {
            reader.readRemainder();
        }
        catch (Exception e) {
            throw IntegrationException.failureDuringObjectSerialization(this.type, "", e);
        }
        return object;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public Class getType() {
        return this.type;
    }

    public Set<Class> getAdditionalTypes() {
        return this.additionalTypes;
    }

    protected FieldAccessor getFieldAccessor(Field field, DatabaseMapping mapping) {
        Class<?> type = field.getType();
        if (type.equals(ClassConstants.PSHORT)) {
            return new ShortFieldAccessor(field);
        }
        if (type.equals(ClassConstants.BIGDECIMAL)) {
            return new BigDecimalFieldAccessor(field);
        }
        if (type.equals(ClassConstants.BIGINTEGER)) {
            return new BigIntegerFieldAccessor(field);
        }
        if (type.equals(ClassConstants.PBOOLEAN)) {
            return new BooleanFieldAccessor(field);
        }
        if (type.equals(APBOOLEAN)) {
            return new BooleanArrayFieldAccessor(field);
        }
        if (type.equals(ClassConstants.PBYTE)) {
            return new ByteFieldAccessor(field);
        }
        if (type.equals(ClassConstants.APBYTE)) {
            return new ByteArrayFieldAccessor(field);
        }
        if (type.equals(ClassConstants.PCHAR)) {
            return new CharFieldAccessor(field);
        }
        if (type.equals(ClassConstants.APCHAR)) {
            return new CharArrayFieldAccessor(field);
        }
        if (CoreClassConstants.Collection_Class.isAssignableFrom(type)) {
            Class elementType = null;
            if (mapping != null && mapping.isCollectionMapping()) {
                elementType = mapping.getAttributeClassification();
            } else {
                Type[] arguments;
                Type genericType = field.getGenericType();
                if (genericType != null && genericType instanceof ParameterizedType && (arguments = ((ParameterizedType)genericType).getActualTypeArguments()).length == 1 && arguments[0] instanceof Class) {
                    elementType = (Class)arguments[0];
                }
            }
            if (elementType != null) {
                if (PofHelper.isIntrinsicPofType((Class)elementType)) {
                    return new PrimitiveCollectionFieldAccessor(elementType, field.getType(), field, mapping);
                }
                this.additionalTypes.add(elementType);
            }
            return new CollectionFieldAccessor(field.getType(), field, mapping);
        }
        if (type.equals(DATE)) {
            return new DateFieldAccessor(field);
        }
        if (type.equals(TIMESTAMP)) {
            this.additionalTypes.add(field.getType());
            return new ObjectFieldAccessor(field);
        }
        if (type.equals(ClassConstants.PDOUBLE)) {
            return new DoubleFieldAccessor(field);
        }
        if (type.equals(APDOUBLE)) {
            return new DoubleArrayFieldAccessor(field);
        }
        if (type.equals(ClassConstants.PFLOAT)) {
            return new FloatFieldAccessor(field);
        }
        if (type.equals(APFLOAT)) {
            return new FloatArrayFieldAccessor(field);
        }
        if (type.equals(ClassConstants.PINT)) {
            return new IntegerFieldAccessor(field);
        }
        if (type.equals(APINT)) {
            return new IntegerArrayFieldAccessor(field);
        }
        if (type.equals(ClassConstants.PLONG)) {
            return new LongFieldAccessor(field);
        }
        if (type.equals(APLONG)) {
            return new LongArrayFieldAccessor(field);
        }
        if (CoreClassConstants.Map_Class.isAssignableFrom(type)) {
            Type genericType = field.getGenericType();
            if (genericType != null && genericType instanceof ParameterizedType) {
                Type[] arguments;
                for (Type clazz : arguments = ((ParameterizedType)genericType).getActualTypeArguments()) {
                    if (!(clazz instanceof Class) || PofHelper.isIntrinsicPofType((Class)((Class)clazz))) continue;
                    this.additionalTypes.add((Class)clazz);
                }
            }
            return new MapFieldAccessor(type, field, mapping);
        }
        if (type.equals(APSHORT)) {
            return new ShortArrayFieldAccessor(field);
        }
        if (type.equals(ClassConstants.STRING)) {
            return new StringFieldAccessor(field);
        }
        if (type.isArray()) {
            Class<?> elementClass = type.getComponentType();
            if (!PofHelper.isIntrinsicPofType(elementClass)) {
                this.additionalTypes.add(elementClass);
            }
            return new ObjectArrayFieldAccessor(field);
        }
        this.additionalTypes.add(field.getType());
        return new ObjectFieldAccessor(field);
    }

    protected class MapFieldAccessor
    extends FieldAccessorImpl {
        protected Class mapType;

        public MapFieldAccessor(Class mapType, Field field, DatabaseMapping mapping) {
            super(field);
            if (mapping != null && mapping.isCollectionMapping() && mapping.getContainerPolicy().getContainerClass() != null) {
                this.mapType = mapping.getContainerPolicy().getContainerClass();
            } else if (mapType.isInterface() || Modifier.isAbstract(mapType.getModifiers())) {
                if (mapType.isAssignableFrom(HashMap.class)) {
                    this.mapType = HashMap.class;
                }
            } else {
                this.mapType = mapType;
            }
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            if (this.mapType != null) {
                writer.writeMap(index, (Map)this.field.get(object));
            } else {
                writer.writeObject(index, this.field.get(object));
            }
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            try {
                if (this.mapType != null) {
                    this.field.set(object, reader.readMap(index, (Map)this.mapType.newInstance()));
                } else {
                    this.field.set(object, reader.readObject(index));
                }
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
        }
    }

    protected class StringFieldAccessor
    extends FieldAccessorImpl {
        public StringFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeString(index, (String)this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readString(index));
        }
    }

    protected class ObjectArrayFieldAccessor
    extends FieldAccessorImpl {
        protected boolean useElementType;

        public ObjectArrayFieldAccessor(Field field) {
            super(field);
            this.useElementType = false;
            if (PofHelper.isIntrinsicPofType(field.getType().getComponentType())) {
                this.useElementType = true;
            }
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            if (this.useElementType) {
                writer.writeObjectArray(index, (Object[])this.field.get(object), this.field.getType().getComponentType());
            } else {
                writer.writeObjectArray(index, (Object[])this.field.get(object));
            }
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readObjectArray(index, (Object[])Array.newInstance(this.field.getType().getComponentType(), 0)));
        }
    }

    protected class ObjectFieldAccessor
    extends FieldAccessorImpl {
        public ObjectFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeObject(index, this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readObject(index));
        }
    }

    protected class LongArrayFieldAccessor
    extends FieldAccessorImpl {
        public LongArrayFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeLongArray(index, (long[])this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readLongArray(index));
        }
    }

    protected class LongFieldAccessor
    extends FieldAccessorImpl {
        public LongFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeLong(index, ((Long)this.field.get(object)).longValue());
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readLong(index));
        }
    }

    protected class IntegerArrayFieldAccessor
    extends FieldAccessorImpl {
        public IntegerArrayFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeIntArray(index, (int[])this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readIntArray(index));
        }
    }

    protected class IntegerFieldAccessor
    extends FieldAccessorImpl {
        public IntegerFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeInt(index, ((Integer)this.field.get(object)).intValue());
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readInt(index));
        }
    }

    protected class FloatArrayFieldAccessor
    extends FieldAccessorImpl {
        public FloatArrayFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeFloatArray(index, (float[])this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readFloatArray(index));
        }
    }

    protected class FloatFieldAccessor
    extends FieldAccessorImpl {
        public FloatFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeFloat(index, ((Float)this.field.get(object)).floatValue());
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, Float.valueOf(reader.readFloat(index)));
        }
    }

    protected class DoubleArrayFieldAccessor
    extends FieldAccessorImpl {
        public DoubleArrayFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeDoubleArray(index, (double[])this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readDoubleArray(index));
        }
    }

    protected class DoubleFieldAccessor
    extends FieldAccessorImpl {
        public DoubleFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeDouble(index, ((Double)this.field.get(object)).doubleValue());
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readDouble(index));
        }
    }

    protected class DateFieldAccessor
    extends FieldAccessorImpl {
        public DateFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeDateTimeWithZone(index, (Date)this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readDate(index));
        }
    }

    protected class PrimitiveCollectionFieldAccessor
    extends FieldAccessorImpl {
        protected Class elementType;
        protected Class collectionType;

        public PrimitiveCollectionFieldAccessor(Class elementType, Class collectionType, Field field, DatabaseMapping mapping) {
            super(field);
            this.elementType = elementType;
            if (mapping != null && mapping.isCollectionMapping() && mapping.getContainerPolicy().getContainerClass() != null) {
                this.collectionType = mapping.getContainerPolicy().getContainerClass();
            } else if (collectionType.isInterface() || Modifier.isAbstract(collectionType.getModifiers())) {
                if (collectionType.isAssignableFrom(ClassConstants.ArrayList_class)) {
                    this.collectionType = ClassConstants.ArrayList_class;
                } else if (collectionType.isAssignableFrom(ClassConstants.HashSet_class)) {
                    this.collectionType = HashSet.class;
                }
            } else {
                this.collectionType = collectionType;
            }
            this.field = field;
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            if (this.collectionType != null) {
                writer.writeCollection(index, (Collection)this.field.get(object), this.elementType);
            } else {
                writer.writeObject(index, this.field.get(object));
            }
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            try {
                if (this.collectionType != null) {
                    this.field.set(object, reader.readCollection(index, (Collection)this.collectionType.newInstance()));
                } else {
                    this.field.set(object, reader.readObject(index));
                }
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
        }
    }

    protected class CollectionFieldAccessor
    extends FieldAccessorImpl {
        protected Class collectionType;

        public CollectionFieldAccessor(Class collectionType, Field field, DatabaseMapping mapping) {
            super(field);
            if (mapping != null && mapping.isCollectionMapping() && mapping.getContainerPolicy().getContainerClass() != null) {
                this.collectionType = mapping.getContainerPolicy().getContainerClass();
            } else if (collectionType.isInterface() || Modifier.isAbstract(collectionType.getModifiers())) {
                if (collectionType.isAssignableFrom(ClassConstants.ArrayList_class)) {
                    this.collectionType = ClassConstants.ArrayList_class;
                } else if (collectionType.isAssignableFrom(ClassConstants.HashSet_class)) {
                    this.collectionType = ClassConstants.HashSet_class;
                }
            } else {
                this.collectionType = collectionType;
            }
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            if (this.collectionType != null) {
                writer.writeCollection(index, (Collection)this.field.get(object));
            } else {
                writer.writeObject(index, this.field.get(object));
            }
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            try {
                if (this.collectionType != null) {
                    this.field.set(object, reader.readCollection(index, (Collection)this.collectionType.newInstance()));
                } else {
                    this.field.set(object, reader.readObject(index));
                }
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
        }
    }

    protected class CharArrayFieldAccessor
    extends FieldAccessorImpl {
        public CharArrayFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeCharArray(index, (char[])this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readCharArray(index));
        }
    }

    protected class CharFieldAccessor
    extends FieldAccessorImpl {
        public CharFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeChar(index, ((Character)this.field.get(object)).charValue());
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, Character.valueOf(reader.readChar(index)));
        }
    }

    protected class ByteArrayFieldAccessor
    extends FieldAccessorImpl {
        public ByteArrayFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeByteArray(index, (byte[])this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readByteArray(index));
        }
    }

    protected class ByteFieldAccessor
    extends FieldAccessorImpl {
        public ByteFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeByte(index, ((Byte)this.field.get(object)).byteValue());
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readByte(index));
        }
    }

    protected class BooleanArrayFieldAccessor
    extends FieldAccessorImpl {
        public BooleanArrayFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeBooleanArray(index, (boolean[])this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readBooleanArray(index));
        }
    }

    protected class BooleanFieldAccessor
    extends FieldAccessorImpl {
        public BooleanFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeBoolean(index, ((Boolean)this.field.get(object)).booleanValue());
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readBoolean(index));
        }
    }

    protected class BigIntegerFieldAccessor
    extends FieldAccessorImpl {
        public BigIntegerFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeBigInteger(index, (BigInteger)this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readBigInteger(index));
        }
    }

    protected class BigDecimalFieldAccessor
    extends FieldAccessorImpl {
        public BigDecimalFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeBigDecimal(index, (BigDecimal)this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readBigDecimal(index));
        }
    }

    protected class ShortArrayFieldAccessor
    extends FieldAccessorImpl {
        public ShortArrayFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeShortArray(index, (short[])this.field.get(object));
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readShortArray(index));
        }
    }

    protected class ShortFieldAccessor
    extends FieldAccessorImpl {
        public ShortFieldAccessor(Field field) {
            super(field);
        }

        @Override
        public void write(PofWriter writer, Object object, int index) throws IOException, IllegalArgumentException, IllegalAccessException {
            writer.writeShort(index, ((Short)this.field.get(object)).shortValue());
        }

        @Override
        public void read(PofReader reader, int index, Object object) throws IOException, IllegalArgumentException, IllegalAccessException {
            this.field.set(object, reader.readShort(index));
        }
    }

    protected abstract class FieldAccessorImpl
    implements FieldAccessor {
        protected Field field;

        public FieldAccessorImpl(Field field) {
            this.field = field;
        }

        public String toString() {
            return Helper.getShortClassName((Object)this) + "[" + this.field.toString() + "]";
        }

        @Override
        public Field getField() {
            return this.field;
        }
    }

    protected static interface FieldAccessor {
        public void write(PofWriter var1, Object var2, int var3) throws IOException, IllegalArgumentException, IllegalAccessException;

        public void read(PofReader var1, int var2, Object var3) throws IOException, IllegalArgumentException, IllegalAccessException;

        public Field getField();
    }
}

