/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.services;

import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.Evolvable;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.PortableObjectSerializer;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.eclipselink.coherence.integrated.services.ReflectivePOFSerializer;
import oracle.eclipselink.coherence.logging.LoggingLocalization;
import oracle.eclipselink.coherence.logging.MessageGenerator;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.Session;

public class TopLinkPofContext
implements PofContext,
ClassLoaderAware,
XmlConfigurable {
    protected static PortableObjectSerializer PORTABLE_SERIALIZER_PLACEHOLDER = new PortableObjectSerializer(1);
    protected Map<Class, Integer> idOverrides;
    protected volatile boolean isInitialized = false;
    protected WeakReference<ClassLoader> classLoader;
    protected Map<String, Integer> stringToIdentifier;
    protected Map<Class<?>, Integer> classToIdentifier;
    protected Map<Integer, PofSerializer> integerToSerializer;
    protected Map<Integer, Class<?>> identifierToClass;
    protected String[] fieldPrefix = new String[]{"_persistence_"};
    protected ConfigurablePofContext coherenceConfig;

    public TopLinkPofContext() {
        this.stringToIdentifier = new ConcurrentHashMap<String, Integer>();
        this.classToIdentifier = new ConcurrentHashMap();
        this.integerToSerializer = new ConcurrentHashMap<Integer, PofSerializer>();
        this.identifierToClass = new ConcurrentHashMap();
    }

    public TopLinkPofContext(String sLocator) {
        this();
        this.coherenceConfig = new ConfigurablePofContext(sLocator);
    }

    public TopLinkPofContext(String sLocator, String fieldPrefix) {
        this();
        this.coherenceConfig = new ConfigurablePofContext(sLocator);
        if (fieldPrefix != null && !fieldPrefix.equals("")) {
            String[] prefixes = fieldPrefix.split("\\s*,\\s*");
            int oldLength = this.fieldPrefix.length;
            this.fieldPrefix = Arrays.copyOf(this.fieldPrefix, oldLength + prefixes.length);
            System.arraycopy(prefixes, 0, this.fieldPrefix, oldLength, prefixes.length);
        }
    }

    public synchronized void initializeFromSession(Session session) {
        ArrayList<Class> additionalClasses;
        block27: {
            String[] additionalFromEMF;
            if (session == null) {
                return;
            }
            ClassLoader loader = session.getPlatform().getConversionManager().getLoader();
            if (this.getContextClassLoaderInternal() == null) {
                this.setContextClassLoader(loader);
            }
            String[] additionalClassNames = null;
            String additional = System.getProperty("eclipselink.coherence.additional-pof-classes");
            if (additional != null) {
                additionalClassNames = additional.split("\\s*,\\s*", 0);
            }
            if ((additional = (String)session.getProperties().get("eclipselink.coherence.additional-pof-classes")) != null && (additionalFromEMF = additional.split("\\s*,\\s*", 0)) != null) {
                if (additionalClassNames != null) {
                    int length = additionalClassNames.length;
                    additionalClassNames = Arrays.copyOf(additionalClassNames, additionalFromEMF.length + length);
                    System.arraycopy(additionalFromEMF, 0, additionalClassNames, length - 1, additionalFromEMF.length);
                } else {
                    additionalClassNames = additionalFromEMF;
                }
            }
            additionalClasses = new ArrayList<Class>();
            if (additionalClassNames != null) {
                for (String className : additionalClassNames) {
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                additionalClasses.add((Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, this.getContextClassLoader())));
                            }
                            catch (PrivilegedActionException exception) {
                                session.getSessionLog().log(7, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_class_not_found", new Object[]{className, exception.getLocalizedMessage()}));
                            }
                            continue;
                        }
                        additionalClasses.add(PrivilegedAccessHelper.getClassForName((String)className, (boolean)true, (ClassLoader)this.getContextClassLoader()));
                    }
                    catch (ClassNotFoundException exc) {
                        session.getSessionLog().log(7, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_class_not_found", new Object[]{className, exc.getLocalizedMessage()}));
                    }
                }
            }
            this.idOverrides = new HashMap<Class, Integer>();
            String idOverridesFile = System.getProperty("eclipselink.coherence.pof-id-override-file");
            if (idOverridesFile == null && session != null) {
                idOverridesFile = (String)session.getProperties().get("eclipselink.coherence.pof-id-override-file");
            }
            if (idOverridesFile != null) {
                try {
                    URL overridesFile = this.getContextClassLoader().getResource(idOverridesFile);
                    if (overridesFile != null) {
                        URLConnection connection = overridesFile.openConnection();
                        connection.setUseCaches(false);
                        Properties overrideProperties = new Properties();
                        overrideProperties.load(connection.getInputStream());
                        for (Map.Entry<Object, Object> entry : overrideProperties.entrySet()) {
                            Class overrideClass = ClassConstants.Void_Class;
                            try {
                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                    try {
                                        overrideClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName((String)entry.getKey(), true, this.getContextClassLoader()));
                                    }
                                    catch (PrivilegedActionException exception) {
                                        session.getSessionLog().log(7, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_id_override_class_not_found", new Object[]{idOverridesFile, entry.getKey()}));
                                    }
                                } else {
                                    overrideClass = PrivilegedAccessHelper.getClassForName((String)((String)entry.getKey()), (boolean)true, (ClassLoader)this.getContextClassLoader());
                                }
                            }
                            catch (ClassNotFoundException exc) {
                                session.getSessionLog().log(7, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_id_override_class_not_found", new Object[]{idOverridesFile, entry.getKey()}));
                            }
                            try {
                                Integer id = Integer.valueOf((String)entry.getValue());
                                this.idOverrides.put(overrideClass, id);
                            }
                            catch (NumberFormatException ex) {
                                session.getSessionLog().log(7, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_id_override_not_an_int", new Object[]{idOverridesFile, entry.getValue()}));
                            }
                        }
                        break block27;
                    }
                    session.getSessionLog().log(7, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_id_override_file_not_found", new Object[]{idOverridesFile, ""}));
                }
                catch (IOException e) {
                    session.getSessionLog().log(7, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_id_override_unable_to_load_file", new Object[]{idOverridesFile, e.getLocalizedMessage()}));
                }
            }
        }
        this.registerClasses(session.getSessionLog(), this.fieldPrefix, session.getDescriptors().values(), this.idOverrides, additionalClasses.toArray(new Class[0]));
    }

    public synchronized void registerClasses(SessionLog logger, String[] ignoreFieldTokens, Collection<ClassDescriptor> descriptors, Map<Class, Integer> idOverrides, Class ... nondescriptorClasses) {
        HashSet<Class> outstandingTypes = new HashSet<Class>();
        HashMap<Class, PofSerializer> serializers = new HashMap<Class, PofSerializer>();
        for (ClassDescriptor descriptor : descriptors) {
            if (this.isUserType(descriptor.getJavaClass())) continue;
            PofSerializer serializer = this.createSerializer(descriptor.getJavaClass(), descriptor, logger, ignoreFieldTokens, outstandingTypes);
            if (serializer != null) {
                serializers.put(descriptor.getJavaClass(), serializer);
            }
            if (!descriptor.getCMPPolicy().isCMP3Policy() || ((CMP3Policy)descriptor.getCMPPolicy()).getPKClass() == null || (serializer = this.createSerializer(((CMP3Policy)descriptor.getCMPPolicy()).getPKClass(), null, logger, ignoreFieldTokens, outstandingTypes)) == null) continue;
            serializers.put(((CMP3Policy)descriptor.getCMPPolicy()).getPKClass(), serializer);
        }
        if (nondescriptorClasses != null) {
            for (Class clazz : nondescriptorClasses) {
                outstandingTypes.add(clazz);
            }
        }
        this.registerClasses(logger, ignoreFieldTokens, serializers, idOverrides, outstandingTypes.toArray(new Class[0]));
    }

    public synchronized void registerClasses(SessionLog logger, String[] ignoreFieldTokens, Map<Class, PofSerializer> preProcessedSerializers, Map<Class, Integer> idOverrides, Class ... classes) {
        HashSet<Class> outstandingTypes = new HashSet<Class>();
        outstandingTypes.addAll(Arrays.asList(classes));
        Map<Class, PofSerializer> serializers = preProcessedSerializers;
        if (preProcessedSerializers == null) {
            serializers = new HashMap<Class, PofSerializer>();
        }
        while (!outstandingTypes.isEmpty()) {
            PofSerializer serializer;
            Iterator iterator = outstandingTypes.iterator();
            Class newClass = (Class)iterator.next();
            iterator.remove();
            if (serializers.containsKey(newClass) || this.isUserType(newClass) || (serializer = this.createSerializer(newClass, null, (SessionLog)new DefaultSessionLog(), ignoreFieldTokens, outstandingTypes)) == null) continue;
            serializers.put(newClass, serializer);
        }
        boolean shouldLog = logger.shouldLog(2, "CONFIG");
        for (Map.Entry<Class, PofSerializer> entry : serializers.entrySet()) {
            Integer override;
            PofSerializer serializer = entry.getValue();
            int id = this.generateHash(entry.getKey().getName());
            if (idOverrides != null && (override = idOverrides.get(entry.getKey())) != null) {
                id = override;
            }
            if (this.identifierToClass.containsKey(id)) {
                logger.log(7, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_typeid_duplicate", new Object[]{entry.getKey(), id, this.identifierToClass.get(id)}));
            } else {
                if (serializer instanceof PortableObjectSerializer) {
                    serializer = new PortableObjectSerializer(id);
                }
                this.registerUserType(id, entry.getKey(), serializer);
            }
            if (!shouldLog) continue;
            logger.log(2, MessageGenerator.buildMessage(LoggingLocalization.class, "auto_pof_typeid", new Object[]{entry.getKey(), id}));
        }
    }

    public PofSerializer getPofSerializer(int nTypeId) {
        PofSerializer serializer = this.integerToSerializer.get(nTypeId);
        if (serializer == null) {
            if (this.coherenceConfig != null) {
                serializer = this.coherenceConfig.getPofSerializer(nTypeId);
            } else {
                throw new IllegalArgumentException("unknown user type: " + nTypeId);
            }
        }
        return serializer;
    }

    public int getUserTypeIdentifier(Class clz) {
        Integer result = this.classToIdentifier.get(clz);
        if (result == null) {
            if (this.coherenceConfig != null) {
                result = this.coherenceConfig.getUserTypeIdentifier(clz);
            } else {
                throw new IllegalArgumentException("unknown user type: " + clz.getName());
            }
        }
        return result;
    }

    public int getUserTypeIdentifier(Object o) {
        return this.getUserTypeIdentifier(o.getClass());
    }

    public int getUserTypeIdentifier(String sClass) {
        Integer result = this.stringToIdentifier.get(sClass);
        if (result == null) {
            if (this.coherenceConfig != null) {
                result = this.coherenceConfig.getUserTypeIdentifier(sClass);
            } else {
                throw new IllegalArgumentException("unknown user type: " + sClass);
            }
        }
        return result;
    }

    public boolean isUserType(Class clz) {
        Integer result = this.classToIdentifier.get(clz);
        if (result == null && this.coherenceConfig != null) {
            return this.coherenceConfig.isUserType(clz);
        }
        return result != null;
    }

    public boolean isUserType(Object o) {
        return this.isUserType(o.getClass());
    }

    public boolean isUserType(String sClass) {
        Integer result = this.stringToIdentifier.get(sClass);
        if (result == null && this.coherenceConfig != null) {
            return this.coherenceConfig.isUserType(sClass);
        }
        return result != null;
    }

    public synchronized void setContextClassLoader(ClassLoader loader) {
        this.classLoader = new WeakReference<ClassLoader>(loader);
        if (this.coherenceConfig != null) {
            this.coherenceConfig.setContextClassLoader(loader);
        }
    }

    public void registerUserType(int nTypeId, Class clz, PofSerializer serializer) {
        if (this.coherenceConfig == null || !this.coherenceConfig.isUserType(clz)) {
            this.classToIdentifier.put(clz, nTypeId);
            this.stringToIdentifier.put(clz.getName(), nTypeId);
            this.integerToSerializer.put(nTypeId, serializer);
            this.identifierToClass.put(nTypeId, clz);
        }
    }

    protected PofSerializer createSerializer(Class type, ClassDescriptor descriptor, SessionLog log, String[] ignoreFieldTokens, Set<Class> outstandingTypes) {
        if (PofHelper.isIntrinsicPofType((Class)type) || type == Object.class || type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            return null;
        }
        if (type.isEnum()) {
            return new EnumSerializer(type);
        }
        if (PortableObject.class.isAssignableFrom(type)) {
            return PORTABLE_SERIALIZER_PLACEHOLDER;
        }
        ReflectivePOFSerializer reflectiveSerializer = new ReflectivePOFSerializer(type, log, descriptor, ignoreFieldTokens);
        outstandingTypes.addAll(reflectiveSerializer.getAdditionalTypes());
        reflectiveSerializer.clear();
        return reflectiveSerializer;
    }

    public Class getClass(int nTypeId) {
        Class result = this.identifierToClass.get(nTypeId);
        if (result == null) {
            if (this.coherenceConfig != null) {
                result = this.coherenceConfig.getClass(nTypeId);
            } else {
                throw new IllegalArgumentException("unknown user type: " + nTypeId);
            }
        }
        return result;
    }

    public String getClassName(int nTypeId) {
        Class result = this.getClass(nTypeId);
        return result.getName();
    }

    protected int generateHash(String className) {
        char[] array = className.toCharArray();
        int stringLen = array.length;
        int hash = 0;
        if (stringLen > 0) {
            for (int i = 0; i < stringLen; ++i) {
                hash = 31 * hash + array[i];
            }
            if (hash == Integer.MIN_VALUE) {
                hash = Integer.MAX_VALUE;
            }
            if ((hash = Math.abs(hash)) < 2000) {
                hash += 2000;
            }
        }
        return hash;
    }

    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        PofBufferWriter writer = new PofBufferWriter(out, (PofContext)this);
        if (!(o instanceof Evolvable)) {
            writer.enableReference();
        }
        try {
            writer.writeObject(-1, o);
        }
        catch (RuntimeException e) {
            IOException ioex = new IOException(e.getMessage(), e);
            throw ioex;
        }
    }

    public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        PofBufferReader reader = new PofBufferReader(in, (PofContext)this);
        try {
            return reader.readObject(-1);
        }
        catch (RuntimeException e) {
            IOException ioex = new IOException(e.getMessage(), e);
            throw ioex;
        }
    }

    public XmlElement getConfig() {
        if (this.coherenceConfig == null) {
            return null;
        }
        return this.coherenceConfig.getConfig();
    }

    public void setConfig(XmlElement xml) {
        if (this.coherenceConfig == null) {
            this.coherenceConfig = new ConfigurablePofContext();
        }
        this.coherenceConfig.setConfig(xml);
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader loader = null;
        if (this.classLoader != null && (loader = (ClassLoader)this.classLoader.get()) != null) {
            return loader;
        }
        throw new IllegalStateException(MessageGenerator.buildMessage(LoggingLocalization.class, "classloader_not_set", new Object[0]));
    }

    public ClassLoader getContextClassLoaderInternal() {
        ClassLoader loader = null;
        if (this.classLoader != null && (loader = (ClassLoader)this.classLoader.get()) != null) {
            return loader;
        }
        return null;
    }

    public static class EnumSerializer
    implements PofSerializer {
        Object[] enumConstants;

        public EnumSerializer(Class enumType) {
            this.enumConstants = enumType.getEnumConstants();
        }

        public void serialize(PofWriter writer, Object object) throws IOException {
            writer.writeInt(0, ((Enum)object).ordinal());
            writer.writeRemainder(null);
        }

        public Object deserialize(PofReader reader) throws IOException {
            Object value = this.enumConstants[reader.readInt(0)];
            reader.readRemainder();
            return value;
        }
    }
}

