/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.logging;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class MessageGenerator {
    public static String buildMessage(Class localizationClass, String errorKey, Object[] arguments) {
        String CR = System.getProperty("line.separator");
        String shortClassName = localizationClass.getName().substring(localizationClass.getName().lastIndexOf(46) + 1);
        String message = "";
        ResourceBundle bundle = null;
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] != null) continue;
            arguments[i] = "null";
        }
        bundle = ResourceBundle.getBundle(localizationClass.getPackage().getName() + ".i18n." + shortClassName + "Resource", Locale.getDefault());
        try {
            message = bundle.getString(errorKey);
        }
        catch (MissingResourceException mre) {
            bundle = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault());
            String noTranslationMessage = bundle.getString("NoExceptionTranslationForThisLocale");
            Object[] args = new Object[]{CR};
            return MessageGenerator.format(message, arguments) + MessageGenerator.format(noTranslationMessage, args);
        }
        return MessageGenerator.format(message, arguments);
    }

    public static String buildMessage(Class exceptionClass, int errorNumber, Object[] arguments) {
        return MessageGenerator.buildMessage(exceptionClass, String.valueOf(errorNumber), arguments);
    }

    protected static String format(String message, Object[] arguments) {
        try {
            return MessageFormat.format(message, arguments);
        }
        catch (Exception ex) {
            ResourceBundle bundle = null;
            bundle = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault());
            String errorMessage = bundle.getString("ErrorFormattingMessage");
            Vector<Object> vec = new Vector<Object>();
            if (arguments != null) {
                for (int index = 0; index < arguments.length; ++index) {
                    try {
                        vec.add(arguments[index].toString());
                        continue;
                    }
                    catch (Exception ex2) {
                        vec.add(ex2);
                    }
                }
            }
            return MessageFormat.format(errorMessage, message, vec);
        }
    }

    public static String getHeader(String headerLabel) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault());
            return bundle.getString(headerLabel);
        }
        catch (MissingResourceException mre) {
            return "[" + headerLabel + "]";
        }
    }
}

