/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.standalone;

import com.tangosol.net.cache.CacheLoader;
import com.tangosol.util.Base;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceCacheHelper;
import oracle.eclipselink.coherence.querying.DontMaintainCacheRedirector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.sessions.Session;

public class EclipseLinkJPACacheLoader
extends Base
implements CacheLoader {
    private EntityManagerFactory emf;
    private ClassDescriptor descriptor;

    public EclipseLinkJPACacheLoader(String cacheName, String puName) {
        this.emf = Persistence.createEntityManagerFactory((String)puName);
        DatabaseSessionImpl session = JpaHelper.getEntityManagerFactory((EntityManagerFactory)this.emf).getDatabaseSession();
        this.descriptor = CoherenceCacheHelper.getDescriptor(cacheName, (Session)session, false);
        this.descriptor.setDefaultQueryRedirector((QueryRedirector)new DontMaintainCacheRedirector());
        this.descriptor.setUnitOfWorkCacheIsolationLevel(4);
        this.descriptor.setOptimisticLockingPolicy(null);
        this.descriptor.setSequenceNumberName(null);
        this.descriptor.setSequenceNumberField(null);
    }

    protected EntityManagerFactory getEMF() {
        return this.emf;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Object id) {
        try (EntityManager em = this.getEMF().createEntityManager();){
            Object object = em.find(this.getDescriptor().getJavaClass(), id);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map loadAll(Collection ids) {
        try (EntityManager em = this.getEMF().createEntityManager();){
            HashMap map = new HashMap(ids.size());
            for (Object key : ids) {
                Object result = this.load(key);
                if (result == null) continue;
                map.put(key, result);
            }
            HashMap hashMap = map;
            return hashMap;
        }
    }
}

